/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hadoopbackport;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ThrottledInputStream
extends InputStream {
    private final InputStream rawStream;
    private final long maxBytesPerSec;
    private final long startTime = System.currentTimeMillis();
    private long bytesRead = 0L;
    private long totalSleepTime = 0L;
    private static final long SLEEP_DURATION_MS = 50L;

    public ThrottledInputStream(InputStream rawStream) {
        this(rawStream, Long.MAX_VALUE);
    }

    public ThrottledInputStream(InputStream rawStream, long maxBytesPerSec) {
        assert (maxBytesPerSec > 0L) : "Bandwidth " + maxBytesPerSec + " is invalid";
        this.rawStream = rawStream;
        this.maxBytesPerSec = maxBytesPerSec;
    }

    @Override
    public void close() throws IOException {
        this.rawStream.close();
    }

    @Override
    public int read() throws IOException {
        this.throttle();
        int data = this.rawStream.read();
        if (data != -1) {
            ++this.bytesRead;
        }
        return data;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.throttle();
        int readLen = this.rawStream.read(b);
        if (readLen != -1) {
            this.bytesRead += (long)readLen;
        }
        return readLen;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.throttle();
        int readLen = this.rawStream.read(b, off, len);
        if (readLen != -1) {
            this.bytesRead += (long)readLen;
        }
        return readLen;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        if (!(this.rawStream instanceof PositionedReadable)) {
            throw new UnsupportedOperationException("positioned read is not supported by the internal stream");
        }
        this.throttle();
        int readLen = ((PositionedReadable)this.rawStream).read(position, buffer, offset, length);
        if (readLen != -1) {
            this.bytesRead += (long)readLen;
        }
        return readLen;
    }

    private void throttle() throws IOException {
        while (this.getBytesPerSec() > this.maxBytesPerSec) {
            try {
                Thread.sleep(50L);
                this.totalSleepTime += 50L;
            }
            catch (InterruptedException e) {
                throw new IOException("Thread aborted", e);
            }
        }
    }

    public long getTotalBytesRead() {
        return this.bytesRead;
    }

    public long getBytesPerSec() {
        long elapsed = (System.currentTimeMillis() - this.startTime) / 1000L;
        if (elapsed == 0L) {
            return this.bytesRead;
        }
        return this.bytesRead / elapsed;
    }

    public long getTotalSleepTime() {
        return this.totalSleepTime;
    }

    public String toString() {
        return "ThrottledInputStream{bytesRead=" + this.bytesRead + ", maxBytesPerSec=" + this.maxBytesPerSec + ", bytesPerSec=" + this.getBytesPerSec() + ", totalSleepTime=" + this.totalSleepTime + "}";
    }
}

