/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.KerberosAuthMethod;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.kerby.util.IOUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRMNMSecretKeys {
    private static final String KRB5_CONF = "java.security.krb5.conf";
    private static final File KRB5_CONF_ROOT_DIR = new File(System.getProperty("test.build.dir", "target/test-dir"), UUID.randomUUID().toString());

    @BeforeClass
    public static void setup() throws IOException {
        KRB5_CONF_ROOT_DIR.mkdir();
        File krb5ConfFile = new File(KRB5_CONF_ROOT_DIR, "krb5.conf");
        krb5ConfFile.createNewFile();
        String content = "[libdefaults]\n    default_realm = APACHE.ORG\n    udp_preference_limit = 1\n    extra_addresses = 127.0.0.1\n[realms]\n    APACHE.ORG = {\n        admin_server = localhost:88\n        kdc = localhost:88\n}\n[domain_realm]\n    localhost = APACHE.ORG";
        IOUtil.writeFile((String)content, (File)krb5ConfFile);
        System.setProperty(KRB5_CONF, krb5ConfFile.getAbsolutePath());
    }

    @AfterClass
    public static void tearDown() throws IOException {
        KRB5_CONF_ROOT_DIR.delete();
    }

    @Test(timeout=1000000L)
    public void testNMUpdation() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.webapp.api-service.enable", false);
        this.validateRMNMKeyExchange(conf);
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.validateRMNMKeyExchange(conf);
    }

    private void validateRMNMKeyExchange(YarnConfiguration conf) throws Exception {
        final DrainDispatcher dispatcher = new DrainDispatcher();
        ResourceManager rm = new ResourceManager(){

            protected void doSecureLogin() throws IOException {
            }

            protected Dispatcher createDispatcher() {
                return dispatcher;
            }

            protected void startWepApp() {
            }
        };
        rm.init((Configuration)conf);
        rm.start();
        String containerToken = "Container Token : ";
        String nmToken = "NM Token : ";
        MockNM nm = new MockNM("host:1234", 3072, rm.getResourceTrackerService());
        RegisterNodeManagerResponse registrationResponse = nm.registerNode();
        MasterKey containerTokenMasterKey = registrationResponse.getContainerTokenMasterKey();
        Assert.assertNotNull((String)(containerToken + "Registration should cause a key-update!"), (Object)containerTokenMasterKey);
        MasterKey nmTokenMasterKey = registrationResponse.getNMTokenMasterKey();
        Assert.assertNotNull((String)(nmToken + "Registration should cause a key-update!"), (Object)nmTokenMasterKey);
        dispatcher.await();
        NodeHeartbeatResponse response = nm.nodeHeartbeat(true);
        Assert.assertNull((String)(containerToken + "First heartbeat after registration shouldn't get any key updates!"), (Object)response.getContainerTokenMasterKey());
        Assert.assertNull((String)(nmToken + "First heartbeat after registration shouldn't get any key updates!"), (Object)response.getNMTokenMasterKey());
        dispatcher.await();
        response = nm.nodeHeartbeat(true);
        Assert.assertNull((String)(containerToken + "Even second heartbeat after registration shouldn't get any key updates!"), (Object)response.getContainerTokenMasterKey());
        Assert.assertNull((String)(nmToken + "Even second heartbeat after registration shouldn't get any key updates!"), (Object)response.getContainerTokenMasterKey());
        dispatcher.await();
        rm.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        rm.getRMContext().getNMTokenSecretManager().rollMasterKey();
        response = nm.nodeHeartbeat(true);
        Assert.assertNotNull((String)(containerToken + "Heartbeats after roll-over and before activation should not err out."), (Object)response.getContainerTokenMasterKey());
        Assert.assertNotNull((String)(nmToken + "Heartbeats after roll-over and before activation should not err out."), (Object)response.getNMTokenMasterKey());
        Assert.assertEquals((String)(containerToken + "Roll-over should have incremented the key-id only by one!"), (long)(containerTokenMasterKey.getKeyId() + 1), (long)response.getContainerTokenMasterKey().getKeyId());
        Assert.assertEquals((String)(nmToken + "Roll-over should have incremented the key-id only by one!"), (long)(nmTokenMasterKey.getKeyId() + 1), (long)response.getNMTokenMasterKey().getKeyId());
        dispatcher.await();
        response = nm.nodeHeartbeat(true);
        Assert.assertNull((String)(containerToken + "Second heartbeat after roll-over shouldn't get any key updates!"), (Object)response.getContainerTokenMasterKey());
        Assert.assertNull((String)(nmToken + "Second heartbeat after roll-over shouldn't get any key updates!"), (Object)response.getNMTokenMasterKey());
        dispatcher.await();
        rm.getRMContext().getContainerTokenSecretManager().activateNextMasterKey();
        rm.getRMContext().getNMTokenSecretManager().activateNextMasterKey();
        response = nm.nodeHeartbeat(true);
        Assert.assertNull((String)(containerToken + "Activation shouldn't cause any key updates!"), (Object)response.getContainerTokenMasterKey());
        Assert.assertNull((String)(nmToken + "Activation shouldn't cause any key updates!"), (Object)response.getNMTokenMasterKey());
        dispatcher.await();
        response = nm.nodeHeartbeat(true);
        Assert.assertNull((String)(containerToken + "Even second heartbeat after activation shouldn't get any key updates!"), (Object)response.getContainerTokenMasterKey());
        Assert.assertNull((String)(nmToken + "Even second heartbeat after activation shouldn't get any key updates!"), (Object)response.getNMTokenMasterKey());
        dispatcher.await();
        rm.stop();
    }
}

