/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import com.github.davidmoten.rx.Checked;
import com.github.davidmoten.rx.Functions;
import com.github.davidmoten.util.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.plugins.RxJavaHooks;

public class ResourceManager<T> {
    private final Func0<T> resourceFactory;
    private final Action1<? super T> disposeAction;
    private final boolean disposeEagerly;

    protected ResourceManager(Func0<T> resourceFactory, Action1<? super T> disposeAction, boolean disposeEagerly) {
        Preconditions.checkNotNull(resourceFactory);
        Preconditions.checkNotNull(disposeAction);
        this.resourceFactory = resourceFactory;
        this.disposeAction = disposeAction;
        this.disposeEagerly = disposeEagerly;
    }

    public static <T> ResourceManagerBuilder<T> resourceFactory(Func0<T> resourceFactory) {
        return new ResourceManagerBuilder(resourceFactory);
    }

    public static <T extends Closeable> CloseableResourceManagerBuilder<T> closeableResourceFactory(Func0<T> resourceFactory) {
        return new CloseableResourceManagerBuilder(resourceFactory);
    }

    public static <T> ResourceManager<T> create(Func0<T> resourceFactory, Action1<? super T> disposeAction) {
        return new ResourceManager<T>(resourceFactory, disposeAction, false);
    }

    public static <T> ResourceManager<T> create(Callable<T> resourceFactory, Action1<? super T> disposeAction) {
        return new ResourceManager<T>(Functions.toFunc0(resourceFactory), disposeAction, false);
    }

    public static <T> ResourceManager<T> create(Callable<T> resourceFactory, Checked.A1<? super T> disposeAction) {
        return new ResourceManager<T>(Functions.toFunc0(resourceFactory), Checked.a1(disposeAction), false);
    }

    public static <T extends Closeable> ResourceManager<T> create(Func0<T> resourceFactory) {
        return ResourceManager.create(resourceFactory, CloserHolder.INSTANCE);
    }

    public static <T extends Closeable> ResourceManager<T> create(Callable<T> resourceFactory) {
        return ResourceManager.create(Functions.toFunc0(resourceFactory), CloserHolder.INSTANCE);
    }

    public <R> Observable<R> observable(Func1<? super T, ? extends Observable<? extends R>> observableFactory) {
        return Observable.using(this.resourceFactory, observableFactory, this.disposeAction, (boolean)this.disposeEagerly);
    }

    public <R> ResourceManager<R> map(Checked.F1<? super T, ? extends R> resourceMapper, Checked.A1<? super R> disposeAction) {
        return this.map(Checked.f1(resourceMapper), Checked.a1(disposeAction));
    }

    public <R> ResourceManager<R> map(final Func1<? super T, ? extends R> resourceMapper, final Action1<? super R> disposeAction) {
        final AtomicReference ref = new AtomicReference();
        Func0 rf = new Func0<R>(){

            public R call() {
                Object a = ResourceManager.this.resourceFactory.call();
                try {
                    Object b = resourceMapper.call(a);
                    ref.set(a);
                    return b;
                }
                catch (Throwable e) {
                    ResourceManager.this.disposeAction.call(a);
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
        };
        Action1 disposer = new Action1<R>(){

            public void call(R r) {
                try {
                    disposeAction.call(r);
                }
                catch (Throwable e) {
                    RxJavaHooks.onError((Throwable)e);
                }
                try {
                    ResourceManager.this.disposeAction.call(ref.get());
                }
                catch (Throwable e) {
                    RxJavaHooks.onError((Throwable)e);
                }
            }
        };
        return ResourceManager.create(rf, disposer);
    }

    public <R extends Closeable> ResourceManager<R> map(Func1<? super T, ? extends R> resourceMapper) {
        return this.map(resourceMapper, CloserHolder.INSTANCE);
    }

    private static final class CloserHolder {
        static final Action1<Closeable> INSTANCE = new Action1<Closeable>(){

            public void call(Closeable c) {
                try {
                    c.close();
                }
                catch (IOException e) {
                    RxJavaHooks.onError((Throwable)e);
                }
            }
        };

        private CloserHolder() {
        }
    }

    public static final class CloseableResourceManagerBuilder<T extends Closeable> {
        private final Func0<T> resourceFactory;
        private boolean disposeEagerly = false;

        private CloseableResourceManagerBuilder(Func0<T> resourceFactory) {
            this.resourceFactory = resourceFactory;
        }

        public CloseableResourceManagerBuilder<T> disposeEagerly(boolean value) {
            this.disposeEagerly = value;
            return this;
        }

        public ResourceManager<T> create() {
            return new ResourceManager<Closeable>(this.resourceFactory, CloserHolder.INSTANCE, this.disposeEagerly);
        }
    }

    public static final class ResourceManagerBuilder<T> {
        private final Func0<T> resourceFactory;
        private boolean disposeEagerly = false;

        private ResourceManagerBuilder(Func0<T> resourceFactory) {
            this.resourceFactory = resourceFactory;
        }

        public ResourceManagerBuilder<T> disposeEagerly(boolean value) {
            this.disposeEagerly = value;
            return this;
        }

        public ResourceManager<T> disposeAction(Action1<? super T> disposeAction) {
            return new ResourceManager<T>(this.resourceFactory, disposeAction, this.disposeEagerly);
        }
    }
}

