/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.net.ConnectTimeoutException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.client.RMFailoverProxyProvider;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RMProxy<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RMProxy.class);
    private UserGroupInformation user;

    protected RMProxy() {
        try {
            this.user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            throw new YarnRuntimeException("Unable to determine user", (Throwable)ioe);
        }
    }

    @InterfaceAudience.Private
    public void checkAllowedProtocols(Class<?> protocol) {
    }

    @InterfaceAudience.Private
    public InetSocketAddress getRMAddress(YarnConfiguration conf, Class<?> protocol) throws IOException {
        throw new UnsupportedOperationException("This method should be invoked from an instance of ClientRMProxy or ServerRMProxy");
    }

    @InterfaceAudience.Private
    protected static <T> T createRMProxy(Configuration configuration, Class<T> protocol, RMProxy<T> instance) throws IOException {
        YarnConfiguration conf = configuration instanceof YarnConfiguration ? (YarnConfiguration)configuration : new YarnConfiguration(configuration);
        boolean isHAEnabled = HAUtil.isHAEnabled((Configuration)conf) || HAUtil.isFederationFailoverEnabled((Configuration)conf) || HAUtil.isCustomRMHAEnabled((Configuration)conf);
        RetryPolicy retryPolicy = RMProxy.createRetryPolicy((Configuration)conf, isHAEnabled);
        return RMProxy.newProxyInstance(conf, protocol, instance, retryPolicy);
    }

    @InterfaceAudience.Private
    protected static <T> T createRMProxy(Configuration configuration, Class<T> protocol, RMProxy<T> instance, long retryTime, long retryInterval) throws IOException {
        YarnConfiguration conf = configuration instanceof YarnConfiguration ? (YarnConfiguration)configuration : new YarnConfiguration(configuration);
        boolean isHAEnabled = HAUtil.isHAEnabled((Configuration)conf) || HAUtil.isFederationFailoverEnabled((Configuration)conf) || HAUtil.isCustomRMHAEnabled((Configuration)conf);
        RetryPolicy retryPolicy = RMProxy.createRetryPolicy((Configuration)conf, retryTime, retryInterval, isHAEnabled);
        return RMProxy.newProxyInstance(conf, protocol, instance, retryPolicy);
    }

    private static <T> T newProxyInstance(YarnConfiguration conf, Class<T> protocol, RMProxy<T> instance, RetryPolicy retryPolicy) throws IOException {
        RMFailoverProxyProvider<T> provider = HAUtil.isHAEnabled((Configuration)conf) || HAUtil.isFederationEnabled((Configuration)conf) || HAUtil.isCustomRMHAEnabled((Configuration)conf) ? super.createRMFailoverProxyProvider((Configuration)conf, protocol) : super.createNonHaRMFailoverProxyProvider((Configuration)conf, protocol);
        return (T)RetryProxy.create(protocol, provider, (RetryPolicy)retryPolicy);
    }

    @InterfaceAudience.Private
    public <T> T getProxy(final Configuration conf, final Class<T> protocol, final InetSocketAddress rmAddress) throws IOException {
        return (T)this.user.doAs(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return YarnRPC.create(conf).getProxy(protocol, rmAddress, conf);
            }
        });
    }

    private <T> RMFailoverProxyProvider<T> createNonHaRMFailoverProxyProvider(Configuration conf, Class<T> protocol) {
        Class<?> defaultProviderClass;
        try {
            defaultProviderClass = Class.forName("org.apache.hadoop.yarn.client.DefaultNoHARMFailoverProxyProvider");
        }
        catch (Exception e) {
            throw new YarnRuntimeException("Invalid default failover provider classorg.apache.hadoop.yarn.client.DefaultNoHARMFailoverProxyProvider", (Throwable)e);
        }
        RMFailoverProxyProvider provider = (RMFailoverProxyProvider)ReflectionUtils.newInstance((Class)conf.getClass("yarn.client.failover-no-ha-proxy-provider", defaultProviderClass, RMFailoverProxyProvider.class), (Configuration)conf);
        provider.init(conf, this, protocol);
        return provider;
    }

    private <T> RMFailoverProxyProvider<T> createRMFailoverProxyProvider(Configuration conf, Class<T> protocol) {
        Class<?> defaultProviderClass;
        try {
            defaultProviderClass = Class.forName("org.apache.hadoop.yarn.client.ConfiguredRMFailoverProxyProvider");
        }
        catch (Exception e) {
            throw new YarnRuntimeException("Invalid default failover provider classorg.apache.hadoop.yarn.client.ConfiguredRMFailoverProxyProvider", (Throwable)e);
        }
        RMFailoverProxyProvider provider = (RMFailoverProxyProvider)ReflectionUtils.newInstance((Class)conf.getClass("yarn.client.failover-proxy-provider", defaultProviderClass, RMFailoverProxyProvider.class), (Configuration)conf);
        provider.init(conf, this, protocol);
        return provider;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static RetryPolicy createRetryPolicy(Configuration conf, boolean isHAEnabled) {
        long rmConnectWaitMS = conf.getLong("yarn.resourcemanager.connect.max-wait.ms", 900000L);
        long rmConnectionRetryIntervalMS = conf.getLong("yarn.resourcemanager.connect.retry-interval.ms", 30000L);
        return RMProxy.createRetryPolicy(conf, rmConnectWaitMS, rmConnectionRetryIntervalMS, isHAEnabled);
    }

    protected static RetryPolicy createRetryPolicy(Configuration conf, long retryTime, long retryInterval, boolean isHAEnabled) {
        boolean waitForEver;
        long rmConnectWaitMS = retryTime;
        long rmConnectionRetryIntervalMS = retryInterval;
        boolean bl = waitForEver = rmConnectWaitMS == -1L;
        if (!waitForEver) {
            if (rmConnectWaitMS < 0L) {
                throw new YarnRuntimeException("Invalid Configuration. yarn.resourcemanager.connect.max-wait.ms can be -1, but can not be other negative numbers");
            }
            if (rmConnectWaitMS < rmConnectionRetryIntervalMS) {
                LOG.warn("yarn.resourcemanager.connect.max-wait.ms is smaller than yarn.resourcemanager.connect.retry-interval.ms. Only try connect once.");
                rmConnectWaitMS = 0L;
            }
        }
        if (isHAEnabled) {
            long failoverSleepBaseMs = conf.getLong("yarn.client.failover-sleep-base-ms", rmConnectionRetryIntervalMS);
            long failoverSleepMaxMs = conf.getLong("yarn.client.failover-sleep-max-ms", rmConnectionRetryIntervalMS);
            int maxFailoverAttempts = conf.getInt("yarn.client.failover-max-attempts", -1);
            if (maxFailoverAttempts == -1) {
                maxFailoverAttempts = waitForEver ? Integer.MAX_VALUE : (int)(rmConnectWaitMS / failoverSleepBaseMs);
            }
            return RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)maxFailoverAttempts, (long)failoverSleepBaseMs, (long)failoverSleepMaxMs);
        }
        if (rmConnectionRetryIntervalMS < 0L) {
            throw new YarnRuntimeException("Invalid Configuration. yarn.resourcemanager.connect.retry-interval.ms should not be negative.");
        }
        RetryPolicy retryPolicy = null;
        retryPolicy = waitForEver ? RetryPolicies.retryForeverWithFixedSleep((long)rmConnectionRetryIntervalMS, (TimeUnit)TimeUnit.MILLISECONDS) : RetryPolicies.retryUpToMaximumTimeWithFixedSleep((long)rmConnectWaitMS, (long)rmConnectionRetryIntervalMS, (TimeUnit)TimeUnit.MILLISECONDS);
        HashMap<Class, RetryPolicy> exceptionToPolicyMap = new HashMap<Class, RetryPolicy>();
        exceptionToPolicyMap.put(EOFException.class, retryPolicy);
        exceptionToPolicyMap.put(ConnectException.class, retryPolicy);
        exceptionToPolicyMap.put(NoRouteToHostException.class, retryPolicy);
        exceptionToPolicyMap.put(UnknownHostException.class, retryPolicy);
        exceptionToPolicyMap.put(ConnectTimeoutException.class, retryPolicy);
        exceptionToPolicyMap.put(RetriableException.class, retryPolicy);
        exceptionToPolicyMap.put(SocketException.class, retryPolicy);
        exceptionToPolicyMap.put(SocketTimeoutException.class, retryPolicy);
        exceptionToPolicyMap.put(StandbyException.class, retryPolicy);
        exceptionToPolicyMap.put(IOException.class, retryPolicy);
        return RetryPolicies.retryOtherThanRemoteException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
    }
}

