/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterHeartbeatService;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRouter {
    private static Configuration conf;

    @BeforeClass
    public static void create() throws IOException {
        conf = new Configuration();
        conf.setInt("dfs.federation.router.cache.ttl", 1);
        conf.setClass("dfs.federation.router.namenode.resolver.client.class", MockResolver.class, ActiveNamenodeResolver.class);
        conf.setClass("dfs.federation.router.file.resolver.client.class", MockResolver.class, FileSubclusterResolver.class);
        conf.set("dfs.federation.router.rpc-bind-host", "0.0.0.0");
        conf.set("dfs.federation.router.rpc-address", "127.0.0.1:0");
        conf.set("dfs.federation.router.admin-address", "127.0.0.1:0");
        conf.set("dfs.federation.router.admin-bind-host", "0.0.0.0");
        conf.set("dfs.federation.router.http-address", "127.0.0.1:0");
        conf.set("dfs.federation.router.https-address", "127.0.0.1:0");
        conf.set("dfs.federation.router.http-bind-host", "0.0.0.0");
        conf.set("dfs.nameservices", "ns0");
        conf.set("fs.defaultFS", "hdfs://ns0");
        conf.set("dfs.namenode.rpc-address.ns0", "127.0.0.1:00");
        conf.set("dfs.namenode.http-address.ns0", "127.0.0.1:0");
        conf.set("dfs.namenode.rpc-bind-host.ns0", "0.0.0.0");
    }

    private static void testRouterStartup(Configuration routerConfig) throws InterruptedException, IOException {
        Router router = new Router();
        Assert.assertEquals((Object)Service.STATE.NOTINITED, (Object)router.getServiceState());
        Assert.assertEquals((Object)RouterServiceState.UNINITIALIZED, (Object)router.getRouterState());
        router.init(routerConfig);
        if (routerConfig.getBoolean("dfs.federation.router.safemode.enable", true)) {
            Assert.assertEquals((Object)RouterServiceState.SAFEMODE, (Object)router.getRouterState());
        } else {
            Assert.assertEquals((Object)RouterServiceState.INITIALIZING, (Object)router.getRouterState());
        }
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)router.getServiceState());
        router.start();
        if (routerConfig.getBoolean("dfs.federation.router.safemode.enable", true)) {
            Assert.assertEquals((Object)RouterServiceState.SAFEMODE, (Object)router.getRouterState());
        } else {
            Assert.assertEquals((Object)RouterServiceState.RUNNING, (Object)router.getRouterState());
        }
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)router.getServiceState());
        router.stop();
        Assert.assertEquals((Object)RouterServiceState.SHUTDOWN, (Object)router.getRouterState());
        Assert.assertEquals((Object)Service.STATE.STOPPED, (Object)router.getServiceState());
        router.close();
    }

    @Test
    public void testRouterService() throws InterruptedException, IOException {
        TestRouter.testRouterStartup(new RouterConfigBuilder(conf).admin().build());
        TestRouter.testRouterStartup(new RouterConfigBuilder(conf).http().build());
        TestRouter.testRouterStartup(new RouterConfigBuilder(conf).rpc().build());
        TestRouter.testRouterStartup(new RouterConfigBuilder(conf).rpc().safemode().build());
        TestRouter.testRouterStartup(new RouterConfigBuilder(conf).metrics().build());
        TestRouter.testRouterStartup(new RouterConfigBuilder(conf).stateStore().build());
        TestRouter.testRouterStartup(new RouterConfigBuilder(conf).heartbeat().build());
        TestRouter.testRouterStartup(new RouterConfigBuilder(conf).all().build());
    }

    @Test
    public void testRouterRestartRpcService() throws IOException {
        Router router = new Router();
        router.init(new RouterConfigBuilder(conf).rpc().build());
        router.start();
        Assert.assertNotNull((Object)router.getRpcServerAddress());
        RouterRpcServer rpcServer = router.getRpcServer();
        Assert.assertNotNull((Object)rpcServer);
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)rpcServer.getServiceState());
        router.stop();
        Assert.assertEquals((Object)Service.STATE.STOPPED, (Object)rpcServer.getServiceState());
        router.close();
    }

    @Test
    public void testRouterRpcWithNoSubclusters() throws IOException {
        Router router = new Router();
        router.init(new RouterConfigBuilder(conf).rpc().build());
        router.start();
        InetSocketAddress serverAddress = router.getRpcServerAddress();
        DFSClient dfsClient = new DFSClient(serverAddress, conf);
        try {
            dfsClient.create("/test.txt", false);
            Assert.fail((String)"Create with no subclusters should fail");
        }
        catch (RemoteException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot find locations for /test.txt", (Throwable)e);
        }
        try {
            dfsClient.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            Assert.fail((String)"Get datanode reports with no subclusters should fail");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"No remote locations available", (Throwable)e);
        }
        dfsClient.close();
        router.stop();
        router.close();
    }

    @Test
    public void testRouterIDInRouterRpcClient() throws Exception {
        Router router = new Router();
        router.init(new RouterConfigBuilder(conf).rpc().build());
        router.setRouterId("Router-0");
        RemoteMethod remoteMethod = (RemoteMethod)Mockito.mock(RemoteMethod.class);
        LambdaTestUtils.intercept(IOException.class, (String)"Router-0", () -> router.getRpcServer().getRPCClient().invokeSingle("ns0", remoteMethod));
        router.stop();
        router.close();
    }

    @Test
    public void testRouterMetricsWhenDisabled() throws Exception {
        Router router = new Router();
        router.init(new RouterConfigBuilder(conf).rpc().build());
        router.start();
        LambdaTestUtils.intercept(IOException.class, (String)"Namenode metrics is not initialized", () -> router.getNamenodeMetrics().getCacheCapacity());
        router.stop();
        router.close();
    }

    @Test
    public void testSwitchRouter() throws IOException {
        this.assertRouterHeartbeater(true, true);
        this.assertRouterHeartbeater(true, false);
        this.assertRouterHeartbeater(false, true);
        this.assertRouterHeartbeater(false, false);
    }

    private void assertRouterHeartbeater(boolean expectedRouterHeartbeat, boolean expectedNNHeartbeat) throws IOException {
        Router router = new Router();
        Configuration baseCfg = new RouterConfigBuilder(conf).rpc().build();
        baseCfg.setBoolean("dfs.federation.router.heartbeat.enable", expectedRouterHeartbeat);
        baseCfg.setBoolean("dfs.federation.router.namenode.heartbeat.enable", expectedNNHeartbeat);
        router.init(baseCfg);
        RouterHeartbeatService routerHeartbeatService = router.getRouterHeartbeatService();
        if (expectedRouterHeartbeat) {
            Assert.assertNotNull((Object)routerHeartbeatService);
        } else {
            Assert.assertNull((Object)routerHeartbeatService);
        }
        Collection namenodeHeartbeatServices = router.getNamenodeHeartbeatServices();
        if (expectedNNHeartbeat) {
            Assert.assertNotNull((Object)namenodeHeartbeatServices);
        } else {
            Assert.assertNull((Object)namenodeHeartbeatServices);
        }
        router.close();
    }

    @Test
    public void testNamenodeHeartBeatEnableDefault() throws IOException {
        this.checkNamenodeHeartBeatEnableDefault(true);
        this.checkNamenodeHeartBeatEnableDefault(false);
    }

    private void checkNamenodeHeartBeatEnableDefault(boolean enable) throws IOException {
        try (Router router = new Router();){
            HdfsConfiguration config = new HdfsConfiguration();
            config.set("dfs.federation.router.rpc-bind-host", "0.0.0.0");
            config.set("dfs.federation.router.rpc-address", "127.0.0.1:0");
            config.set("dfs.federation.router.admin-address", "127.0.0.1:0");
            config.set("dfs.federation.router.admin-bind-host", "0.0.0.0");
            config.set("dfs.federation.router.http-address", "127.0.0.1:0");
            config.set("dfs.federation.router.https-address", "127.0.0.1:0");
            config.set("dfs.federation.router.http-bind-host", "0.0.0.0");
            config.setBoolean("dfs.federation.router.heartbeat.enable", enable);
            router.init((Configuration)config);
            if (enable) {
                Assert.assertNotNull((Object)router.getNamenodeHeartbeatServices());
            } else {
                Assert.assertNull((Object)router.getNamenodeHeartbeatServices());
            }
        }
    }
}

