/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.DatanodeLifelineProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.protocol.DatanodeLifelineProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.protobuf.RpcController;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;

@InterfaceAudience.Private
public class DatanodeLifelineProtocolClientSideTranslatorPB
implements ProtocolMetaInterface,
DatanodeLifelineProtocol,
Closeable {
    private static final RpcController NULL_CONTROLLER = null;
    private final DatanodeLifelineProtocolPB rpcProxy;

    public DatanodeLifelineProtocolClientSideTranslatorPB(InetSocketAddress nameNodeAddr, Configuration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, DatanodeLifelineProtocolPB.class, ProtobufRpcEngine2.class);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        this.rpcProxy = DatanodeLifelineProtocolClientSideTranslatorPB.createNamenode(nameNodeAddr, conf, ugi);
    }

    private static DatanodeLifelineProtocolPB createNamenode(InetSocketAddress nameNodeAddr, Configuration conf, UserGroupInformation ugi) throws IOException {
        return (DatanodeLifelineProtocolPB)RPC.getProxy(DatanodeLifelineProtocolPB.class, (long)RPC.getProtocolVersion(DatanodeLifelineProtocolPB.class), (InetSocketAddress)nameNodeAddr, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getSocketFactory((Configuration)conf, DatanodeLifelineProtocolPB.class));
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public void sendLifeline(DatanodeRegistration registration, StorageReport[] reports, long cacheCapacity, long cacheUsed, int xmitsInProgress, int xceiverCount, int failedVolumes, VolumeFailureSummary volumeFailureSummary) throws IOException {
        DatanodeProtocolProtos.HeartbeatRequestProto.Builder builder = DatanodeProtocolProtos.HeartbeatRequestProto.newBuilder().setRegistration(PBHelper.convert(registration)).setXmitsInProgress(xmitsInProgress).setXceiverCount(xceiverCount).setFailedVolumes(failedVolumes);
        builder.addAllReports(PBHelperClient.convertStorageReports((StorageReport[])reports));
        if (cacheCapacity != 0L) {
            builder.setCacheCapacity(cacheCapacity);
        }
        if (cacheUsed != 0L) {
            builder.setCacheUsed(cacheUsed);
        }
        if (volumeFailureSummary != null) {
            builder.setVolumeFailureSummary(PBHelper.convertVolumeFailureSummary(volumeFailureSummary));
        }
        try {
            this.rpcProxy.sendLifeline(NULL_CONTROLLER, builder.build());
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException((ServiceException)se);
        }
    }

    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported((Object)this.rpcProxy, DatanodeLifelineProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(DatanodeLifelineProtocolPB.class), (String)methodName);
    }
}

