/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.security;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.timeline.security.TimelineDelgationTokenSecretManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineV2DelegationTokenSecretManagerService
extends TimelineDelgationTokenSecretManagerService {
    public TimelineV2DelegationTokenSecretManagerService() {
        super(TimelineV2DelegationTokenSecretManagerService.class.getName());
    }

    @Override
    protected AbstractDelegationTokenSecretManager<TimelineDelegationTokenIdentifier> createTimelineDelegationTokenSecretManager(long secretKeyInterval, long tokenMaxLifetime, long tokenRenewInterval, long tokenRemovalScanInterval) {
        return new TimelineV2DelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, tokenRemovalScanInterval);
    }

    public Token<TimelineDelegationTokenIdentifier> generateToken(UserGroupInformation ugi, String renewer) {
        return ((TimelineV2DelegationTokenSecretManager)this.getTimelineDelegationTokenSecretManager()).generateToken(ugi, renewer);
    }

    public long renewToken(Token<TimelineDelegationTokenIdentifier> token, String renewer) throws IOException {
        return this.getTimelineDelegationTokenSecretManager().renewToken(token, renewer);
    }

    public void cancelToken(Token<TimelineDelegationTokenIdentifier> token, String canceller) throws IOException {
        this.getTimelineDelegationTokenSecretManager().cancelToken(token, canceller);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class TimelineV2DelegationTokenSecretManager
    extends AbstractDelegationTokenSecretManager<TimelineDelegationTokenIdentifier> {
        private static final Logger LOG = LoggerFactory.getLogger(TimelineV2DelegationTokenSecretManager.class);

        public TimelineV2DelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        }

        public Token<TimelineDelegationTokenIdentifier> generateToken(UserGroupInformation ugi, String renewer) {
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            TimelineDelegationTokenIdentifier identifier = this.createIdentifier();
            identifier.setOwner(new Text(ugi.getUserName()));
            identifier.setRenewer(new Text(renewer));
            identifier.setRealUser(realUser);
            byte[] password = this.createPassword((AbstractDelegationTokenIdentifier)identifier);
            return new Token(identifier.getBytes(), password, identifier.getKind(), null);
        }

        public TimelineDelegationTokenIdentifier createIdentifier() {
            return new TimelineDelegationTokenIdentifier();
        }

        protected void logExpireToken(TimelineDelegationTokenIdentifier ident) throws IOException {
            LOG.info("Token " + ident + " expired.");
        }
    }
}

