/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.webproxy.ProxyCA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ProxyCAManager
extends AbstractService
implements Recoverable {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyCAManager.class);
    private ProxyCA proxyCA;
    private RMContext rmContext;
    private boolean wasRecovered;

    public ProxyCAManager(ProxyCA proxyCA, RMContext rmContext) {
        super(ProxyCAManager.class.getName());
        this.proxyCA = proxyCA;
        this.rmContext = rmContext;
        this.wasRecovered = false;
    }

    protected void serviceStart() throws Exception {
        if (!this.wasRecovered) {
            this.proxyCA.init();
        }
        this.wasRecovered = false;
        this.rmContext.getStateStore().storeProxyCACert(this.proxyCA.getCaCert(), this.proxyCA.getCaKeyPair().getPrivate());
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        super.serviceStop();
    }

    public ProxyCA getProxyCA() {
        return this.proxyCA;
    }

    @Override
    public void recover(RMStateStore.RMState state) throws GeneralSecurityException, IOException {
        LOG.info("Recovering CA Certificate and Private Key");
        X509Certificate caCert = state.getProxyCAState().getCaCert();
        PrivateKey caPrivateKey = state.getProxyCAState().getCaPrivateKey();
        this.proxyCA.init(caCert, caPrivateKey);
        this.wasRecovered = true;
    }
}

