/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.exceptions.InvalidRecordException;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRegistryBinder {
    private static final Logger log = LoggerFactory.getLogger(ClientRegistryBinder.class);
    private final RegistryOperations operations;

    public ClientRegistryBinder(RegistryOperations operations) {
        this.operations = operations;
    }

    public static String homePathForUser(String username) {
        Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"null user");
        if (username.startsWith("/users/")) {
            return username;
        }
        if (username.isEmpty()) {
            return "/services/";
        }
        String convertedName = RegistryUtils.convertUsername((String)username);
        return RegistryPathUtils.join((String)"/users/", (String)RegistryPathUtils.encodeForRegistry((String)convertedName));
    }

    public static String currentUsernameUnencoded() {
        String env_hadoop_username = System.getenv("HADOOP_USER_NAME");
        return RegistryUtils.getCurrentUsernameUnencoded((String)env_hadoop_username);
    }

    public static String qualifyUser(String user) {
        String t = user.trim();
        if (t.startsWith("/")) {
            return t;
        }
        if (t.equals("~")) {
            return ClientRegistryBinder.currentUsernameUnencoded();
        }
        if (t.startsWith("~")) {
            String convertedName = RegistryUtils.convertUsername((String)t.substring(1));
            return RegistryPathUtils.join((String)"/users/", (String)RegistryPathUtils.encodeForRegistry((String)convertedName));
        }
        return "/" + t;
    }

    public String lookupExternalRestAPI(String user, String serviceClass, String instance, String api) throws IOException {
        String qualified = ClientRegistryBinder.qualifyUser(user);
        String path = RegistryUtils.servicePath((String)qualified, (String)serviceClass, (String)instance);
        String restAPI = this.resolveExternalRestAPI(api, path);
        if (restAPI == null) {
            throw new PathNotFoundException(path + " API " + api);
        }
        return restAPI;
    }

    protected String resolveExternalRestAPI(String api, String path) throws IOException {
        ServiceRecord record = this.operations.resolve(path);
        return ClientRegistryBinder.lookupRestAPI(record, api, true);
    }

    public static String lookupRestAPI(ServiceRecord record, String api, boolean external) throws InvalidRecordException {
        try {
            String url = null;
            Endpoint endpoint = ClientRegistryBinder.getEndpoint(record, api, external);
            List addresses = RegistryTypeUtils.retrieveAddressesUriType((Endpoint)endpoint);
            if (addresses != null && !addresses.isEmpty()) {
                url = (String)addresses.get(0);
            }
            return url;
        }
        catch (InvalidRecordException e) {
            log.debug("looking for API {}", (Object)api, (Object)e);
            return null;
        }
    }

    public static Endpoint getEndpoint(ServiceRecord record, String api, boolean external) {
        return external ? record.getExternalEndpoint(api) : record.getInternalEndpoint(api);
    }
}

