/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager.webapp;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.server.sharedcachemanager.SharedCacheManager;
import org.apache.hadoop.yarn.server.sharedcachemanager.webapp.SCMController;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SCMWebServer
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(SCMWebServer.class);
    private final SharedCacheManager scm;
    private WebApp webApp;
    private String bindAddress;

    public SCMWebServer(SharedCacheManager scm) {
        super(SCMWebServer.class.getName());
        this.scm = scm;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.bindAddress = this.getBindAddress(conf);
        super.serviceInit(conf);
    }

    private String getBindAddress(Configuration conf) {
        return conf.get("yarn.sharedcache.webapp.address", "0.0.0.0:8788");
    }

    protected void serviceStart() throws Exception {
        SCMWebApp scmWebApp = new SCMWebApp(this.scm);
        this.webApp = WebApps.$for((String)"sharedcache").at(this.bindAddress).start((WebApp)scmWebApp);
        LOG.info("Instantiated " + SCMWebApp.class.getName() + " at " + this.bindAddress);
    }

    protected void serviceStop() throws Exception {
        if (this.webApp != null) {
            this.webApp.stop();
        }
    }

    private class SCMWebApp
    extends WebApp {
        private final SharedCacheManager scm;

        public SCMWebApp(SharedCacheManager scm) {
            this.scm = scm;
        }

        public void setup() {
            if (this.scm != null) {
                this.bind(SharedCacheManager.class).toInstance((Object)this.scm);
            }
            this.route("/", SCMController.class, "overview");
        }
    }
}

