/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.impl.pb.client;

import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetClusterNodeLabelsRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.GetClusterNodeLabelsResponsePBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.RefreshClusterNodeLabelsRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.RefreshClusterNodeLabelsResponsePBImpl;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocolPB;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterMaprNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterMaprNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterMaprNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterMaprNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceMaprLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceMaprLabelsOnNodeResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.AddToClusterMaprNodeLabelsRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.AddToClusterMaprNodeLabelsResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.AddToClusterNodeLabelsRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.AddToClusterNodeLabelsResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RefreshAdminAclsRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RefreshAdminAclsResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RefreshNodesRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RefreshNodesResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RefreshQueuesRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RefreshQueuesResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RefreshServiceAclsRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RefreshServiceAclsResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RefreshSuperUserGroupsConfigurationRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RefreshSuperUserGroupsConfigurationResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RefreshUserToGroupsMappingsRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RefreshUserToGroupsMappingsResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RemoveFromClusterMaprNodeLabelsRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RemoveFromClusterMaprNodeLabelsResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RemoveFromClusterNodeLabelsRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RemoveFromClusterNodeLabelsResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.ReplaceLabelsOnNodeRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.ReplaceLabelsOnNodeResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.ReplaceMaprLabelsOnNodeRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.ReplaceMaprLabelsOnNodeResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.UpdateNodeResourceRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.UpdateNodeResourceResponsePBImpl;

@InterfaceAudience.Private
public class ResourceManagerAdministrationProtocolPBClientImpl
implements ResourceManagerAdministrationProtocol,
Closeable {
    private ResourceManagerAdministrationProtocolPB proxy;

    public ResourceManagerAdministrationProtocolPBClientImpl(long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ResourceManagerAdministrationProtocolPB.class, ProtobufRpcEngine.class);
        this.proxy = (ResourceManagerAdministrationProtocolPB)RPC.getProxy(ResourceManagerAdministrationProtocolPB.class, (long)clientVersion, (InetSocketAddress)addr, (Configuration)conf);
    }

    @Override
    public void close() {
        if (this.proxy != null) {
            RPC.stopProxy((Object)this.proxy);
        }
    }

    public RefreshQueuesResponse refreshQueues(RefreshQueuesRequest request) throws YarnException, IOException {
        YarnServerResourceManagerServiceProtos.RefreshQueuesRequestProto requestProto = ((RefreshQueuesRequestPBImpl)request).getProto();
        try {
            return new RefreshQueuesResponsePBImpl(this.proxy.refreshQueues(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    public RefreshNodesResponse refreshNodes(RefreshNodesRequest request) throws YarnException, IOException {
        YarnServerResourceManagerServiceProtos.RefreshNodesRequestProto requestProto = ((RefreshNodesRequestPBImpl)request).getProto();
        try {
            return new RefreshNodesResponsePBImpl(this.proxy.refreshNodes(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    public RefreshSuperUserGroupsConfigurationResponse refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest request) throws YarnException, IOException {
        YarnServerResourceManagerServiceProtos.RefreshSuperUserGroupsConfigurationRequestProto requestProto = ((RefreshSuperUserGroupsConfigurationRequestPBImpl)request).getProto();
        try {
            return new RefreshSuperUserGroupsConfigurationResponsePBImpl(this.proxy.refreshSuperUserGroupsConfiguration(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    public RefreshUserToGroupsMappingsResponse refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest request) throws YarnException, IOException {
        YarnServerResourceManagerServiceProtos.RefreshUserToGroupsMappingsRequestProto requestProto = ((RefreshUserToGroupsMappingsRequestPBImpl)request).getProto();
        try {
            return new RefreshUserToGroupsMappingsResponsePBImpl(this.proxy.refreshUserToGroupsMappings(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    public RefreshAdminAclsResponse refreshAdminAcls(RefreshAdminAclsRequest request) throws YarnException, IOException {
        YarnServerResourceManagerServiceProtos.RefreshAdminAclsRequestProto requestProto = ((RefreshAdminAclsRequestPBImpl)request).getProto();
        try {
            return new RefreshAdminAclsResponsePBImpl(this.proxy.refreshAdminAcls(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    public RefreshServiceAclsResponse refreshServiceAcls(RefreshServiceAclsRequest request) throws YarnException, IOException {
        YarnServerResourceManagerServiceProtos.RefreshServiceAclsRequestProto requestProto = ((RefreshServiceAclsRequestPBImpl)request).getProto();
        try {
            return new RefreshServiceAclsResponsePBImpl(this.proxy.refreshServiceAcls(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    public String[] getGroupsForUser(String user) throws IOException {
        YarnServerResourceManagerServiceProtos.GetGroupsForUserRequestProto requestProto = YarnServerResourceManagerServiceProtos.GetGroupsForUserRequestProto.newBuilder().setUser(user).build();
        try {
            YarnServerResourceManagerServiceProtos.GetGroupsForUserResponseProto responseProto = this.proxy.getGroupsForUser(null, requestProto);
            return (String[])responseProto.getGroupsList().toArray((Object[])new String[responseProto.getGroupsCount()]);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    public UpdateNodeResourceResponse updateNodeResource(UpdateNodeResourceRequest request) throws YarnException, IOException {
        YarnServerResourceManagerServiceProtos.UpdateNodeResourceRequestProto requestProto = ((UpdateNodeResourceRequestPBImpl)request).getProto();
        try {
            return new UpdateNodeResourceResponsePBImpl(this.proxy.updateNodeResource(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    public AddToClusterNodeLabelsResponse addToClusterNodeLabels(AddToClusterNodeLabelsRequest request) throws YarnException, IOException {
        YarnServerResourceManagerServiceProtos.AddToClusterNodeLabelsRequestProto requestProto = ((AddToClusterNodeLabelsRequestPBImpl)request).getProto();
        try {
            return new AddToClusterNodeLabelsResponsePBImpl(this.proxy.addToClusterNodeLabels(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    public AddToClusterMaprNodeLabelsResponse addToClusterMaprNodeLabels(AddToClusterMaprNodeLabelsRequest request) throws YarnException, IOException {
        YarnServerResourceManagerServiceProtos.AddToClusterMaprNodeLabelsRequestProto requestProto = ((AddToClusterMaprNodeLabelsRequestPBImpl)request).getProto();
        try {
            return new AddToClusterMaprNodeLabelsResponsePBImpl(this.proxy.addToClusterMaprNodeLabels(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    public RemoveFromClusterNodeLabelsResponse removeFromClusterNodeLabels(RemoveFromClusterNodeLabelsRequest request) throws YarnException, IOException {
        YarnServerResourceManagerServiceProtos.RemoveFromClusterNodeLabelsRequestProto requestProto = ((RemoveFromClusterNodeLabelsRequestPBImpl)request).getProto();
        try {
            return new RemoveFromClusterNodeLabelsResponsePBImpl(this.proxy.removeFromClusterNodeLabels(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    public RemoveFromClusterMaprNodeLabelsResponse removeFromClusterMaprNodeLabels(RemoveFromClusterMaprNodeLabelsRequest request) throws YarnException, IOException {
        YarnServerResourceManagerServiceProtos.RemoveFromClusterMaprNodeLabelsRequestProto requestProto = ((RemoveFromClusterMaprNodeLabelsRequestPBImpl)request).getProto();
        try {
            return new RemoveFromClusterMaprNodeLabelsResponsePBImpl(this.proxy.removeFromClusterMaprNodeLabels(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    public ReplaceLabelsOnNodeResponse replaceLabelsOnNode(ReplaceLabelsOnNodeRequest request) throws YarnException, IOException {
        YarnServerResourceManagerServiceProtos.ReplaceLabelsOnNodeRequestProto requestProto = ((ReplaceLabelsOnNodeRequestPBImpl)request).getProto();
        try {
            return new ReplaceLabelsOnNodeResponsePBImpl(this.proxy.replaceLabelsOnNodes(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    public ReplaceMaprLabelsOnNodeResponse replaceMaprLabelsOnNode(ReplaceMaprLabelsOnNodeRequest request) throws YarnException, IOException {
        YarnServerResourceManagerServiceProtos.ReplaceMaprLabelsOnNodeRequestProto requestProto = ((ReplaceMaprLabelsOnNodeRequestPBImpl)request).getProto();
        try {
            return new ReplaceMaprLabelsOnNodeResponsePBImpl(this.proxy.replaceMaprLabelsOnNodes(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    public GetClusterNodeLabelsResponse getClusterNodeLabels(GetClusterNodeLabelsRequest request) throws YarnException, IOException {
        YarnServiceProtos.GetClusterNodeLabelsRequestProto requestProto = ((GetClusterNodeLabelsRequestPBImpl)request).getProto();
        try {
            return new GetClusterNodeLabelsResponsePBImpl(this.proxy.getClusterNodeLabels(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }

    public RefreshClusterNodeLabelsResponse refreshClusterNodeLabels(RefreshClusterNodeLabelsRequest request) throws YarnException, IOException {
        YarnServiceProtos.RefreshClusterNodeLabelsRequestProto requestProto = ((RefreshClusterNodeLabelsRequestPBImpl)request).getProto();
        try {
            return new RefreshClusterNodeLabelsResponsePBImpl(this.proxy.refreshClusterNodeLabels(null, requestProto));
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
            return null;
        }
    }
}

