/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hadoop.yarn.configuration.YarnHASiteXmlBuilder;

public class YarnSiteXmlBuilder {
    private static final String RM_IP_TEMPLATE = "__RM_IP__";
    private static final String CONFIG_DEMARCATION = "  <!-- :::CAUTION::: DO NOT EDIT ANYTHING ON OR ABOVE THIS LINE -->";
    private static final String YARN_SITE_TEMPLATE_FILE = "yarn-site-template.xml";
    private final String rmIp;
    private final String pathToYarnSiteXml;

    public YarnSiteXmlBuilder(String rmIp, String pathToYarnSiteXml) {
        this.rmIp = rmIp;
        this.pathToYarnSiteXml = pathToYarnSiteXml;
    }

    public String build() throws IOException {
        String currentContents;
        String string = currentContents = new File(this.pathToYarnSiteXml).exists() ? this.readStream(new FileInputStream(this.pathToYarnSiteXml)) : "";
        if (currentContents.contains(CONFIG_DEMARCATION)) {
            return currentContents.replaceAll("(?s).*  <!-- :::CAUTION::: DO NOT EDIT ANYTHING ON OR ABOVE THIS LINE -->\r?\n", this.buildYarnSiteXmlFromTemplate().replaceAll("(?s)</configuration>.*", ""));
        }
        return this.buildYarnSiteXmlFromTemplate();
    }

    private String buildYarnSiteXmlFromTemplate() throws IOException {
        InputStream haTemplateStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(YARN_SITE_TEMPLATE_FILE);
        return this.readStream(haTemplateStream).replace(RM_IP_TEMPLATE, this.rmIp);
    }

    private String readStream(InputStream stream) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            buf.append(line);
            buf.append("\n");
        }
        reader.close();
        return buf.toString();
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Usage: YarnSiteXmlBuilder <RM_IP> <Full path To yarn-site.xml>");
            System.exit(1);
        }
        if (args[0].split(",").length > 1) {
            System.err.println("Multiple RM IPs are provided. For RM HA, use " + YarnHASiteXmlBuilder.class.getName());
            System.exit(1);
        }
        String newYarnSiteXml = new YarnSiteXmlBuilder(args[0], args[1]).build();
        System.out.println(newYarnSiteXml);
    }
}

