/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class QueueStatistics {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static QueueStatistics newInstance(long submitted, long running, long pending, long completed, long killed, long failed, long activeUsers, long availableMemoryMB, long allocatedMemoryMB, long pendingMemoryMB, long reservedMemoryMB, long availableVCores, long allocatedVCores, long pendingVCores, long reservedVCores, double availableDisks, double allocatedDisks, double pendingDisks, double reservedDisks) {
        QueueStatistics statistics = Records.newRecord(QueueStatistics.class);
        statistics.setNumAppsSubmitted(submitted);
        statistics.setNumAppsRunning(running);
        statistics.setNumAppsPending(pending);
        statistics.setNumAppsCompleted(completed);
        statistics.setNumAppsKilled(killed);
        statistics.setNumAppsFailed(failed);
        statistics.setNumActiveUsers(activeUsers);
        statistics.setAvailableMemoryMB(availableMemoryMB);
        statistics.setAllocatedMemoryMB(allocatedMemoryMB);
        statistics.setPendingMemoryMB(pendingMemoryMB);
        statistics.setReservedMemoryMB(reservedMemoryMB);
        statistics.setAvailableVCores(availableVCores);
        statistics.setAllocatedVCores(allocatedVCores);
        statistics.setPendingVCores(pendingVCores);
        statistics.setReservedVCores(reservedVCores);
        statistics.setAvailableDisks(availableDisks);
        statistics.setAllocatedDisks(allocatedDisks);
        statistics.setPendingDisks(pendingDisks);
        statistics.setReservedDisks(reservedDisks);
        return statistics;
    }

    public abstract long getNumAppsSubmitted();

    public abstract void setNumAppsSubmitted(long var1);

    public abstract long getNumAppsRunning();

    public abstract void setNumAppsRunning(long var1);

    public abstract long getNumAppsPending();

    public abstract void setNumAppsPending(long var1);

    public abstract long getNumAppsCompleted();

    public abstract void setNumAppsCompleted(long var1);

    public abstract long getNumAppsKilled();

    public abstract void setNumAppsKilled(long var1);

    public abstract long getNumAppsFailed();

    public abstract void setNumAppsFailed(long var1);

    public abstract long getNumActiveUsers();

    public abstract void setNumActiveUsers(long var1);

    public abstract long getAvailableMemoryMB();

    public abstract void setAvailableMemoryMB(long var1);

    public abstract long getAllocatedMemoryMB();

    public abstract void setAllocatedMemoryMB(long var1);

    public abstract long getPendingMemoryMB();

    public abstract void setPendingMemoryMB(long var1);

    public abstract long getReservedMemoryMB();

    public abstract void setReservedMemoryMB(long var1);

    public abstract long getAvailableVCores();

    public abstract void setAvailableVCores(long var1);

    public abstract long getAllocatedVCores();

    public abstract void setAllocatedVCores(long var1);

    public abstract long getPendingVCores();

    public abstract void setPendingVCores(long var1);

    public abstract long getReservedVCores();

    public abstract void setReservedVCores(long var1);

    public abstract double getAvailableDisks();

    public abstract void setAvailableDisks(double var1);

    public abstract double getAllocatedDisks();

    public abstract void setAllocatedDisks(double var1);

    public abstract double getPendingDisks();

    public abstract void setPendingDisks(double var1);

    public abstract double getReservedDisks();

    public abstract void setReservedDisks(double var1);
}

