/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.PrintStream;
import junit.framework.AssertionFailedError;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tracing.SetSpanReceiver;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.htrace.core.AlwaysSampler;
import org.junit.Assert;
import org.junit.Test;

public class TestFsShell {
    @Test
    public void testConfWithInvalidFile() throws Throwable {
        String[] args = new String[]{"--conf=invalidFile"};
        Exception th = null;
        try {
            FsShell.main((String[])args);
        }
        catch (Exception e) {
            th = e;
        }
        if (!(th instanceof RuntimeException)) {
            throw new AssertionFailedError("Expected Runtime exception, got: " + th).initCause((Throwable)th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTracing() throws Throwable {
        Configuration conf = new Configuration();
        String prefix = "fs.shell.htrace.";
        conf.set(prefix + "span.receiver.classes", SetSpanReceiver.class.getName());
        conf.set(prefix + "sampler.classes", AlwaysSampler.class.getName());
        conf.setQuietMode(false);
        try (FsShell shell = new FsShell(conf);){
            int res = ToolRunner.run((Tool)shell, (String[])new String[]{"-help", "ls", "cat"});
        }
        SetSpanReceiver.assertSpanNamesFound(new String[]{"help"});
        Assert.assertEquals((Object)"-help ls cat", SetSpanReceiver.getMap().get("help").get(0).getKVAnnotations().get("args"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSWithInvalidCommmand() throws Throwable {
        Configuration conf = new Configuration();
        FsShell shell = new FsShell(conf);
        String[] args = new String[]{"dfs -mkdirs"};
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldErr = System.err;
        try {
            System.setErr(out);
            ToolRunner.run((Tool)shell, (String[])args);
            String errorValue = new String(bytes.toString());
            Assert.assertTrue((String)"FSShell dfs command did not print the error message when invalid command is passed", (boolean)errorValue.contains("-mkdirs: Unknown command"));
            Assert.assertTrue((String)"FSShell dfs command did not print help message when invalid command is passed", (boolean)errorValue.contains("Usage: hadoop fs [generic options]"));
        }
        finally {
            IOUtils.closeStream((Closeable)out);
            System.setErr(oldErr);
        }
    }
}

