/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FileDistributionCalculator;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageDelimitedTextWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.WebImageViewer;
import org.apache.hadoop.net.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class OfflineImageViewerPB {
    public static final Logger LOG = LoggerFactory.getLogger(OfflineImageViewerPB.class);
    private static final String usage = "Usage: bin/hdfs oiv [OPTIONS] -i INPUTFILE -o OUTPUTFILE\nOffline Image Viewer\nView a Hadoop fsimage INPUTFILE using the specified PROCESSOR,\nsaving the results in OUTPUTFILE.\n\nThe oiv utility will attempt to parse correctly formed image files\nand will abort fail with mal-formed image files.\n\nThe tool works offline and does not require a running cluster in\norder to process an image file.\n\nThe following image processors are available:\n  * XML: This processor creates an XML document with all elements of\n    the fsimage enumerated, suitable for further analysis by XML\n    tools.\n  * FileDistribution: This processor analyzes the file size\n    distribution in the image.\n    -maxSize specifies the range [0, maxSize] of file sizes to be\n     analyzed (128GB by default).\n    -step defines the granularity of the distribution. (2MB by default)\n  * Web: Run a viewer to expose read-only WebHDFS API.\n    -addr specifies the address to listen. (localhost:5978 by default)\n  * Delimited (experimental): Generate a text file with all of the elements common\n    to both inodes and inodes-under-construction, separated by a\n    delimiter. The default delimiter is \\t, though this may be\n    changed via the -delimiter argument.\n\nRequired command line arguments:\n-i,--inputFile <arg>   FSImage file to process.\n\nOptional command line arguments:\n-o,--outputFile <arg>  Name of output file. If the specified\n                       file exists, it will be overwritten.\n                       (output to stdout by default)\n-p,--processor <arg>   Select which type of processor to apply\n                       against image file. (XML|FileDistribution|Web|Delimited)\n                       (Web by default)\n-delimiter <arg>       Delimiting string to use with Delimited processor.  \n-t,--temp <arg>        Use temporary dir to cache intermediate result to generate\n                       Delimited outputs. If not set, Delimited processor constructs\n                       the namespace in memory before outputting text.\n-h,--help              Display usage information and exit\n";

    private static Options buildOptions() {
        Options options = new Options();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"inputFile");
        options.addOption(OptionBuilder.create((String)"i"));
        options.addOption("o", "outputFile", true, "");
        options.addOption("p", "processor", true, "");
        options.addOption("h", "help", false, "");
        options.addOption("maxSize", true, "");
        options.addOption("step", true, "");
        options.addOption("addr", true, "");
        options.addOption("delimiter", true, "");
        options.addOption("t", "temp", true, "");
        return options;
    }

    public static void main(String[] args) throws Exception {
        int status = OfflineImageViewerPB.run(args);
        System.exit(status);
    }

    public static int run(String[] args) throws Exception {
        CommandLine cmd;
        Options options = OfflineImageViewerPB.buildOptions();
        if (args.length == 0) {
            OfflineImageViewerPB.printUsage();
            return 0;
        }
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println("Error parsing command-line options: ");
            OfflineImageViewerPB.printUsage();
            return -1;
        }
        if (cmd.hasOption("h")) {
            OfflineImageViewerPB.printUsage();
            return 0;
        }
        String inputFile = cmd.getOptionValue("i");
        String processor = cmd.getOptionValue("p", "Web");
        String outputFile = cmd.getOptionValue("o", "-");
        String delimiter = cmd.getOptionValue("delimiter", "\t");
        String tempPath = cmd.getOptionValue("t", "");
        Configuration conf = new Configuration();
        PrintStream out = outputFile.equals("-") ? System.out : new PrintStream(outputFile, "UTF-8");
        try {
            switch (processor) {
                case "FileDistribution": {
                    long maxSize = Long.parseLong(cmd.getOptionValue("maxSize", "0"));
                    int step = Integer.parseInt(cmd.getOptionValue("step", "0"));
                    new FileDistributionCalculator(conf, maxSize, step, out).visit(new RandomAccessFile(inputFile, "r"));
                    break;
                }
                case "XML": {
                    new PBImageXmlWriter(conf, out).visit(new RandomAccessFile(inputFile, "r"));
                    break;
                }
                case "Web": {
                    String addr = cmd.getOptionValue("addr", "localhost:5978");
                    try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)addr));){
                        viewer.start(inputFile);
                        break;
                    }
                }
                case "Delimited": {
                    try (PBImageDelimitedTextWriter writer = new PBImageDelimitedTextWriter(out, delimiter, tempPath);){
                        writer.visit(new RandomAccessFile(inputFile, "r"));
                        break;
                    }
                }
            }
            int n = 0;
            if (out != null) {
                out.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (EOFException e) {
                System.err.println("Input file ended unexpectedly. Exiting");
            }
            catch (IOException e) {
                System.err.println("Encountered exception.  Exiting: " + e.getMessage());
            }
        }
        return -1;
    }

    private static void printUsage() {
        System.out.println(usage);
    }
}

