/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.client;

import java.io.File;
import java.io.IOException;
import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.ccache.CredentialCache;
import org.apache.kerby.kerberos.kerb.client.ClientUtil;
import org.apache.kerby.kerberos.kerb.client.KrbConfig;
import org.apache.kerby.kerberos.kerb.client.KrbOption;
import org.apache.kerby.kerberos.kerb.client.KrbSetting;
import org.apache.kerby.kerberos.kerb.client.impl.DefaultInternalKrbClient;
import org.apache.kerby.kerberos.kerb.client.impl.InternalKrbClient;
import org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KrbClientBase {
    private final KrbConfig krbConfig;
    private final KOptions commonOptions;
    private final KrbSetting krbSetting;
    private InternalKrbClient innerClient;
    private static final Logger LOG = LoggerFactory.getLogger(KrbClientBase.class);

    public KrbClientBase() throws KrbException {
        this.krbConfig = ClientUtil.getDefaultConfig();
        this.commonOptions = new KOptions();
        this.krbSetting = new KrbSetting(this.commonOptions, this.krbConfig);
    }

    public KrbClientBase(KrbConfig krbConfig) {
        this.krbConfig = krbConfig;
        this.commonOptions = new KOptions();
        this.krbSetting = new KrbSetting(this.commonOptions, krbConfig);
    }

    public KrbClientBase(File confDir) throws KrbException {
        this.commonOptions = new KOptions();
        this.krbConfig = ClientUtil.getConfig(confDir);
        this.krbSetting = new KrbSetting(this.commonOptions, this.krbConfig);
    }

    public KrbClientBase(KrbClientBase krbClient) {
        this.commonOptions = krbClient.commonOptions;
        this.krbConfig = krbClient.krbConfig;
        this.krbSetting = krbClient.krbSetting;
        this.innerClient = krbClient.innerClient;
    }

    public void setKdcRealm(String realm) {
        this.commonOptions.add((KOption)KrbOption.KDC_REALM, (Object)realm);
    }

    public void setKdcHost(String kdcHost) {
        this.commonOptions.add((KOption)KrbOption.KDC_HOST, (Object)kdcHost);
    }

    public void setKdcTcpPort(int kdcTcpPort) {
        if (kdcTcpPort < 1) {
            throw new IllegalArgumentException("Invalid port");
        }
        this.commonOptions.add((KOption)KrbOption.KDC_TCP_PORT, (Object)kdcTcpPort);
        this.setAllowTcp(true);
    }

    public void setAllowUdp(boolean allowUdp) {
        this.commonOptions.add((KOption)KrbOption.ALLOW_UDP, (Object)allowUdp);
    }

    public void setAllowTcp(boolean allowTcp) {
        this.commonOptions.add((KOption)KrbOption.ALLOW_TCP, (Object)allowTcp);
    }

    public void setKdcUdpPort(int kdcUdpPort) {
        if (kdcUdpPort < 1) {
            throw new IllegalArgumentException("Invalid port");
        }
        this.commonOptions.add((KOption)KrbOption.KDC_UDP_PORT, (Object)kdcUdpPort);
        this.setAllowUdp(true);
    }

    public void setTimeout(int timeout) {
        this.commonOptions.add((KOption)KrbOption.CONN_TIMEOUT, (Object)timeout);
    }

    public void init() throws KrbException {
        this.innerClient = new DefaultInternalKrbClient(this.krbSetting);
        this.innerClient.init();
    }

    public KrbSetting getSetting() {
        return this.krbSetting;
    }

    public KrbConfig getKrbConfig() {
        return this.krbConfig;
    }

    public TgtTicket requestTgt(KOptions requestOptions) throws KrbException {
        if (requestOptions == null) {
            throw new IllegalArgumentException("Null requestOptions specified");
        }
        return this.innerClient.requestTgt(requestOptions);
    }

    public SgtTicket requestSgt(TgtTicket tgt, String serverPrincipal) throws KrbException {
        KOptions requestOptions = new KOptions();
        requestOptions.add((KOption)KrbOption.USE_TGT, (Object)tgt);
        requestOptions.add((KOption)KrbOption.SERVER_PRINCIPAL, (Object)serverPrincipal);
        return this.innerClient.requestSgt(requestOptions);
    }

    public SgtTicket requestSgt(KOptions requestOptions) throws KrbException {
        return this.innerClient.requestSgt(requestOptions);
    }

    public void storeTicket(TgtTicket tgtTicket, File ccacheFile) throws KrbException {
        LOG.info("Storing the tgt to the credential cache file.");
        if (!ccacheFile.exists()) {
            try {
                if (!ccacheFile.createNewFile()) {
                    throw new KrbException("Failed to create ccache file " + ccacheFile.getAbsolutePath());
                }
                ccacheFile.setReadable(false, false);
                ccacheFile.setReadable(true, true);
                if (!ccacheFile.setWritable(true, true)) {
                    throw new KrbException("Cache file is not readable.");
                }
            }
            catch (IOException e) {
                throw new KrbException("Failed to create ccache file " + ccacheFile.getAbsolutePath(), (Throwable)e);
            }
        }
        if (ccacheFile.exists() && ccacheFile.canWrite()) {
            CredentialCache cCache = new CredentialCache(tgtTicket);
            try {
                cCache.store(ccacheFile);
            }
            catch (IOException e) {
                throw new KrbException("Failed to store tgt", (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("Invalid ccache file, not exist or writable: " + ccacheFile.getAbsolutePath());
        }
    }
}

