/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import com.google.common.base.Joiner;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

@XmlRootElement(name="app")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppInfo {
    @XmlTransient
    protected String appIdNum;
    @XmlTransient
    protected boolean trackingUrlIsNotReady;
    @XmlTransient
    protected String trackingUrlPretty;
    @XmlTransient
    protected boolean amContainerLogsExist = false;
    @XmlTransient
    protected ApplicationId applicationId;
    @XmlTransient
    private String schemePrefix;
    protected String id;
    protected String user;
    protected String name;
    protected String queue;
    protected YarnApplicationState state;
    protected FinalApplicationStatus finalStatus;
    protected float progress;
    protected String trackingUI;
    protected String trackingUrl;
    protected String diagnostics;
    protected long clusterId;
    protected String applicationType;
    protected String applicationTags = "";
    protected long startedTime;
    protected long finishedTime;
    protected long elapsedTime;
    protected String amContainerLogs;
    protected String amHostHttpAddress;
    protected int allocatedMB;
    protected int allocatedVCores;
    protected double allocatedDisks;
    protected long reservedMB;
    protected long reservedVCores;
    protected int runningContainers;
    protected long memorySeconds;
    protected long vcoreSeconds;
    protected int preemptedResourceMB;
    protected int preemptedResourceVCores;
    protected double preemptedDisks;
    protected int numNonAMContainerPreempted;
    protected int numAMContainerPreempted;
    protected List<ResourceRequest> resourceRequests;

    public AppInfo() {
    }

    public AppInfo(ResourceManager rm, RMApp app, Boolean hasAccess, String schemePrefix) {
        this.schemePrefix = schemePrefix;
        if (app != null) {
            String trackingUrl = app.getTrackingUrl();
            this.state = app.createApplicationState();
            boolean bl = this.trackingUrlIsNotReady = trackingUrl == null || trackingUrl.isEmpty() || YarnApplicationState.NEW == this.state || YarnApplicationState.NEW_SAVING == this.state || YarnApplicationState.SUBMITTED == this.state || YarnApplicationState.ACCEPTED == this.state;
            this.trackingUI = this.trackingUrlIsNotReady ? "UNASSIGNED" : (app.getFinishTime() == 0L ? "ApplicationMaster" : "History");
            this.trackingUrlPretty = !this.trackingUrlIsNotReady ? (this.trackingUrl = WebAppUtils.getURLWithScheme((String)schemePrefix, (String)trackingUrl)) : "UNASSIGNED";
            this.applicationId = app.getApplicationId();
            this.applicationType = app.getApplicationType();
            this.appIdNum = String.valueOf(app.getApplicationId().getId());
            this.id = app.getApplicationId().toString();
            this.user = app.getUser().toString();
            this.name = app.getName().toString();
            this.queue = app.getQueue().toString();
            this.progress = app.getProgress() * 100.0f;
            this.diagnostics = app.getDiagnostics().toString();
            if (this.diagnostics == null || this.diagnostics.isEmpty()) {
                this.diagnostics = "";
            }
            if (app.getApplicationTags() != null && !app.getApplicationTags().isEmpty()) {
                this.applicationTags = Joiner.on((char)',').join(app.getApplicationTags());
            }
            this.finalStatus = app.getFinalApplicationStatus();
            this.clusterId = ResourceManager.getClusterTimeStamp();
            if (hasAccess.booleanValue()) {
                this.startedTime = app.getStartTime();
                this.finishedTime = app.getFinishTime();
                this.elapsedTime = Times.elapsed((long)app.getStartTime(), (long)app.getFinishTime());
                RMAppAttempt attempt = app.getCurrentAppAttempt();
                if (attempt != null) {
                    ApplicationResourceUsageReport resourceReport;
                    Container masterContainer = attempt.getMasterContainer();
                    if (masterContainer != null) {
                        this.amContainerLogsExist = true;
                        this.amContainerLogs = WebAppUtils.getRunningLogURL((String)(schemePrefix + masterContainer.getNodeHttpAddress()), (String)ConverterUtils.toString((ContainerId)masterContainer.getId()), (String)app.getUser());
                        this.amHostHttpAddress = masterContainer.getNodeHttpAddress();
                    }
                    if ((resourceReport = attempt.getApplicationResourceUsageReport()) != null) {
                        Resource usedResources = resourceReport.getUsedResources();
                        Resource reservedResources = resourceReport.getReservedResources();
                        this.allocatedMB = usedResources.getMemory();
                        this.allocatedDisks = usedResources.getDisks();
                        this.allocatedVCores = usedResources.getVirtualCores();
                        this.reservedMB = reservedResources.getMemory();
                        this.reservedVCores = reservedResources.getVirtualCores();
                        this.runningContainers = resourceReport.getNumUsedContainers();
                    }
                    this.resourceRequests = ((AbstractYarnScheduler)rm.getRMContext().getScheduler()).getPendingResourceRequestsForAttempt(attempt.getAppAttemptId());
                }
            }
            RMAppMetrics appMetrics = app.getRMAppMetrics();
            this.numAMContainerPreempted = appMetrics.getNumAMContainersPreempted();
            this.preemptedResourceMB = appMetrics.getResourcePreempted().getMemory();
            this.preemptedDisks = appMetrics.getResourcePreempted().getDisks();
            this.numNonAMContainerPreempted = appMetrics.getNumNonAMContainersPreempted();
            this.preemptedResourceVCores = appMetrics.getResourcePreempted().getVirtualCores();
            this.memorySeconds = appMetrics.getMemorySeconds();
            this.vcoreSeconds = appMetrics.getVcoreSeconds();
        }
    }

    public boolean isTrackingUrlReady() {
        return !this.trackingUrlIsNotReady;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public String getAppId() {
        return this.id;
    }

    public String getAppIdNum() {
        return this.appIdNum;
    }

    public String getUser() {
        return this.user;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getName() {
        return this.name;
    }

    public YarnApplicationState getState() {
        return this.state;
    }

    public float getProgress() {
        return this.progress;
    }

    public String getTrackingUI() {
        return this.trackingUI;
    }

    public String getNote() {
        return this.diagnostics;
    }

    public FinalApplicationStatus getFinalStatus() {
        return this.finalStatus;
    }

    public String getTrackingUrl() {
        return this.trackingUrl;
    }

    public String getTrackingUrlPretty() {
        return this.trackingUrlPretty;
    }

    public long getStartTime() {
        return this.startedTime;
    }

    public long getFinishTime() {
        return this.finishedTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getAMContainerLogs() {
        return this.amContainerLogs;
    }

    public String getAMHostHttpAddress() {
        return this.amHostHttpAddress;
    }

    public boolean amContainerLogsExist() {
        return this.amContainerLogsExist;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public String getApplicationTags() {
        return this.applicationTags;
    }

    public int getRunningContainers() {
        return this.runningContainers;
    }

    public int getAllocatedMB() {
        return this.allocatedMB;
    }

    public int getAllocatedVCores() {
        return this.allocatedVCores;
    }

    public double getAllocatedDisks() {
        return this.allocatedDisks;
    }

    public long getReservedMB() {
        return this.reservedMB;
    }

    public long getReservedVCores() {
        return this.reservedVCores;
    }

    public int getPreemptedMB() {
        return this.preemptedResourceMB;
    }

    public int getPreemptedVCores() {
        return this.preemptedResourceVCores;
    }

    public double getPreemptedDisks() {
        return this.preemptedDisks;
    }

    public int getNumNonAMContainersPreempted() {
        return this.numNonAMContainerPreempted;
    }

    public int getNumAMContainersPreempted() {
        return this.numAMContainerPreempted;
    }

    public long getMemorySeconds() {
        return this.memorySeconds;
    }

    public long getVcoreSeconds() {
        return this.vcoreSeconds;
    }

    public List<ResourceRequest> getResourceRequests() {
        return this.resourceRequests;
    }
}

