/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.registry.client.types.Endpoint;

@InterfaceAudience.Public
@InterfaceStability.Evolving
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ServiceRecord
implements Cloneable {
    public static final String RECORD_TYPE = "JSONServiceRecord";
    public String type = "JSONServiceRecord";
    public String description;
    private Map<String, String> attributes = new HashMap<String, String>(4);
    public List<Endpoint> external = new ArrayList<Endpoint>();
    public List<Endpoint> internal = new ArrayList<Endpoint>();

    public ServiceRecord() {
    }

    public ServiceRecord(ServiceRecord that) {
        this.description = that.description;
        Map<String, String> thatAttrs = that.attributes;
        for (Map.Entry<String, String> entry : thatAttrs.entrySet()) {
            this.attributes.put(entry.getKey(), entry.getValue());
        }
        List<Endpoint> src = that.internal;
        if (src != null) {
            this.internal = new ArrayList<Endpoint>(src.size());
            for (Endpoint endpoint : src) {
                this.internal.add(new Endpoint(endpoint));
            }
        }
        if ((src = that.external) != null) {
            this.external = new ArrayList<Endpoint>(src.size());
            for (Endpoint endpoint : src) {
                this.external.add(new Endpoint(endpoint));
            }
        }
    }

    public void addExternalEndpoint(Endpoint endpoint) {
        Preconditions.checkArgument((endpoint != null ? 1 : 0) != 0);
        endpoint.validate();
        this.external.add(endpoint);
    }

    public void addInternalEndpoint(Endpoint endpoint) {
        Preconditions.checkArgument((endpoint != null ? 1 : 0) != 0);
        endpoint.validate();
        this.internal.add(endpoint);
    }

    public Endpoint getInternalEndpoint(String api) {
        return this.findByAPI(this.internal, api);
    }

    public Endpoint getExternalEndpoint(String api) {
        return this.findByAPI(this.external, api);
    }

    @JsonAnySetter
    public void set(String key, Object value) {
        this.attributes.put(key, value.toString());
    }

    @JsonAnyGetter
    public Map<String, String> attributes() {
        return this.attributes;
    }

    public String get(String key) {
        return this.attributes.get(key);
    }

    public String get(String key, String defVal) {
        String val = this.attributes.get(key);
        return val != null ? val : defVal;
    }

    private Endpoint findByAPI(List<Endpoint> list, String api) {
        for (Endpoint endpoint : list) {
            if (!endpoint.api.equals(api)) continue;
            return endpoint;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ServiceRecord{");
        sb.append("description='").append(this.description).append('\'');
        sb.append("; external endpoints: {");
        for (Endpoint endpoint : this.external) {
            sb.append(endpoint).append("; ");
        }
        sb.append("}; internal endpoints: {");
        for (Endpoint endpoint : this.internal) {
            sb.append(endpoint != null ? endpoint.toString() : "NULL ENDPOINT");
            sb.append("; ");
        }
        sb.append('}');
        if (!this.attributes.isEmpty()) {
            sb.append(", attributes: {");
            for (Map.Entry entry : this.attributes.entrySet()) {
                sb.append("\"").append((String)entry.getKey()).append("\"=\"").append((String)entry.getValue()).append("\" ");
            }
        } else {
            sb.append(", attributes: {");
        }
        sb.append('}');
        sb.append('}');
        return sb.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

