/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.server.request;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.kerberos.kerb.KrbCodec;
import org.apache.kerby.kerberos.kerb.KrbErrorCode;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import org.apache.kerby.kerberos.kerb.common.KrbUtil;
import org.apache.kerby.kerberos.kerb.crypto.CheckSumHandler;
import org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import org.apache.kerby.kerberos.kerb.crypto.fast.FastUtil;
import org.apache.kerby.kerberos.kerb.identity.KrbIdentity;
import org.apache.kerby.kerberos.kerb.server.KdcContext;
import org.apache.kerby.kerberos.kerb.server.KdcRecoverableException;
import org.apache.kerby.kerberos.kerb.server.preauth.KdcFastContext;
import org.apache.kerby.kerberos.kerb.server.preauth.PreauthContext;
import org.apache.kerby.kerberos.kerb.server.preauth.PreauthHandler;
import org.apache.kerby.kerberos.kerb.type.ap.ApReq;
import org.apache.kerby.kerberos.kerb.type.ap.Authenticator;
import org.apache.kerby.kerberos.kerb.type.base.AuthToken;
import org.apache.kerby.kerberos.kerb.type.base.CheckSum;
import org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.EtypeInfo;
import org.apache.kerby.kerberos.kerb.type.base.EtypeInfo2;
import org.apache.kerby.kerberos.kerb.type.base.EtypeInfo2Entry;
import org.apache.kerby.kerberos.kerb.type.base.EtypeInfoEntry;
import org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import org.apache.kerby.kerberos.kerb.type.base.KrbError;
import org.apache.kerby.kerberos.kerb.type.base.KrbMessage;
import org.apache.kerby.kerberos.kerb.type.base.MethodData;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.fast.ArmorType;
import org.apache.kerby.kerberos.kerb.type.fast.KrbFastArmor;
import org.apache.kerby.kerberos.kerb.type.fast.KrbFastArmoredReq;
import org.apache.kerby.kerberos.kerb.type.fast.KrbFastReq;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcOption;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcOptions;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcRep;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcReq;
import org.apache.kerby.kerberos.kerb.type.pa.PaData;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import org.apache.kerby.kerberos.kerb.type.ticket.EncTicketPart;
import org.apache.kerby.kerberos.kerb.type.ticket.Ticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KdcRequest {
    private static final Logger LOG = LoggerFactory.getLogger(KdcRequest.class);
    private final KdcReq kdcReq;
    private final KdcContext kdcContext;
    private Ticket ticket;
    private boolean isPreAuthenticated;
    private KdcRep reply;
    private InetAddress clientAddress;
    private boolean isTcp = true;
    private EncryptionType encryptionType;
    private EncryptionKey clientKey;
    private KrbIdentity clientEntry;
    private KrbIdentity serverEntry;
    private EncryptionKey serverKey;
    private KrbIdentity tgsEntry;
    private PreauthContext preauthContext;
    private KdcFastContext fastContext;
    private PrincipalName clientPrincipal;
    private PrincipalName serverPrincipal;
    private byte[] innerBodyout;
    private AuthToken token;
    private boolean isToken = false;
    private boolean isPkinit = false;
    private boolean isAnonymous = false;
    private EncryptionKey sessionKey;
    private ByteBuffer reqPackage;
    private boolean isHttps = false;

    public EncryptionKey getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(EncryptionKey sessionKey) {
        this.sessionKey = sessionKey;
    }

    public KdcRequest(KdcReq kdcReq, KdcContext kdcContext) {
        this.kdcReq = kdcReq;
        this.kdcContext = kdcContext;
        this.preauthContext = kdcContext.getPreauthHandler().preparePreauthContext(this);
        this.fastContext = new KdcFastContext();
    }

    public KdcContext getKdcContext() {
        return this.kdcContext;
    }

    public KdcReq getKdcReq() {
        return this.kdcReq;
    }

    public PreauthContext getPreauthContext() {
        return this.preauthContext;
    }

    public void process() throws KrbException {
        this.checkVersion();
        this.checkTgsEntry();
        this.kdcFindFast();
        this.checkEncryptionType();
        if (PreauthHandler.isToken(this.getKdcReq().getPaData())) {
            this.isToken = true;
            this.preauth();
            this.checkClient();
            this.checkServer();
        } else {
            if (PreauthHandler.isPkinit(this.getKdcReq().getPaData())) {
                this.isPkinit = true;
            }
            this.checkClient();
            this.checkServer();
            this.preauth();
        }
        this.checkPolicy();
        this.issueTicket();
        this.makeReply();
    }

    private void checkTgsEntry() throws KrbException {
        KrbIdentity tgsEntry = this.getEntry(this.getTgsPrincipal().getName());
        this.setTgsEntry(tgsEntry);
    }

    private void kdcFindFast() throws KrbException {
        PaData paData = this.getKdcReq().getPaData();
        if (paData != null) {
            for (PaDataEntry paEntry : paData.getElements()) {
                if (paEntry.getPaDataType() != PaDataType.FX_FAST) continue;
                LOG.info("Found fast padata and starting to process it.");
                KrbFastArmoredReq fastArmoredReq = (KrbFastArmoredReq)KrbCodec.decode((byte[])paEntry.getPaDataValue(), KrbFastArmoredReq.class);
                KrbFastArmor fastArmor = fastArmoredReq.getArmor();
                this.armorApRequest(fastArmor);
                EncryptedData encryptedData = fastArmoredReq.getEncryptedFastReq();
                KrbFastReq fastReq = (KrbFastReq)KrbCodec.decode((byte[])EncryptionHandler.decrypt((EncryptedData)encryptedData, (EncryptionKey)this.getArmorKey(), (KeyUsage)KeyUsage.FAST_ENC), KrbFastReq.class);
                this.innerBodyout = KrbCodec.encode((Asn1Type)fastReq.getKdcReqBody());
                CheckSum checkSum = fastArmoredReq.getReqChecksum();
                if (checkSum == null) {
                    LOG.warn("Checksum is empty.");
                    throw new KrbException(KrbErrorCode.KDC_ERR_PA_CHECKSUM_MUST_BE_INCLUDED);
                }
                byte[] reqBody = KrbCodec.encode((Asn1Type)this.getKdcReq().getReqBody());
                CheckSumHandler.verifyWithKey((CheckSum)checkSum, (byte[])reqBody, (byte[])this.getArmorKey().getKeyData(), (KeyUsage)KeyUsage.FAST_REQ_CHKSUM);
            }
        }
    }

    private void armorApRequest(KrbFastArmor fastArmor) throws KrbException {
        if (fastArmor.getArmorType() == ArmorType.ARMOR_AP_REQUEST) {
            ApReq apReq = (ApReq)KrbCodec.decode((byte[])fastArmor.getArmorValue(), ApReq.class);
            Ticket ticket = apReq.getTicket();
            EncryptionType encType = ticket.getEncryptedEncPart().getEType();
            EncryptionKey tgsKey = (EncryptionKey)this.getTgsEntry().getKeys().get(encType);
            if (ticket.getTktvno() != 5) {
                throw new KrbException(KrbErrorCode.KRB_AP_ERR_BADVERSION);
            }
            EncTicketPart encPart = (EncTicketPart)EncryptionUtil.unseal((EncryptedData)ticket.getEncryptedEncPart(), (EncryptionKey)tgsKey, (KeyUsage)KeyUsage.KDC_REP_TICKET, EncTicketPart.class);
            ticket.setEncPart(encPart);
            EncryptionKey encKey = ticket.getEncPart().getKey();
            this.setSessionKey(encKey);
            Authenticator authenticator = (Authenticator)EncryptionUtil.unseal((EncryptedData)apReq.getEncryptedAuthenticator(), (EncryptionKey)encKey, (KeyUsage)KeyUsage.AP_REQ_AUTH, Authenticator.class);
            EncryptionKey armorKey = FastUtil.cf2((EncryptionKey)authenticator.getSubKey(), (String)"subkeyarmor", (EncryptionKey)encKey, (String)"ticketarmor");
            this.setArmorKey(armorKey);
        }
    }

    public KrbIdentity getTgsEntry() {
        return this.tgsEntry;
    }

    public void setTgsEntry(KrbIdentity tgsEntry) {
        this.tgsEntry = tgsEntry;
    }

    public boolean isTcp() {
        return this.isTcp;
    }

    public void isTcp(boolean isTcp) {
        this.isTcp = isTcp;
    }

    public KrbMessage getReply() {
        return this.reply;
    }

    public void setReply(KdcRep reply) {
        this.reply = reply;
    }

    public InetAddress getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(InetAddress clientAddress) {
        this.clientAddress = clientAddress;
    }

    public EncryptionType getEncryptionType() {
        return this.encryptionType;
    }

    public void setEncryptionType(EncryptionType encryptionType) {
        this.encryptionType = encryptionType;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public boolean isPreAuthenticated() {
        return this.isPreAuthenticated;
    }

    public void setPreAuthenticated(boolean isPreAuthenticated) {
        this.isPreAuthenticated = isPreAuthenticated;
    }

    public KrbIdentity getServerEntry() {
        return this.serverEntry;
    }

    public void setServerEntry(KrbIdentity serverEntry) {
        this.serverEntry = serverEntry;
    }

    public KrbIdentity getClientEntry() {
        return this.clientEntry;
    }

    public void setClientEntry(KrbIdentity clientEntry) {
        this.clientEntry = clientEntry;
    }

    public EncryptionKey getClientKey(EncryptionType encType) throws KrbException {
        return this.getClientEntry().getKey(encType);
    }

    public EncryptionKey getClientKey() {
        return this.clientKey;
    }

    public void setClientKey(EncryptionKey clientKey) {
        this.clientKey = clientKey;
    }

    public EncryptionKey getServerKey() {
        return this.serverKey;
    }

    public void setServerKey(EncryptionKey serverKey) {
        this.serverKey = serverKey;
    }

    public PrincipalName getTgsPrincipal() {
        PrincipalName result = KrbUtil.makeTgsPrincipal((String)this.kdcContext.getKdcRealm());
        return result;
    }

    protected abstract void makeReply() throws KrbException;

    protected void checkVersion() throws KrbException {
        KdcReq request = this.getKdcReq();
        int kerberosVersion = request.getPvno();
        if (kerberosVersion != 5) {
            LOG.warn("Kerberos version: " + kerberosVersion + " should equal to " + 5);
            throw new KrbException(KrbErrorCode.KDC_ERR_BAD_PVNO);
        }
    }

    protected void checkPolicy() throws KrbException {
        KrbIdentity entry = this.getClientEntry();
        if (entry != null) {
            if (entry.isDisabled()) {
                LOG.warn("Client entry " + entry.getPrincipalName() + " is disabled.");
                throw new KrbException(KrbErrorCode.KDC_ERR_CLIENT_REVOKED);
            }
            if (entry.isLocked()) {
                LOG.warn("Client entry " + entry.getPrincipalName() + " is expired.");
                throw new KrbException(KrbErrorCode.KDC_ERR_CLIENT_REVOKED);
            }
            if (entry.getExpireTime().lessThan(new Date().getTime())) {
                throw new KrbException(KrbErrorCode.KDC_ERR_CLIENT_REVOKED);
            }
        } else {
            LOG.info("Client entry is empty.");
        }
    }

    protected abstract void checkClient() throws KrbException;

    protected void preauth() throws KrbException {
        KdcReq request = this.getKdcReq();
        PaData preAuthData = request.getPaData();
        if (this.isPreauthRequired()) {
            if (this.isAnonymous && !this.isPkinit) {
                LOG.info("Need PKINIT.");
                KrbError krbError = this.makePreAuthenticationError(this.kdcContext, request, KrbErrorCode.KDC_ERR_PREAUTH_REQUIRED, true);
                throw new KdcRecoverableException(krbError);
            }
            if (preAuthData == null || preAuthData.isEmpty()) {
                LOG.info("The preauth data is empty.");
                KrbError krbError = this.makePreAuthenticationError(this.kdcContext, request, KrbErrorCode.KDC_ERR_PREAUTH_REQUIRED, false);
                throw new KdcRecoverableException(krbError);
            }
            this.getPreauthHandler().verify(this, preAuthData);
        }
        this.setPreAuthenticated(true);
    }

    protected void setPreauthRequired(boolean preauthRequired) {
        this.preauthContext.setPreauthRequired(preauthRequired);
    }

    protected boolean isPreauthRequired() {
        return this.preauthContext.isPreauthRequired();
    }

    protected PreauthHandler getPreauthHandler() {
        return this.kdcContext.getPreauthHandler();
    }

    protected void checkEncryptionType() throws KrbException {
        List requestedTypes = this.getKdcReq().getReqBody().getEtypes();
        EncryptionType bestType = EncryptionUtil.getBestEncryptionType((List)requestedTypes, this.kdcContext.getConfig().getEncryptionTypes());
        if (bestType == null) {
            LOG.error("Can't get the best encryption type.");
            throw new KrbException(KrbErrorCode.KDC_ERR_ETYPE_NOSUPP);
        }
        this.setEncryptionType(bestType);
    }

    protected void authenticate() throws KrbException {
        this.checkEncryptionType();
        this.checkPolicy();
    }

    protected abstract void issueTicket() throws KrbException;

    private void checkServer() throws KrbException {
        KdcReq request = this.getKdcReq();
        PrincipalName principal = request.getReqBody().getSname();
        String serverRealm = request.getReqBody().getRealm();
        if (serverRealm == null || serverRealm.isEmpty()) {
            LOG.info("Can't get the server realm from request, and try to get from kdcContext.");
            serverRealm = this.kdcContext.getKdcRealm();
        }
        principal.setRealm(serverRealm);
        KrbIdentity serverEntry = this.getEntry(principal.getName());
        if (serverEntry == null) {
            LOG.error("Principal: " + principal.getName() + " is not known");
            throw new KrbException(KrbErrorCode.KDC_ERR_S_PRINCIPAL_UNKNOWN);
        }
        this.setServerEntry(serverEntry);
        for (EncryptionType encType : request.getReqBody().getEtypes()) {
            if (!serverEntry.getKeys().containsKey(encType)) continue;
            EncryptionKey serverKey = (EncryptionKey)serverEntry.getKeys().get(encType);
            this.setServerKey(serverKey);
            break;
        }
    }

    protected KrbError makePreAuthenticationError(KdcContext kdcContext, KdcReq request, KrbErrorCode errorCode, boolean pkinit) throws KrbException {
        List<EncryptionType> encryptionTypes = kdcContext.getConfig().getEncryptionTypes();
        List clientEtypes = request.getReqBody().getEtypes();
        boolean isNewEtype = true;
        EtypeInfo2 eTypeInfo2 = new EtypeInfo2();
        EtypeInfo eTypeInfo = new EtypeInfo();
        for (EncryptionType encryptionType : encryptionTypes) {
            if (!clientEtypes.contains(encryptionType)) continue;
            if (!isNewEtype) {
                EtypeInfoEntry etypeInfoEntry = new EtypeInfoEntry();
                etypeInfoEntry.setEtype(encryptionType);
                etypeInfoEntry.setSalt(null);
                eTypeInfo.add((Asn1Type)etypeInfoEntry);
            }
            EtypeInfo2Entry etypeInfo2Entry = new EtypeInfo2Entry();
            etypeInfo2Entry.setEtype(encryptionType);
            eTypeInfo2.add((Asn1Type)etypeInfo2Entry);
        }
        byte[] encTypeInfo = null;
        byte[] encTypeInfo2 = null;
        if (!isNewEtype) {
            encTypeInfo = KrbCodec.encode((Asn1Type)eTypeInfo);
        }
        encTypeInfo2 = KrbCodec.encode((Asn1Type)eTypeInfo2);
        MethodData methodData = new MethodData();
        if (!isNewEtype) {
            methodData.add((Asn1Type)new PaDataEntry(PaDataType.ETYPE_INFO, encTypeInfo));
        }
        methodData.add((Asn1Type)new PaDataEntry(PaDataType.ETYPE_INFO2, encTypeInfo2));
        if (pkinit) {
            methodData.add((Asn1Type)new PaDataEntry(PaDataType.PK_AS_REQ, "empty".getBytes()));
            methodData.add((Asn1Type)new PaDataEntry(PaDataType.PK_AS_REP, "empty".getBytes()));
        }
        KrbError krbError = new KrbError();
        krbError.setErrorCode(errorCode);
        byte[] encodedData = KrbCodec.encode((Asn1Type)methodData);
        krbError.setEdata(encodedData);
        return krbError;
    }

    protected KrbIdentity getEntry(String principal) throws KrbException {
        KrbIdentity entry = this.kdcContext.getIdentityService().getIdentity(principal);
        return entry;
    }

    protected ByteBuffer getRequestBody() throws KrbException {
        return null;
    }

    public EncryptionKey getArmorKey() throws KrbException {
        return this.fastContext.getArmorKey();
    }

    protected void setArmorKey(EncryptionKey armorKey) {
        this.fastContext.setArmorKey(armorKey);
    }

    public PrincipalName getClientPrincipal() {
        return this.clientPrincipal;
    }

    public void setClientPrincipal(PrincipalName clientPrincipal) {
        this.clientPrincipal = clientPrincipal;
    }

    public PrincipalName getServerPrincipal() {
        return this.serverPrincipal;
    }

    public void setServerPrincipal(PrincipalName serverPrincipal) {
        this.serverPrincipal = serverPrincipal;
    }

    protected byte[] getInnerBodyout() {
        return this.innerBodyout;
    }

    protected boolean isToken() {
        return this.isToken;
    }

    public boolean isHttps() {
        return this.isHttps;
    }

    public void setHttps(boolean https) {
        this.isHttps = https;
    }

    public void setToken(AuthToken authToken) {
        this.token = authToken;
    }

    protected AuthToken getToken() {
        return this.token;
    }

    protected boolean isPkinit() {
        return this.isPkinit;
    }

    public boolean isAnonymous() {
        return this.getKdcOptions().isFlagSet((EnumType)KdcOption.REQUEST_ANONYMOUS);
    }

    public KdcOptions getKdcOptions() {
        return this.kdcReq.getReqBody().getKdcOptions();
    }

    public void setReqPackage(ByteBuffer reqPackage) {
        this.reqPackage = reqPackage;
    }

    public ByteBuffer getReqPackage() {
        return this.reqPackage;
    }
}

