/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc.security;

import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.CredentialsGSS;
import org.apache.hadoop.oncrpc.security.CredentialsNone;
import org.apache.hadoop.oncrpc.security.CredentialsSys;
import org.apache.hadoop.oncrpc.security.RpcAuthInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Credentials
extends RpcAuthInfo {
    public static final Logger LOG = LoggerFactory.getLogger(Credentials.class);
    protected int mCredentialsLength;

    public static Credentials readFlavorAndCredentials(XDR xdr) {
        Credentials credentials;
        RpcAuthInfo.AuthFlavor flavor = RpcAuthInfo.AuthFlavor.fromValue(xdr.readInt());
        if (flavor == RpcAuthInfo.AuthFlavor.AUTH_NONE) {
            credentials = new CredentialsNone();
        } else if (flavor == RpcAuthInfo.AuthFlavor.AUTH_SYS) {
            credentials = new CredentialsSys();
        } else if (flavor == RpcAuthInfo.AuthFlavor.RPCSEC_GSS) {
            credentials = new CredentialsGSS();
        } else {
            throw new UnsupportedOperationException("Unsupported Credentials Flavor " + flavor);
        }
        ((RpcAuthInfo)credentials).read(xdr);
        return credentials;
    }

    public static void writeFlavorAndCredentials(Credentials cred, XDR xdr) {
        if (cred instanceof CredentialsNone) {
            xdr.writeInt(RpcAuthInfo.AuthFlavor.AUTH_NONE.getValue());
        } else if (cred instanceof CredentialsSys) {
            xdr.writeInt(RpcAuthInfo.AuthFlavor.AUTH_SYS.getValue());
        } else if (cred instanceof CredentialsGSS) {
            xdr.writeInt(RpcAuthInfo.AuthFlavor.RPCSEC_GSS.getValue());
        } else {
            throw new UnsupportedOperationException("Cannot recognize the verifier");
        }
        cred.write(xdr);
    }

    protected Credentials(RpcAuthInfo.AuthFlavor flavor) {
        super(flavor);
    }
}

