/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNameNodeRespectsBindHostKeys {
    public static final Logger LOG = LoggerFactory.getLogger(TestNameNodeRespectsBindHostKeys.class);
    private static final String WILDCARD_ADDRESS = "0.0.0.0";
    private static final String LOCALHOST_SERVER_ADDRESS = "127.0.0.1:0";
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestNameNodeRespectsBindHostKeys.class.getSimpleName();

    private static String getRpcServerAddress(MiniDFSCluster cluster) {
        NameNodeRpcServer rpcServer = (NameNodeRpcServer)cluster.getNameNodeRpc();
        return rpcServer.getClientRpcServer().getListenerAddress().getAddress().toString();
    }

    private static String getServiceRpcServerAddress(MiniDFSCluster cluster) {
        NameNodeRpcServer rpcServer = (NameNodeRpcServer)cluster.getNameNodeRpc();
        return rpcServer.getServiceRpcServer().getListenerAddress().getAddress().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRpcBindHostKey() throws IOException {
        String address;
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        LOG.info("Testing without dfs.namenode.rpc-bind-host");
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            address = TestNameNodeRespectsBindHostKeys.getRpcServerAddress(cluster);
            Assert.assertThat((String)"Bind address not expected to be wildcard by default.", (Object)address, (Matcher)IsNot.not((Object)"/0.0.0.0"));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
                cluster = null;
            }
        }
        LOG.info("Testing with dfs.namenode.rpc-bind-host");
        conf.set("dfs.namenode.rpc-bind-host", WILDCARD_ADDRESS);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            address = TestNameNodeRespectsBindHostKeys.getRpcServerAddress(cluster);
            Assert.assertThat((String)("Bind address " + address + " is not wildcard."), (Object)address, (Matcher)Is.is((Object)"/0.0.0.0"));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testServiceRpcBindHostKey() throws IOException {
        String address;
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        LOG.info("Testing without dfs.namenode.servicerpc-bind-host");
        conf.set("dfs.namenode.servicerpc-address", LOCALHOST_SERVER_ADDRESS);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            address = TestNameNodeRespectsBindHostKeys.getServiceRpcServerAddress(cluster);
            Assert.assertThat((String)"Bind address not expected to be wildcard by default.", (Object)address, (Matcher)IsNot.not((Object)"/0.0.0.0"));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
                cluster = null;
            }
        }
        LOG.info("Testing with dfs.namenode.servicerpc-bind-host");
        conf.set("dfs.namenode.servicerpc-bind-host", WILDCARD_ADDRESS);
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            address = TestNameNodeRespectsBindHostKeys.getServiceRpcServerAddress(cluster);
            Assert.assertThat((String)("Bind address " + address + " is not wildcard."), (Object)address, (Matcher)Is.is((Object)"/0.0.0.0"));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testHttpBindHostKey() throws IOException {
        String address;
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        LOG.info("Testing without dfs.namenode.http-bind-host");
        try {
            conf.set("dfs.namenode.http-address", LOCALHOST_SERVER_ADDRESS);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            address = cluster.getNameNode().getHttpAddress().toString();
            Assert.assertFalse((String)"HTTP Bind address not expected to be wildcard by default.", (boolean)address.startsWith(WILDCARD_ADDRESS));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
                cluster = null;
            }
        }
        LOG.info("Testing with dfs.namenode.http-bind-host");
        conf.set("dfs.namenode.http-bind-host", WILDCARD_ADDRESS);
        try {
            conf.set("dfs.namenode.http-address", LOCALHOST_SERVER_ADDRESS);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            address = cluster.getNameNode().getHttpAddress().toString();
            Assert.assertTrue((String)("HTTP Bind address " + address + " is not wildcard."), (boolean)address.startsWith(WILDCARD_ADDRESS));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static void setupSsl() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.webhdfs.enabled", true);
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        Assert.assertTrue((boolean)base.mkdirs());
        String keystoresDir = new File(BASEDIR).getAbsolutePath();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestNameNodeRespectsBindHostKeys.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testHttpsBindHostKey() throws Exception {
        String address;
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        LOG.info("Testing behavior without dfs.namenode.https-bind-host");
        TestNameNodeRespectsBindHostKeys.setupSsl();
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        try {
            conf.set("dfs.namenode.https-address", LOCALHOST_SERVER_ADDRESS);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            address = cluster.getNameNode().getHttpsAddress().toString();
            Assert.assertFalse((String)"HTTP Bind address not expected to be wildcard by default.", (boolean)address.startsWith(WILDCARD_ADDRESS));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
                cluster = null;
            }
        }
        LOG.info("Testing behavior with dfs.namenode.https-bind-host");
        conf.set("dfs.namenode.https-bind-host", WILDCARD_ADDRESS);
        try {
            conf.set("dfs.namenode.https-address", LOCALHOST_SERVER_ADDRESS);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            address = cluster.getNameNode().getHttpsAddress().toString();
            Assert.assertTrue((String)("HTTP Bind address " + address + " is not wildcard."), (boolean)address.startsWith(WILDCARD_ADDRESS));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

