/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.webapp.NMView;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class ApplicationPage
extends NMView
implements YarnWebParams {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage.__> html) {
        this.commonPreHead(html);
        this.set("ui.dataTables.id", "containers");
        this.set(JQueryUI.initID((String)"ui.dataTables", (String)"containers"), this.containersTableInit());
        this.setTableStyles(html, "containers", new String[0]);
    }

    private String containersTableInit() {
        return JQueryUI.tableInit().append(",aoColumns:[null]}").toString();
    }

    protected Class<? extends SubView> content() {
        return ApplicationBlock.class;
    }

    public static class ApplicationBlock
    extends HtmlBlock
    implements YarnWebParams {
        private final Context nmContext;
        private final Configuration conf;
        private final RecordFactory recordFactory;

        @Inject
        public ApplicationBlock(Context nmContext, Configuration conf) {
            this.conf = conf;
            this.nmContext = nmContext;
            this.recordFactory = RecordFactoryProvider.getRecordFactory((Configuration)this.conf);
        }

        protected void render(HtmlBlock.Block html) {
            ApplicationId applicationID = ConverterUtils.toApplicationId((RecordFactory)this.recordFactory, (String)this.$("app.id"));
            Application app = (Application)this.nmContext.getApplications().get(applicationID);
            AppInfo info = new AppInfo(app);
            this.info("Application's information").__("ApplicationId", (Object)info.getId()).__("ApplicationState", (Object)info.getState()).__("User", (Object)info.getUser());
            Hamlet.TABLE containersListBody = html.__(InfoBlock.class).table("#containers");
            for (String containerIdStr : info.getContainers()) {
                ((Hamlet.TR)containersListBody.tr().td().a(this.url(new String[]{"container", containerIdStr}), containerIdStr).__()).__();
            }
            containersListBody.__();
        }
    }
}

