/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.FLENewEpochTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CnxManagerTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(FLENewEpochTest.class);
    protected static final int THRESHOLD = 4;
    int count;
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    File[] peerTmpdir;
    int[] peerQuorumPort;
    int[] peerClientPort;

    @Before
    public void setUp() throws Exception {
        this.count = 3;
        this.peers = new HashMap(this.count);
        this.peerTmpdir = new File[this.count];
        this.peerQuorumPort = new int[this.count];
        this.peerClientPort = new int[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.peerQuorumPort[i] = PortAssignment.unique();
            this.peerClientPort[i] = PortAssignment.unique();
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer((long)i, new InetSocketAddress("127.0.0.1", this.peerQuorumPort[i]), new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", this.peerClientPort[i])));
            this.peerTmpdir[i] = ClientBase.createTmpDir();
        }
    }

    ByteBuffer createMsg(int state, long leader, long zxid, long epoch) {
        byte[] requestBytes = new byte[28];
        ByteBuffer requestBuffer = ByteBuffer.wrap(requestBytes);
        requestBuffer.clear();
        requestBuffer.putInt(state);
        requestBuffer.putLong(leader);
        requestBuffer.putLong(zxid);
        requestBuffer.putLong(epoch);
        return requestBuffer;
    }

    @Test
    public void testCnxManager() throws Exception {
        CnxManagerThread thread = new CnxManagerThread();
        thread.start();
        QuorumPeer peer = new QuorumPeer(this.peers, this.peerTmpdir[1], this.peerTmpdir[1], this.peerClientPort[1], 3, 1L, 1000, 2, 2);
        QuorumCnxManager cnxManager = peer.createCnxnManager();
        QuorumCnxManager.Listener listener = cnxManager.listener;
        if (listener != null) {
            listener.start();
        } else {
            LOG.error("Null listener when initializing cnx manager");
        }
        cnxManager.toSend(Long.valueOf(0L), this.createMsg(QuorumPeer.ServerState.LOOKING.ordinal(), 1L, -1L, 1L));
        QuorumCnxManager.Message m = null;
        int numRetries = 1;
        while (m == null && numRetries++ <= 4) {
            m = cnxManager.pollRecvQueue(3000L, TimeUnit.MILLISECONDS);
            if (m != null) continue;
            cnxManager.connectAll();
        }
        Assert.assertTrue((String)"Exceeded number of retries", (numRetries <= 4 ? 1 : 0) != 0);
        thread.join(5000L);
        if (thread.isAlive()) {
            Assert.fail((String)"Thread didn't join");
        } else if (thread.failed) {
            Assert.fail((String)"Did not receive expected message");
        }
        cnxManager.halt();
        Assert.assertFalse((boolean)cnxManager.listener.isAlive());
    }

    @Test
    public void testCnxManagerTimeout() throws Exception {
        Random rand = new Random();
        byte b = (byte)rand.nextInt();
        int deadPort = PortAssignment.unique();
        String deadAddress = "10.1.1." + b;
        LOG.info("This is the dead address I'm trying: " + deadAddress);
        this.peers.put(2L, new QuorumPeer.QuorumServer(2L, new InetSocketAddress(deadAddress, deadPort), new InetSocketAddress(deadAddress, PortAssignment.unique()), new InetSocketAddress(deadAddress, PortAssignment.unique())));
        this.peerTmpdir[2] = ClientBase.createTmpDir();
        QuorumPeer peer = new QuorumPeer(this.peers, this.peerTmpdir[1], this.peerTmpdir[1], this.peerClientPort[1], 3, 1L, 1000, 2, 2);
        QuorumCnxManager cnxManager = peer.createCnxnManager();
        QuorumCnxManager.Listener listener = cnxManager.listener;
        if (listener != null) {
            listener.start();
        } else {
            LOG.error("Null listener when initializing cnx manager");
        }
        long begin = Time.currentElapsedTime();
        cnxManager.toSend(Long.valueOf(2L), this.createMsg(QuorumPeer.ServerState.LOOKING.ordinal(), 1L, -1L, 1L));
        long end = Time.currentElapsedTime();
        if (end - begin > 6000L) {
            Assert.fail((String)"Waited more than necessary");
        }
        cnxManager.halt();
        Assert.assertFalse((boolean)cnxManager.listener.isAlive());
    }

    @Test
    public void testCnxManagerSpinLock() throws Exception {
        QuorumPeer peer = new QuorumPeer(this.peers, this.peerTmpdir[1], this.peerTmpdir[1], this.peerClientPort[1], 3, 1L, 1000, 2, 2);
        QuorumCnxManager cnxManager = peer.createCnxnManager();
        QuorumCnxManager.Listener listener = cnxManager.listener;
        if (listener != null) {
            listener.start();
        } else {
            LOG.error("Null listener when initializing cnx manager");
        }
        int port = this.peers.get((Object)Long.valueOf((long)peer.getId())).electionAddr.getPort();
        LOG.info("Election port: " + port);
        Thread.sleep(1000L);
        SocketChannel sc = SocketChannel.open();
        sc.socket().connect(this.peers.get((Object)Long.valueOf((long)1L)).electionAddr, 5000);
        InetSocketAddress otherAddr = this.peers.get((Object)Long.valueOf((long)2L)).electionAddr;
        DataOutputStream dout = new DataOutputStream(sc.socket().getOutputStream());
        dout.writeLong(-65536L);
        dout.writeLong(2L);
        String addr = otherAddr.getHostString() + ":" + otherAddr.getPort();
        byte[] addr_bytes = addr.getBytes();
        dout.writeInt(addr_bytes.length);
        dout.write(addr_bytes);
        dout.flush();
        ByteBuffer msgBuffer = ByteBuffer.wrap(new byte[4]);
        msgBuffer.putInt(-20);
        msgBuffer.position(0);
        sc.write(msgBuffer);
        Thread.sleep(1000L);
        try {
            for (int i = 0; i < 100; ++i) {
                msgBuffer.position(0);
                sc.write(msgBuffer);
            }
            Assert.fail((String)"Socket has not been closed");
        }
        catch (Exception e) {
            LOG.info("Socket has been closed as expected");
        }
        peer.shutdown();
        cnxManager.halt();
        Assert.assertFalse((boolean)cnxManager.listener.isAlive());
    }

    @Test
    public void testCnxManagerListenerThreadConfigurableRetry() throws Exception {
        HashMap<Long, QuorumPeer.QuorumServer> unresolvablePeers = new HashMap<Long, QuorumPeer.QuorumServer>();
        long myid = 1L;
        unresolvablePeers.put(1L, new QuorumPeer.QuorumServer(1L, "unresolvable-domain.org:2182:2183;2181"));
        QuorumPeer peer = new QuorumPeer(unresolvablePeers, ClientBase.createTmpDir(), ClientBase.createTmpDir(), 2181, 3, 1L, 1000, 2, 2);
        QuorumCnxManager cnxManager = peer.createCnxnManager();
        QuorumCnxManager.Listener listener = cnxManager.listener;
        AtomicBoolean errorHappend = new AtomicBoolean();
        listener.setSocketBindErrorHandler(() -> errorHappend.set(true));
        listener.start();
        listener.join(15000L);
        Assert.assertFalse((boolean)listener.isAlive());
        Assert.assertTrue((boolean)errorHappend.get());
        Assert.assertFalse((String)(QuorumPeer.class.getSimpleName() + " not stopped after listener thread death"), (boolean)listener.isAlive());
    }

    @Test
    public void testCnxManagerNPE() throws Exception {
        this.peers.get((Object)Long.valueOf((long)2L)).type = QuorumPeer.LearnerType.OBSERVER;
        QuorumPeer peer = new QuorumPeer(this.peers, this.peerTmpdir[1], this.peerTmpdir[1], this.peerClientPort[1], 3, 1L, 1000, 2, 2);
        QuorumCnxManager cnxManager = peer.createCnxnManager();
        QuorumCnxManager.Listener listener = cnxManager.listener;
        if (listener != null) {
            listener.start();
        } else {
            LOG.error("Null listener when initializing cnx manager");
        }
        int port = this.peers.get((Object)Long.valueOf((long)peer.getId())).electionAddr.getPort();
        LOG.info("Election port: " + port);
        Thread.sleep(1000L);
        SocketChannel sc = SocketChannel.open();
        sc.socket().connect(this.peers.get((Object)Long.valueOf((long)1L)).electionAddr, 5000);
        byte[] msgBytes = new byte[8];
        ByteBuffer msgBuffer = ByteBuffer.wrap(msgBytes);
        msgBuffer.putLong(2L);
        msgBuffer.position(0);
        sc.write(msgBuffer);
        msgBuffer = ByteBuffer.wrap(new byte[8]);
        msgBuffer.putInt(4);
        msgBuffer.putInt(5);
        msgBuffer.position(0);
        sc.write(msgBuffer);
        QuorumCnxManager.Message m = cnxManager.pollRecvQueue(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)m);
        peer.shutdown();
        cnxManager.halt();
        Assert.assertFalse((boolean)cnxManager.listener.isAlive());
    }

    @Test
    public void testSocketTimeout() throws Exception {
        QuorumPeer peer = new QuorumPeer(this.peers, this.peerTmpdir[1], this.peerTmpdir[1], this.peerClientPort[1], 3, 1L, 2000, 2, 2);
        QuorumCnxManager cnxManager = peer.createCnxnManager();
        QuorumCnxManager.Listener listener = cnxManager.listener;
        if (listener != null) {
            listener.start();
        } else {
            LOG.error("Null listener when initializing cnx manager");
        }
        int port = this.peers.get((Object)Long.valueOf((long)peer.getId())).electionAddr.getPort();
        LOG.info("Election port: " + port);
        Thread.sleep(1000L);
        Socket sock = new Socket();
        sock.connect(this.peers.get((Object)Long.valueOf((long)1L)).electionAddr, 5000);
        long begin = Time.currentElapsedTime();
        cnxManager.receiveConnection(sock);
        long end = Time.currentElapsedTime();
        if (end - begin > (long)(peer.getSyncLimit() * peer.getTickTime() + 500)) {
            Assert.fail((String)"Waited more than necessary");
        }
        cnxManager.halt();
        Assert.assertFalse((boolean)cnxManager.listener.isAlive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWorkerThreads() throws Exception {
        ArrayList<QuorumPeer> peerList = new ArrayList<QuorumPeer>();
        try {
            for (int sid = 0; sid < 3; ++sid) {
                QuorumPeer peer = new QuorumPeer(this.peers, this.peerTmpdir[sid], this.peerTmpdir[sid], this.peerClientPort[sid], 3, (long)sid, 1000, 2, 2);
                LOG.info("Starting peer {}", (Object)peer.getId());
                peer.start();
                peerList.add(sid, peer);
            }
            String failure = this.verifyThreadCount(peerList, 4L);
            Assert.assertNull((String)failure, (Object)failure);
            for (int myid = 0; myid < 3; ++myid) {
                for (int i = 0; i < 5; ++i) {
                    QuorumPeer peer = peerList.get(myid);
                    LOG.info("Round {}, halting peer ", new Object[]{i, peer.getId()});
                    peer.shutdown();
                    peerList.remove(myid);
                    failure = this.verifyThreadCount(peerList, 2L);
                    Assert.assertNull((String)failure, (Object)failure);
                    peer = new QuorumPeer(this.peers, this.peerTmpdir[myid], this.peerTmpdir[myid], this.peerClientPort[myid], 3, (long)myid, 1000, 2, 2);
                    LOG.info("Round {}, restarting peer ", new Object[]{i, peer.getId()});
                    peer.start();
                    peerList.add(myid, peer);
                    failure = this.verifyThreadCount(peerList, 4L);
                    Assert.assertNull((String)failure, (Object)failure);
                }
            }
        }
        catch (Throwable throwable) {
            for (QuorumPeer quorumPeer : peerList) {
                quorumPeer.shutdown();
            }
            throw throwable;
        }
        for (QuorumPeer quorumPeer : peerList) {
            quorumPeer.shutdown();
        }
    }

    public String verifyThreadCount(ArrayList<QuorumPeer> peerList, long ecnt) throws InterruptedException {
        String failure = null;
        for (int i = 0; i < 480; ++i) {
            Thread.sleep(500L);
            failure = this._verifyThreadCount(peerList, ecnt);
            if (failure != null) continue;
            return null;
        }
        return failure;
    }

    public String _verifyThreadCount(ArrayList<QuorumPeer> peerList, long ecnt) {
        for (int myid = 0; myid < peerList.size(); ++myid) {
            QuorumPeer peer = peerList.get(myid);
            QuorumCnxManager cnxManager = peer.getQuorumCnxManager();
            long cnt = cnxManager.getThreadCount();
            if (cnt == ecnt) continue;
            return new Date() + " Incorrect number of Worker threads for sid=" + myid + " expected " + ecnt + " found " + cnt;
        }
        return null;
    }

    @Test
    public void testInitialMessage() throws Exception {
        QuorumCnxManager.InitialMessage msg;
        DataInputStream din;
        DataOutputStream dout;
        ByteArrayOutputStream bos;
        String hostport;
        try {
            hostport = "10.0.0.2:3888";
            bos = new ByteArrayOutputStream();
            dout = new DataOutputStream(bos);
            dout.writeLong(5L);
            dout.writeInt(hostport.getBytes().length);
            dout.writeBytes(hostport);
            din = new DataInputStream(new ByteArrayInputStream(bos.toByteArray()));
            msg = QuorumCnxManager.InitialMessage.parse((Long)-65530L, (DataInputStream)din);
            Assert.fail((String)"bad protocol version accepted");
        }
        catch (QuorumCnxManager.InitialMessage.InitialMessageException initialMessageException) {
            // empty catch block
        }
        try {
            hostport = this.createLongString(0x100000);
            bos = new ByteArrayOutputStream();
            dout = new DataOutputStream(bos);
            dout.writeLong(5L);
            dout.writeInt(hostport.getBytes().length);
            dout.writeBytes(hostport);
            din = new DataInputStream(new ByteArrayInputStream(bos.toByteArray()));
            msg = QuorumCnxManager.InitialMessage.parse((Long)-65536L, (DataInputStream)din);
            Assert.fail((String)"long message accepted");
        }
        catch (QuorumCnxManager.InitialMessage.InitialMessageException initialMessageException) {
            // empty catch block
        }
        try {
            hostport = "what's going on here?";
            bos = new ByteArrayOutputStream();
            dout = new DataOutputStream(bos);
            dout.writeLong(5L);
            dout.writeInt(hostport.getBytes().length);
            dout.writeBytes(hostport);
            din = new DataInputStream(new ByteArrayInputStream(bos.toByteArray()));
            msg = QuorumCnxManager.InitialMessage.parse((Long)-65536L, (DataInputStream)din);
            Assert.fail((String)"bad hostport accepted");
        }
        catch (QuorumCnxManager.InitialMessage.InitialMessageException initialMessageException) {
            // empty catch block
        }
        try {
            hostport = "10.0.0.2:3888";
            bos = new ByteArrayOutputStream();
            dout = new DataOutputStream(bos);
            dout.writeLong(5L);
            dout.writeInt(hostport.getBytes().length);
            dout.writeBytes(hostport);
            din = new DataInputStream(new ByteArrayInputStream(bos.toByteArray()));
            msg = QuorumCnxManager.InitialMessage.parse((Long)-65536L, (DataInputStream)din);
        }
        catch (QuorumCnxManager.InitialMessage.InitialMessageException ex) {
            Assert.fail((String)ex.toString());
        }
    }

    private String createLongString(int size) {
        StringBuilder sb = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            sb.append('x');
        }
        return sb.toString();
    }

    class CnxManagerThread
    extends Thread {
        boolean failed = false;

        CnxManagerThread() {
        }

        @Override
        public void run() {
            try {
                QuorumPeer peer = new QuorumPeer(CnxManagerTest.this.peers, CnxManagerTest.this.peerTmpdir[0], CnxManagerTest.this.peerTmpdir[0], CnxManagerTest.this.peerClientPort[0], 3, 0L, 1000, 2, 2);
                QuorumCnxManager cnxManager = peer.createCnxnManager();
                QuorumCnxManager.Listener listener = cnxManager.listener;
                if (listener != null) {
                    listener.start();
                } else {
                    LOG.error("Null listener when initializing cnx manager");
                }
                long sid = 1L;
                cnxManager.toSend(Long.valueOf(sid), CnxManagerTest.this.createMsg(QuorumPeer.ServerState.LOOKING.ordinal(), 0L, -1L, 1L));
                QuorumCnxManager.Message m = null;
                int numRetries = 1;
                while (m == null && numRetries++ <= 4) {
                    m = cnxManager.pollRecvQueue(3000L, TimeUnit.MILLISECONDS);
                    if (m != null) continue;
                    cnxManager.connectAll();
                }
                if (numRetries > 4) {
                    this.failed = true;
                    return;
                }
                cnxManager.testInitiateConnection(sid);
                m = cnxManager.pollRecvQueue(3000L, TimeUnit.MILLISECONDS);
                if (m == null) {
                    this.failed = true;
                    return;
                }
            }
            catch (Exception e) {
                LOG.error("Exception while running mock thread", (Throwable)e);
                Assert.fail((String)"Unexpected exception");
            }
        }
    }
}

