/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZKParameterized;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Parameterized.UseParametersRunnerFactory(value=ZKParameterized.RunnerFactory.class)
public class QuorumRequestPipelineTest
extends QuorumBase {
    protected QuorumPeer.ServerState serverState;
    protected final CountDownLatch callComplete = new CountDownLatch(1);
    protected boolean complete = false;
    protected static final String PARENT_PATH = "/foo";
    protected static final HashSet<String> CHILDREN = new HashSet<String>(Arrays.asList("1", "2", "3"));
    protected static final String AUTH_PROVIDER = "digest";
    protected static final byte[] AUTH = "hello".getBytes();
    protected static final byte[] DATA = "Hint Water".getBytes();
    protected TestableZooKeeper zkClient;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({QuorumPeer.ServerState.LEADING}, {QuorumPeer.ServerState.FOLLOWING}, {QuorumPeer.ServerState.OBSERVING});
    }

    public QuorumRequestPipelineTest(QuorumPeer.ServerState state) {
        this.serverState = state;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        ClientBase.CountdownWatcher clientWatch = new ClientBase.CountdownWatcher();
        super.setUp(true);
        this.zkClient = this.createClient(clientWatch, this.getPeersMatching(this.serverState));
        this.zkClient.addAuthInfo(AUTH_PROVIDER, AUTH);
        clientWatch.waitForConnected(CONNECTION_TIMEOUT);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.zkClient.close();
        super.tearDown();
    }

    private Stat create2EmptyNode(TestableZooKeeper zkClient, String path) throws Exception {
        Stat stat = new Stat();
        zkClient.create(path, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
        return stat;
    }

    @Test
    public void testCreate() throws Exception {
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assert.assertArrayEquals((String)String.format("%s Node created (create) with expected value", this.serverState), (byte[])DATA, (byte[])this.zkClient.getData(PARENT_PATH, false, null));
    }

    @Test
    public void testCreate2() throws Exception {
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        Assert.assertArrayEquals((String)String.format("%s Node created (create2) with expected value", this.serverState), (byte[])DATA, (byte[])this.zkClient.getData(PARENT_PATH, false, null));
    }

    @Test
    public void testDelete() throws Exception {
        this.create2EmptyNode(this.zkClient, PARENT_PATH);
        this.zkClient.delete(PARENT_PATH, -1);
        Assert.assertNull((String)String.format("%s Node no longer exists", this.serverState), (Object)this.zkClient.exists(PARENT_PATH, false));
    }

    @Test
    public void testExists() throws Exception {
        Stat stat = this.create2EmptyNode(this.zkClient, PARENT_PATH);
        Assert.assertEquals((String)String.format("%s Exists returns correct node stat", this.serverState), (Object)stat, (Object)this.zkClient.exists(PARENT_PATH, false));
    }

    @Test
    public void testSetAndGetData() throws Exception {
        this.create2EmptyNode(this.zkClient, PARENT_PATH);
        this.zkClient.setData(PARENT_PATH, DATA, -1);
        Assert.assertArrayEquals((String)String.format("%s Node updated with expected value", this.serverState), (byte[])DATA, (byte[])this.zkClient.getData(PARENT_PATH, false, null));
    }

    @Test
    public void testSetAndGetACL() throws Exception {
        this.create2EmptyNode(this.zkClient, PARENT_PATH);
        Assert.assertEquals((String)String.format("%s Node has open ACL", this.serverState), (Object)ZooDefs.Ids.OPEN_ACL_UNSAFE, (Object)this.zkClient.getACL(PARENT_PATH, new Stat()));
        this.zkClient.setACL(PARENT_PATH, ZooDefs.Ids.READ_ACL_UNSAFE, -1);
        Assert.assertEquals((String)String.format("%s Node has world read-only ACL", this.serverState), (Object)ZooDefs.Ids.READ_ACL_UNSAFE, (Object)this.zkClient.getACL(PARENT_PATH, new Stat()));
    }

    @Test
    public void testSetAndGetChildren() throws Exception {
        this.create2EmptyNode(this.zkClient, PARENT_PATH);
        for (String child : CHILDREN) {
            this.create2EmptyNode(this.zkClient, "/foo/" + child);
        }
        Assert.assertEquals((String)String.format("%s Parent has expected children", this.serverState), CHILDREN, new HashSet(this.zkClient.getChildren(PARENT_PATH, false)));
    }

    @Test
    public void testSetAndGetChildren2() throws Exception {
        this.create2EmptyNode(this.zkClient, PARENT_PATH);
        for (String child : CHILDREN) {
            this.create2EmptyNode(this.zkClient, "/foo/" + child);
        }
        Assert.assertEquals((String)String.format("%s Parent has expected children", this.serverState), CHILDREN, new HashSet(this.zkClient.getChildren(PARENT_PATH, false, null)));
    }

    @Test
    public void testSync() throws Exception {
        this.complete = false;
        this.create2EmptyNode(this.zkClient, PARENT_PATH);
        AsyncCallback.VoidCallback onSync = new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                QuorumRequestPipelineTest.this.complete = true;
                QuorumRequestPipelineTest.this.callComplete.countDown();
            }
        };
        this.zkClient.sync(PARENT_PATH, onSync, null);
        this.callComplete.await(30L, TimeUnit.SECONDS);
        Assert.assertTrue((String)String.format("%s Sync completed", this.serverState), (boolean)this.complete);
    }
}

