/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.LearnerSnapshot;
import org.apache.zookeeper.server.quorum.LearnerSnapshotThrottler;
import org.apache.zookeeper.server.quorum.SnapshotThrottleException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearnerSnapshotThrottlerTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(LearnerSnapshotThrottlerTest.class);

    @Test(expected=SnapshotThrottleException.class)
    public void testTooManySnapshotsNonessential() throws Exception {
        LearnerSnapshotThrottler throttler = new LearnerSnapshotThrottler(5);
        for (int i = 0; i < 6; ++i) {
            throttler.beginSnapshot(false);
        }
    }

    @Test(expected=SnapshotThrottleException.class)
    public void testTooManySnapshotsEssential() throws Exception {
        LearnerSnapshotThrottler throttler = new LearnerSnapshotThrottler(5);
        try {
            for (int i = 0; i < 6; ++i) {
                throttler.beginSnapshot(true);
            }
        }
        catch (SnapshotThrottleException ex) {
            Assert.fail((String)"essential snapshots should not be throttled");
        }
        throttler.endSnapshot();
        throttler.beginSnapshot(false);
    }

    @Test
    public void testNoThrottle() throws Exception {
        int i;
        LearnerSnapshotThrottler throttler = new LearnerSnapshotThrottler(5);
        try {
            for (i = 0; i < 6; ++i) {
                throttler.beginSnapshot(true);
            }
        }
        catch (SnapshotThrottleException ex) {
            Assert.fail((String)"essential snapshots should not be throttled");
        }
        throttler.endSnapshot();
        for (i = 0; i < 5; ++i) {
            throttler.endSnapshot();
            throttler.beginSnapshot(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTryWithResourceNoThrottle() throws Exception {
        LearnerSnapshotThrottler throttler = new LearnerSnapshotThrottler(1);
        for (int i = 0; i < 3; ++i) {
            try (LearnerSnapshot snapshot = throttler.beginSnapshot(false);){
                Assert.assertFalse((boolean)snapshot.isEssential());
                Assert.assertEquals((long)1L, (long)snapshot.getConcurrentSnapshotNumber());
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=SnapshotThrottleException.class)
    public void testTryWithResourceThrottle() throws Exception {
        LearnerSnapshotThrottler throttler = new LearnerSnapshotThrottler(1);
        try (LearnerSnapshot outer = throttler.beginSnapshot(true);
             LearnerSnapshot inner = throttler.beginSnapshot(false);){
            Assert.fail((String)"shouldn't be able to have both snapshots open");
        }
    }

    @Test
    public void testParallelNoThrottle() throws Exception {
        int numThreads = 50;
        final LearnerSnapshotThrottler throttler = new LearnerSnapshotThrottler(50);
        ExecutorService threadPool = Executors.newFixedThreadPool(50);
        final CountDownLatch threadStartLatch = new CountDownLatch(50);
        final CountDownLatch snapshotProgressLatch = new CountDownLatch(50);
        ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>(50);
        for (int i = 0; i < 50; ++i) {
            results.add(threadPool.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    threadStartLatch.countDown();
                    try {
                        threadStartLatch.await();
                        throttler.beginSnapshot(false);
                        snapshotProgressLatch.countDown();
                        snapshotProgressLatch.await();
                        throttler.endSnapshot();
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                }
            }));
        }
        for (Future future : results) {
            Assert.assertTrue((boolean)((Boolean)future.get()));
        }
    }

    @Test
    public void testPositiveTimeout() throws Exception {
        final LearnerSnapshotThrottler throttler = new LearnerSnapshotThrottler(1, 200L);
        ExecutorService threadPool = Executors.newFixedThreadPool(1);
        LearnerSnapshot first = throttler.beginSnapshot(false);
        final CountDownLatch snapshotProgressLatch = new CountDownLatch(1);
        Future<Boolean> result = threadPool.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    snapshotProgressLatch.countDown();
                    LearnerSnapshot second = throttler.beginSnapshot(false);
                    second.close();
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
        });
        snapshotProgressLatch.await();
        first.close();
        Assert.assertTrue((boolean)result.get());
    }

    @Test
    public void testHighContentionWithTimeout() throws Exception {
        int numThreads = 20;
        final LearnerSnapshotThrottler throttler = new LearnerSnapshotThrottler(2, 5000L);
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
        final CountDownLatch threadStartLatch = new CountDownLatch(numThreads);
        ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            results.add(threadPool.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    threadStartLatch.countDown();
                    try {
                        threadStartLatch.await();
                        LearnerSnapshot snap = throttler.beginSnapshot(false);
                        int snapshotNumber = snap.getConcurrentSnapshotNumber();
                        throttler.endSnapshot();
                        return snapshotNumber <= 2;
                    }
                    catch (Exception e) {
                        LOG.error("Exception trying to begin snapshot", (Throwable)e);
                        return false;
                    }
                }
            }));
        }
        for (Future future : results) {
            Assert.assertTrue((boolean)((Boolean)future.get()));
        }
    }
}

