/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.quorum.BufferStats;
import org.apache.zookeeper.test.ClientBase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOServerCnxnTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(NIOServerCnxnTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testOperationsAfterCnxnClose() throws IOException, InterruptedException, KeeperException {
        String path = "/a";
        try (TestableZooKeeper zk = this.createClient();){
            zk.create("/a", "test".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.assertNotNull((String)"Didn't create znode:/a", (Object)zk.exists("/a", false));
            Assert.assertTrue((String)"Didn't instantiate ServerCnxnFactory with NIOServerCnxnFactory!", (boolean)(this.serverFactory instanceof NIOServerCnxnFactory));
            Iterable connections = this.serverFactory.getConnections();
            for (ServerCnxn serverCnxn : connections) {
                serverCnxn.close();
                try {
                    serverCnxn.toString();
                }
                catch (Exception e) {
                    LOG.error("Exception while getting connection details!", (Throwable)e);
                    Assert.fail((String)"Shouldn't throw exception while getting connection details!");
                }
            }
        }
    }

    @Test
    public void testClientResponseStatsUpdate() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient();){
            BufferStats clientResponseStats = this.serverFactory.getZooKeeperServer().serverStats().getClientResponseStats();
            Assert.assertThat((String)"Last client response size should be initialized with INIT_VALUE", (Object)clientResponseStats.getLastBufferSize(), (Matcher)Matchers.equalTo((Object)-1));
            zk.create("/a", "test".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.assertThat((String)"Last client response size should be greater then zero after client request was performed", (Object)clientResponseStats.getLastBufferSize(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }
    }
}

