/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.HostProvider;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class CustomHostProviderTest
extends ZKTestCase
implements Watcher {
    private AtomicInteger counter = new AtomicInteger(3);

    public void process(WatchedEvent event) {
    }

    @Test
    public void testZooKeeperWithCustomHostProvider() throws IOException, InterruptedException {
        int CLIENT_PORT = PortAssignment.unique();
        SpecialHostProvider specialHostProvider = new SpecialHostProvider();
        int expectedCounter = 3;
        this.counter.set(expectedCounter);
        ZooKeeper zkDefaults = new ZooKeeper("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)this, false);
        ZooKeeper zkSpecial = new ZooKeeper("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)this, false, (HostProvider)specialHostProvider);
        Assert.assertTrue((this.counter.get() == expectedCounter ? 1 : 0) != 0);
        zkDefaults.updateServerList("127.0.0.1:" + PortAssignment.unique());
        Assert.assertTrue((this.counter.get() == expectedCounter ? 1 : 0) != 0);
        zkSpecial.updateServerList("127.0.0.1:" + PortAssignment.unique());
        Assert.assertTrue((this.counter.get() == --expectedCounter ? 1 : 0) != 0);
    }

    private class SpecialHostProvider
    implements HostProvider {
        private SpecialHostProvider() {
        }

        public int size() {
            return 1;
        }

        public InetSocketAddress next(long spinDelay) {
            return new InetSocketAddress("127.0.0.1", 2181);
        }

        public void onConnected() {
        }

        public boolean updateServerList(Collection<InetSocketAddress> serverAddresses, InetSocketAddress currentHost) {
            CustomHostProviderTest.this.counter.decrementAndGet();
            return false;
        }
    }
}

