/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.MapHost;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
public abstract class MapOutput<K, V> {
    private static AtomicInteger ID = new AtomicInteger(0);
    private final int id = ID.incrementAndGet();
    private final TaskAttemptID mapId;
    private final long size;
    private final boolean primaryMapOutput;

    public MapOutput(TaskAttemptID mapId, long size, boolean primaryMapOutput) {
        this.mapId = mapId;
        this.size = size;
        this.primaryMapOutput = primaryMapOutput;
    }

    public boolean isPrimaryMapOutput() {
        return this.primaryMapOutput;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MapOutput) {
            return this.id == ((MapOutput)obj).id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public TaskAttemptID getMapId() {
        return this.mapId;
    }

    public long getSize() {
        return this.size;
    }

    public abstract void shuffle(MapHost var1, InputStream var2, long var3, long var5, ShuffleClientMetrics var7, Reporter var8) throws IOException;

    public abstract void commit() throws IOException;

    public abstract void abort();

    public abstract String getDescription();

    public String toString() {
        return "MapOutput(" + this.mapId + ", " + this.getDescription() + ")";
    }

    public static class MapOutputComparator<K, V>
    implements Comparator<MapOutput<K, V>> {
        @Override
        public int compare(MapOutput<K, V> o1, MapOutput<K, V> o2) {
            if (o1.id == o2.id) {
                return 0;
            }
            if (o1.size < o2.size) {
                return -1;
            }
            if (o1.size > o2.size) {
                return 1;
            }
            if (o1.id < o2.id) {
                return -1;
            }
            return 1;
        }
    }
}

