/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticationHandler;
import org.apache.hadoop.security.token.delegation.web.PseudoDelegationTokenAuthenticationHandler;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.timeline.security.TimelineAuthenticationFilter;

public class TimelineAuthenticationFilterInitializer
extends FilterInitializer {
    @VisibleForTesting
    Map<String, String> filterConfig;

    protected void setAuthFilterConfig(Configuration conf) {
        this.filterConfig = new HashMap<String, String>();
        for (Map.Entry entry : conf.getPropsWithPrefix("hadoop.proxyuser").entrySet()) {
            this.filterConfig.put("proxyuser" + (String)entry.getKey(), (String)entry.getValue());
        }
        Map timelineAuthProps = AuthenticationFilterInitializer.getFilterConfigMap((Configuration)conf, (String)"yarn.timeline-service.http-authentication.");
        this.filterConfig.putAll(timelineAuthProps);
        this.filterConfig.put("delegation-token.token-kind", TimelineDelegationTokenIdentifier.KIND_NAME.toString());
    }

    protected Map<String, String> getFilterConfig() {
        return this.filterConfig;
    }

    public void initFilter(FilterContainer container, Configuration conf) {
        this.setAuthFilterConfig(conf);
        String authType = this.filterConfig.get("type");
        if (authType.equals("simple")) {
            this.filterConfig.put("type", PseudoDelegationTokenAuthenticationHandler.class.getName());
        } else if (authType.equals("kerberos")) {
            this.filterConfig.put("type", KerberosDelegationTokenAuthenticationHandler.class.getName());
        }
        this.filterConfig.put("delegation-token.token-kind", TimelineDelegationTokenIdentifier.KIND_NAME.toString());
        container.addGlobalFilter("Timeline Authentication Filter", TimelineAuthenticationFilter.class.getName(), this.filterConfig);
    }
}

