/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.Principal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.X509Certificate;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.OldCertUtil;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.SSLSessionUtil;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class ProvSSLSessionBase
extends BCExtendedSSLSession {
    protected final AtomicReference<ProvSSLSessionContext> sslSessionContext;
    protected final ConcurrentHashMap<String, Object> valueMap;
    protected final boolean fipsMode;
    protected final JcaTlsCrypto crypto;
    protected final String peerHost;
    protected final int peerPort;
    protected final long creationTime;
    protected final SSLSession exportSSLSession;

    ProvSSLSessionBase(ProvSSLSessionContext sslSessionContext, ConcurrentHashMap<String, Object> valueMap, String peerHost, int peerPort, long creationTime) {
        this.sslSessionContext = new AtomicReference<ProvSSLSessionContext>(sslSessionContext);
        this.valueMap = valueMap;
        this.fipsMode = null == sslSessionContext ? false : sslSessionContext.getContextData().isFipsMode();
        this.crypto = null == sslSessionContext ? null : sslSessionContext.getContextData().getCrypto();
        this.peerHost = peerHost;
        this.peerPort = peerPort;
        this.creationTime = creationTime;
        this.exportSSLSession = SSLSessionUtil.exportSSLSession(this);
    }

    protected abstract int getCipherSuiteTLS();

    protected abstract byte[] getIDArray();

    protected abstract JsseSecurityParameters getJsseSecurityParameters();

    protected abstract JsseSessionParameters getJsseSessionParameters();

    protected abstract Certificate getLocalCertificateTLS();

    protected abstract Certificate getPeerCertificateTLS();

    protected abstract ProtocolVersion getProtocolTLS();

    protected abstract void invalidateTLS();

    SSLSession getExportSSLSession() {
        return this.exportSSLSession;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProvSSLSessionBase)) {
            return false;
        }
        ProvSSLSessionBase other = (ProvSSLSessionBase)obj;
        return Arrays.areEqual((byte[])this.getIDArray(), (byte[])other.getIDArray());
    }

    @Override
    public int getApplicationBufferSize() {
        return 16384;
    }

    @Override
    public String getCipherSuite() {
        return ProvSSLContextSpi.getCipherSuiteName(this.getCipherSuiteTLS());
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public byte[] getId() {
        byte[] id = this.getIDArray();
        return TlsUtils.isNullOrEmpty(id) ? TlsUtils.EMPTY_BYTES : (byte[])id.clone();
    }

    @Override
    public java.security.cert.Certificate[] getLocalCertificates() {
        java.security.cert.Certificate[] chain;
        if (null != this.crypto && null != (chain = JsseUtils.getX509CertificateChain(this.crypto, this.getLocalCertificateTLS())) && chain.length > 0) {
            return chain;
        }
        return null;
    }

    @Override
    public Principal getLocalPrincipal() {
        if (null != this.crypto) {
            return JsseUtils.getSubject(this.crypto, this.getLocalCertificateTLS());
        }
        return null;
    }

    @Override
    public int getPacketBufferSize() {
        ProtocolVersion protocolVersion = this.getProtocolTLS();
        if (null == protocolVersion || !TlsUtils.isTLSv11(protocolVersion)) {
            return 18443;
        }
        if (TlsUtils.isTLSv13(protocolVersion)) {
            return 16911;
        }
        return 17413;
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        return OldCertUtil.getPeerCertificateChain(this);
    }

    @Override
    public java.security.cert.Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        java.security.cert.Certificate[] chain;
        if (null != this.crypto && null != (chain = JsseUtils.getX509CertificateChain(this.crypto, this.getPeerCertificateTLS())) && chain.length > 0) {
            return chain;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        X500Principal principal;
        if (null != this.crypto && null != (principal = JsseUtils.getSubject(this.crypto, this.getPeerCertificateTLS()))) {
            return principal;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    @Override
    public String getPeerHost() {
        return this.peerHost;
    }

    @Override
    public int getPeerPort() {
        return this.peerPort;
    }

    @Override
    public String getProtocol() {
        return ProvSSLContextSpi.getProtocolVersionName(this.getProtocolTLS());
    }

    @Override
    public SSLSessionContext getSessionContext() {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.sslSessionContext.get();
    }

    @Override
    public Object getValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("'name' cannot be null");
        }
        return this.valueMap.get(name);
    }

    ConcurrentHashMap<String, Object> getValueMap() {
        return this.valueMap;
    }

    @Override
    public String[] getValueNames() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.valueMap.keySet())).toArray(new String[0]);
    }

    public int hashCode() {
        return Arrays.hashCode((byte[])this.getIDArray());
    }

    @Override
    public final void invalidate() {
        this.implInvalidate(true);
    }

    final void invalidatedBySessionContext() {
        this.implInvalidate(false);
    }

    @Override
    public boolean isFipsMode() {
        return this.fipsMode;
    }

    @Override
    public boolean isValid() {
        if (null == this.sslSessionContext.get()) {
            return false;
        }
        return !TlsUtils.isNullOrEmpty(this.getIDArray());
    }

    @Override
    public void putValue(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("'name' cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("'value' cannot be null");
        }
        this.notifyUnbound(name, this.valueMap.put(name, value));
        this.notifyBound(name, value);
    }

    @Override
    public void removeValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("'name' cannot be null");
        }
        this.notifyUnbound(name, this.valueMap.remove(name));
    }

    public String toString() {
        return "Session(" + this.getCreationTime() + "|" + this.getCipherSuite() + ")";
    }

    protected void notifyBound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
    }

    protected void notifyUnbound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    private void implInvalidate(boolean removeFromSessionContext) {
        if (removeFromSessionContext) {
            ProvSSLSessionContext context = this.sslSessionContext.getAndSet(null);
            if (null != context) {
                context.removeSession(this.getIDArray());
            }
        } else {
            this.sslSessionContext.set(null);
        }
        this.invalidateTLS();
    }

    protected static ConcurrentHashMap<String, Object> createValueMap() {
        return new ConcurrentHashMap<String, Object>();
    }

    protected static long getCurrentTime() {
        return System.currentTimeMillis();
    }
}

