/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.AbstractAlgorithmConstraints;
import org.bouncycastle.jsse.provider.AlgorithmDecomposer;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DisabledAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    private static final Logger LOG = Logger.getLogger(DisabledAlgorithmConstraints.class.getName());
    private static final String INCLUDE_PREFIX = "include ";
    private static final String KEYWORD_KEYSIZE = "keySize";
    private final String logHeader;
    private final Set<String> disabledAlgorithms;
    private final Map<String, List<Constraint>> constraintsMap;

    static DisabledAlgorithmConstraints create(AlgorithmDecomposer decomposer, String propertyName, String defaultValue) {
        String[] entries = PropertyUtils.getStringArraySecurityProperty(propertyName, defaultValue);
        if (null == entries) {
            return null;
        }
        HashSet<String> disabledAlgorithms = new HashSet<String>();
        HashMap<String, List<Constraint>> constraintsMap = new HashMap<String, List<Constraint>>();
        for (int i = 0; i < entries.length; ++i) {
            if (DisabledAlgorithmConstraints.addConstraint(disabledAlgorithms, constraintsMap, entries[i])) continue;
            LOG.warning("Ignoring unsupported entry in '" + propertyName + "': " + entries[i]);
        }
        return new DisabledAlgorithmConstraints(decomposer, propertyName, Collections.unmodifiableSet(disabledAlgorithms), Collections.unmodifiableMap(constraintsMap));
    }

    private static boolean addConstraint(Set<String> disabledAlgorithms, Map<String, List<Constraint>> constraintsMap, String entry) {
        if (entry.regionMatches(true, 0, INCLUDE_PREFIX, 0, INCLUDE_PREFIX.length())) {
            return false;
        }
        int spacePos = entry.indexOf(32);
        if (spacePos < 0) {
            String algorithm = DisabledAlgorithmConstraints.getCanonicalAlgorithm(entry);
            disabledAlgorithms.add(algorithm);
            DisabledAlgorithmConstraints.addConstraint(constraintsMap, algorithm, DisabledConstraint.INSTANCE);
            return true;
        }
        String algorithm = DisabledAlgorithmConstraints.getCanonicalAlgorithm(entry.substring(0, spacePos));
        String policy = entry.substring(spacePos + 1).trim();
        int ampPos = policy.indexOf(38);
        if (ampPos >= 0) {
            return false;
        }
        if (policy.startsWith(KEYWORD_KEYSIZE)) {
            StringTokenizer tokenizer = new StringTokenizer(policy);
            if (!KEYWORD_KEYSIZE.equals(tokenizer.nextToken())) {
                return false;
            }
            BinOp op = BinOp.parse(tokenizer.nextToken());
            int constraint = Integer.parseInt(tokenizer.nextToken());
            if (tokenizer.hasMoreTokens()) {
                return false;
            }
            DisabledAlgorithmConstraints.addConstraint(constraintsMap, algorithm, new KeySizeConstraint(op, constraint));
            return true;
        }
        return false;
    }

    private static void addConstraint(Map<String, List<Constraint>> constraintsMap, String algorithm, Constraint constraint) {
        List<Constraint> constraintList = constraintsMap.get(algorithm);
        if (null == constraintList) {
            constraintList = new ArrayList<Constraint>(1);
            constraintsMap.put(algorithm, constraintList);
        }
        constraintList.add(constraint);
    }

    private static String getCanonicalAlgorithm(String algorithm) {
        if ("DiffieHellman".equalsIgnoreCase(algorithm)) {
            return "DH";
        }
        return algorithm.toUpperCase(Locale.ENGLISH).replace("SHA-", "SHA");
    }

    private static String getConstraintsAlgorithm(String algorithm, AlgorithmParameters parameters) {
        String canonicalAlgorithm;
        String parametersAlgorithm;
        if (null != parameters && null != (parametersAlgorithm = parameters.getAlgorithm()) && (canonicalAlgorithm = DisabledAlgorithmConstraints.getCanonicalAlgorithm(algorithm)).equalsIgnoreCase(DisabledAlgorithmConstraints.getCanonicalAlgorithm(parametersAlgorithm))) {
            return canonicalAlgorithm;
        }
        return null;
    }

    private DisabledAlgorithmConstraints(AlgorithmDecomposer decomposer, String propertyName, Set<String> disabledAlgorithms, Map<String, List<Constraint>> constraintsMap) {
        super(decomposer);
        this.logHeader = "[" + propertyName + "]";
        this.disabledAlgorithms = disabledAlgorithms;
        this.constraintsMap = constraintsMap;
    }

    @Override
    public final boolean permits(Set<BCCryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        DisabledAlgorithmConstraints.checkPrimitives(primitives);
        DisabledAlgorithmConstraints.checkAlgorithmName(algorithm);
        return this.implPermitsAlgorithm(primitives, algorithm, parameters);
    }

    @Override
    public final boolean permits(Set<BCCryptoPrimitive> primitives, Key key) {
        return this.checkConstraints(primitives, null, key, null);
    }

    @Override
    public final boolean permits(Set<BCCryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        DisabledAlgorithmConstraints.checkAlgorithmName(algorithm);
        return this.checkConstraints(primitives, algorithm, key, parameters);
    }

    private boolean checkConstraints(Set<BCCryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        DisabledAlgorithmConstraints.checkPrimitives(primitives);
        DisabledAlgorithmConstraints.checkKey(key);
        String keyAlgorithm = JsseUtils.getKeyAlgorithm(key);
        DisabledAlgorithmConstraints.checkAlgorithmName(keyAlgorithm);
        if (JsseUtils.isNameSpecified(algorithm) && !this.implPermitsAlgorithm(primitives, algorithm, parameters)) {
            return false;
        }
        if (!this.implPermitsKeyAlgorithm(primitives, keyAlgorithm)) {
            return false;
        }
        String constraintsAlgorithm = DisabledAlgorithmConstraints.getCanonicalAlgorithm(keyAlgorithm);
        for (Constraint constraint : this.getConstraints(constraintsAlgorithm)) {
            if (constraint.permits(key)) continue;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(this.logHeader + " constraints for '" + constraintsAlgorithm + "' do not permit given '" + keyAlgorithm + "' key");
            }
            return false;
        }
        return true;
    }

    private List<Constraint> getConstraints(String algorithm) {
        List<Constraint> result;
        if (null != algorithm && null != (result = this.constraintsMap.get(algorithm))) {
            return result;
        }
        return Collections.emptyList();
    }

    private boolean implPermitsAlgorithm(Set<BCCryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        if (this.containsAnyPartIgnoreCase(this.disabledAlgorithms, algorithm)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(this.logHeader + " disabled algorithm '" + algorithm + "'");
            }
            return false;
        }
        String constraintsAlgorithm = DisabledAlgorithmConstraints.getConstraintsAlgorithm(algorithm, parameters);
        for (Constraint constraint : this.getConstraints(constraintsAlgorithm)) {
            if (constraint.permits(parameters)) continue;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(this.logHeader + " constraints for '" + constraintsAlgorithm + "' do not permit algorithm '" + algorithm + "' for given parameters");
            }
            return false;
        }
        return true;
    }

    private boolean implPermitsKeyAlgorithm(Set<BCCryptoPrimitive> primitives, String keyAlgorithm) {
        if (this.containsAnyPartIgnoreCase(this.disabledAlgorithms, keyAlgorithm)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(this.logHeader + " disabled key algorithm '" + keyAlgorithm + "'");
            }
            return false;
        }
        return true;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class DisabledConstraint
    extends Constraint {
        static final DisabledConstraint INSTANCE = new DisabledConstraint();

        private DisabledConstraint() {
        }

        @Override
        public boolean permits(Key key) {
            return false;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static abstract class Constraint {
        private Constraint() {
        }

        boolean permits(AlgorithmParameters parameters) {
            return true;
        }

        boolean permits(Key key) {
            return true;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum BinOp {
        EQ("=="),
        GE(">="),
        GT(">"),
        LE("<="),
        LT("<"),
        NE("!=");

        private final String s;

        static boolean eval(BinOp op, int lhs, int rhs) {
            switch (op) {
                case EQ: {
                    return lhs == rhs;
                }
                case GE: {
                    return lhs >= rhs;
                }
                case GT: {
                    return lhs > rhs;
                }
                case LE: {
                    return lhs <= rhs;
                }
                case LT: {
                    return lhs < rhs;
                }
                case NE: {
                    return lhs != rhs;
                }
            }
            return true;
        }

        static BinOp parse(String s) {
            for (BinOp op : BinOp.values()) {
                if (!op.s.equals(s)) continue;
                return op;
            }
            throw new IllegalArgumentException("'s' is not a valid operator: " + s);
        }

        private BinOp(String s) {
            this.s = s;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class KeySizeConstraint
    extends Constraint {
        private final BinOp op;
        private final int constraint;

        private static int getKeySize(AlgorithmParameters parameters) {
            String algorithm = parameters.getAlgorithm();
            if ("EC".equals(algorithm)) {
                try {
                    ECParameterSpec spec = parameters.getParameterSpec(ECParameterSpec.class);
                    if (null != spec) {
                        return spec.getOrder().bitLength();
                    }
                }
                catch (InvalidParameterSpecException spec) {}
            } else if ("DiffieHellman".equals(algorithm)) {
                try {
                    DHParameterSpec spec = parameters.getParameterSpec(DHParameterSpec.class);
                    if (null != spec) {
                        return spec.getP().bitLength();
                    }
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    // empty catch block
                }
            }
            return -1;
        }

        private static int getKeySize(Key key) {
            if (key instanceof RSAKey) {
                RSAKey rsaKey = (RSAKey)((Object)key);
                return rsaKey.getModulus().bitLength();
            }
            if (key instanceof ECKey) {
                ECKey ecKey = (ECKey)((Object)key);
                return ecKey.getParams().getOrder().bitLength();
            }
            if (key instanceof DSAKey) {
                DSAKey dsaKey = (DSAKey)((Object)key);
                DSAParams dsaParams = dsaKey.getParams();
                if (null != dsaParams) {
                    return dsaParams.getP().bitLength();
                }
            } else {
                byte[] raw;
                SecretKey secretKey;
                String format;
                if (key instanceof DHKey) {
                    DHKey dhKey = (DHKey)((Object)key);
                    return dhKey.getParams().getP().bitLength();
                }
                if (key instanceof SecretKey && "RAW".equals(format = (secretKey = (SecretKey)key).getFormat()) && null != (raw = secretKey.getEncoded())) {
                    int byteLen = raw.length;
                    return byteLen > 0xFFFFFFF ? 0 : 8 * raw.length;
                }
            }
            return -1;
        }

        KeySizeConstraint(BinOp op, int constraint) {
            this.op = op;
            this.constraint = constraint;
        }

        @Override
        boolean permits(AlgorithmParameters parameters) {
            return this.checkKeySize(KeySizeConstraint.getKeySize(parameters));
        }

        @Override
        boolean permits(Key key) {
            return this.checkKeySize(KeySizeConstraint.getKeySize(key));
        }

        private boolean checkKeySize(int keySize) {
            if (keySize < 1) {
                return keySize < 0;
            }
            return !BinOp.eval(this.op, keySize, this.constraint);
        }
    }
}

