/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterFsck {
    public static final Logger LOG = LoggerFactory.getLogger(TestRouterFsck.class);
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static MountTableResolver mountTable;
    private static FileSystem routerFs;
    private static InetSocketAddress webAddress;
    private static List<MembershipState> memberships;

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 2);
        Configuration conf = new RouterConfigBuilder().stateStore().admin().rpc().http().build();
        cluster.addRouterOverrides(conf);
        cluster.startCluster();
        cluster.startRouters();
        cluster.waitClusterUp();
        routerContext = cluster.getRandomRouter();
        routerFs = routerContext.getFileSystem();
        Router router = routerContext.getRouter();
        mountTable = (MountTableResolver)router.getSubclusterResolver();
        webAddress = router.getHttpServerAddress();
        Assert.assertNotNull((Object)webAddress);
        StateStoreService stateStore = routerContext.getRouter().getStateStore();
        MembershipStore membership = (MembershipStore)stateStore.getRegisteredRecordStore(MembershipStore.class);
        GetNamenodeRegistrationsRequest request = GetNamenodeRegistrationsRequest.newInstance();
        GetNamenodeRegistrationsResponse response = membership.getNamenodeRegistrations(request);
        memberships = response.getNamenodeMemberships();
        Collections.sort(memberships);
    }

    @AfterClass
    public static void tearDown() {
        if (cluster != null) {
            cluster.stopRouter(routerContext);
            cluster.shutdown();
            cluster = null;
        }
    }

    @After
    public void clearMountTable() throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        GetMountTableEntriesRequest req1 = GetMountTableEntriesRequest.newInstance((String)"/");
        GetMountTableEntriesResponse response = mountTableManager.getMountTableEntries(req1);
        for (MountTable entry : response.getEntries()) {
            RemoveMountTableEntryRequest req2 = RemoveMountTableEntryRequest.newInstance((String)entry.getSourcePath());
            mountTableManager.removeMountTableEntry(req2);
        }
    }

    private boolean addMountTable(MountTable entry) throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTableManager = client.getMountTableManager();
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)entry);
        AddMountTableEntryResponse addResponse = mountTableManager.addMountTableEntry(addRequest);
        mountTable.loadCache(true);
        return addResponse.getStatus();
    }

    @Test
    public void testFsck() throws Exception {
        MountTable addEntry = MountTable.newInstance((String)"/testdir", Collections.singletonMap("ns0", "/testdir"));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        addEntry = MountTable.newInstance((String)"/testdir2", Collections.singletonMap("ns1", "/testdir2"));
        Assert.assertTrue((boolean)this.addMountTable(addEntry));
        routerFs.createNewFile(new Path("/testdir/testfile"));
        routerFs.createNewFile(new Path("/testdir2/testfile2"));
        routerFs.createNewFile(new Path("/testdir2/testfile3"));
        routerFs.createNewFile(new Path("/testdir2/testfile4"));
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            int nnCount;
            String out;
            HttpGet httpGet = new HttpGet("http://" + webAddress.getHostName() + ":" + webAddress.getPort() + "/fsck");
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);){
                Assert.assertEquals((long)200L, (long)httpResponse.getStatusLine().getStatusCode());
                out = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
                LOG.info(out);
                Assert.assertTrue((boolean)out.contains("Federated FSCK started"));
                Assert.assertTrue((boolean)out.contains("Total files:\t1"));
                Assert.assertTrue((boolean)out.contains("Total files:\t3"));
                Assert.assertTrue((boolean)out.contains("Federated FSCK ended"));
                nnCount = 0;
                for (MembershipState nn : memberships) {
                    if (nn.getState() != FederationNamenodeServiceState.ACTIVE) continue;
                    Assert.assertTrue((boolean)out.contains("Checking " + nn + " at " + nn.getWebAddress() + "\n"));
                    ++nnCount;
                }
                Assert.assertEquals((long)2L, (long)nnCount);
            }
            httpGet = new HttpGet("http://" + webAddress.getHostName() + ":" + webAddress.getPort() + "/fsck?path=/testdir");
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            try {
                Assert.assertEquals((long)200L, (long)httpResponse.getStatusLine().getStatusCode());
                out = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
                LOG.info(out);
                Assert.assertTrue((boolean)out.contains("Federated FSCK started"));
                Assert.assertTrue((boolean)out.contains("Total files:\t1"));
                Assert.assertFalse((boolean)out.contains("Total files:\t3"));
                Assert.assertTrue((boolean)out.contains("Federated FSCK ended"));
                nnCount = 0;
                for (MembershipState nn : memberships) {
                    if (nn.getState() != FederationNamenodeServiceState.ACTIVE) continue;
                    Assert.assertTrue((boolean)out.contains("Checking " + nn + " at " + nn.getWebAddress() + "\n"));
                    ++nnCount;
                }
                Assert.assertEquals((long)2L, (long)nnCount);
            }
            finally {
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
        }
    }
}

