/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.ipc.CallQueueManager;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestRpcBase;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRPCServerShutdown
extends TestRpcBase {
    public static final Logger LOG = LoggerFactory.getLogger(TestRPCServerShutdown.class);

    @Before
    public void setup() {
        this.setupConf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(timeout=30000L)
    public void testRPCServerShutdown() throws Exception {
        int numClients = 3;
        ArrayList<Future<Void>> res = new ArrayList<Future<Void>>();
        ExecutorService executorService = Executors.newFixedThreadPool(3);
        conf.setInt("ipc.client.connect.max.retries", 0);
        RPC.Builder builder = TestRPCServerShutdown.newServerBuilder(conf).setQueueSizePerHandler(1).setNumHandlers(1).setVerbose(true);
        RPC.Server server = TestRPCServerShutdown.setupTestServer(builder);
        final TestRpcBase.TestRpcService proxy = TestRPCServerShutdown.getClient(addr, conf);
        try {
            for (int i = 0; i < 3; ++i) {
                res.add(executorService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws ServiceException, InterruptedException {
                        proxy.sleep(null, TestRpcBase.newSleepRequest(100000));
                        return null;
                    }
                }));
            }
            while (server.getCallQueueLen() != 1 || TestRPCServerShutdown.countThreads(CallQueueManager.class.getName()) != 1 || TestRPCServerShutdown.countThreads(TestRpcBase.PBServerImpl.class.getName()) != 1) {
                Thread.sleep(100L);
            }
        }
        catch (Throwable throwable) {
            try {
                TestRPCServerShutdown.stop((Server)server, proxy);
                Assert.assertEquals((String)"Not enough clients", (long)3L, (long)res.size());
                for (Future future : res) {
                    try {
                        future.get();
                        Assert.fail((String)"Future get should not return");
                    }
                    catch (ExecutionException e) {
                        ServiceException se = (ServiceException)e.getCause();
                        Assert.assertTrue((String)("Unexpected exception: " + se), (boolean)(se.getCause() instanceof IOException));
                        LOG.info("Expected exception", e.getCause());
                    }
                }
                throw throwable;
            }
            finally {
                executorService.shutdown();
            }
        }
        try {
            TestRPCServerShutdown.stop((Server)server, proxy);
            Assert.assertEquals((String)"Not enough clients", (long)3L, (long)res.size());
            for (Future future : res) {
                try {
                    future.get();
                    Assert.fail((String)"Future get should not return");
                }
                catch (ExecutionException e) {
                    ServiceException se = (ServiceException)e.getCause();
                    Assert.assertTrue((String)("Unexpected exception: " + se), (boolean)(se.getCause() instanceof IOException));
                    LOG.info("Expected exception", e.getCause());
                }
            }
            return;
        }
        finally {
            executorService.shutdown();
        }
    }
}

