/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.fs.FileSystemStorageStatistics;
import org.apache.hadoop.fs.Statistic;
import org.apache.hadoop.fs.StorageStatistics;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileSystemStorageStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(TestFileSystemStorageStatistics.class);
    private FileSystemStorageStatistics storageStatistics = new FileSystemStorageStatistics("test-scheme");
    @Rule
    public final Timeout globalTimeout = new Timeout(10L, TimeUnit.SECONDS);
    private final Map<String, Long> expectedStats = new HashMap<String, Long>();

    @Before
    public void setup() {
        this.expectedStats.clear();
        for (Statistic op : Statistic.VALUES) {
            this.expectedStats.put(op.getSymbol(), RandomUtils.nextLong((long)0L, (long)100L));
        }
        this.storageStatistics.reset();
        for (Statistic op : Statistic.VALUES) {
            this.storageStatistics.incrementCounter(op, this.expectedStats.get(op.getSymbol()).longValue());
        }
    }

    @Test
    public void testGetLongStatistics() {
        Iterator iter = this.storageStatistics.getLongStatistics();
        while (iter.hasNext()) {
            StorageStatistics.LongStatistic longStat = (StorageStatistics.LongStatistic)iter.next();
            Assert.assertNotNull((Object)longStat);
            long expectedStat = this.expectedStats.get(longStat.getName());
            LOG.info("{}: FileSystem.Statistics={}, FileSystemStorageStatistics={}", new Object[]{longStat.getName(), expectedStat, longStat.getValue()});
            Assert.assertEquals((long)expectedStat, (long)longStat.getValue());
        }
    }

    @Test
    public void testGetLong() {
        for (Statistic op : Statistic.VALUES) {
            long expectedStat = this.expectedStats.get(op.getSymbol());
            long storageStatFromOp = this.storageStatistics.getLong(op);
            long storageStat = this.storageStatistics.getLong(op.getSymbol());
            LOG.info("{}: FileSystem.Statistics={}, FileSystemStorageStatistics={}", new Object[]{op, expectedStat, storageStat});
            Assert.assertEquals((long)expectedStat, (long)storageStatFromOp);
            Assert.assertEquals((long)expectedStat, (long)storageStat);
        }
    }
}

