/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.Serializable;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.util.resource.Resources;

class FSStarvedApps {
    private PriorityBlockingQueue<FSAppAttempt> appsToProcess = new PriorityBlockingQueue<FSAppAttempt>(10, new StarvationComparator());
    private FSAppAttempt appBeingProcessed;

    FSStarvedApps() {
    }

    void addStarvedApp(FSAppAttempt app) {
        if (!app.equals(this.appBeingProcessed) && !this.appsToProcess.contains(app)) {
            this.appsToProcess.add(app);
        }
    }

    FSAppAttempt take() throws InterruptedException {
        FSAppAttempt app;
        this.appBeingProcessed = null;
        this.appBeingProcessed = app = this.appsToProcess.take();
        return app;
    }

    private static class StarvationComparator
    implements Comparator<FSAppAttempt>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private StarvationComparator() {
        }

        @Override
        public int compare(FSAppAttempt app1, FSAppAttempt app2) {
            int ret = 1;
            if (Resources.fitsIn((Resource)app1.getStarvation(), (Resource)app2.getStarvation())) {
                ret = -1;
            }
            return ret;
        }
    }
}

