/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.common.AutoCloseDataSetLock;
import org.apache.hadoop.hdfs.server.common.DataNodeLockManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.DirectoryScanner;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.LocalReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBuilder;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.checker.VolumeCheckResult;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.DataNodeVolumeMetrics;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.LazyPersistTestCase;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestDirectoryScanner {
    private static final Logger LOG = LoggerFactory.getLogger(TestDirectoryScanner.class);
    private static final int DEFAULT_GEN_STAMP = 9999;
    private MiniDFSCluster cluster;
    private String bpid;
    private DFSClient client;
    private FsDatasetSpi<? extends FsVolumeSpi> fds = null;
    private DirectoryScanner scanner = null;
    private final Random rand = new Random();
    private final Random r = new Random();
    private static final int BLOCK_LENGTH = 100;
    private static final TestFsVolumeSpi TEST_VOLUME = new TestFsVolumeSpi();
    private static final String BPID_1 = "BP-783049782-127.0.0.1-1370971773491";
    private static final String BPID_2 = "BP-367845636-127.0.0.1-5895645674231";
    private static final String SEP = System.getProperty("file.separator");

    public Configuration getConfiguration() {
        HdfsConfiguration configuration = new HdfsConfiguration();
        configuration.setLong("dfs.blocksize", 100L);
        configuration.setInt("dfs.bytes-per-checksum", 1);
        configuration.setLong("dfs.heartbeat.interval", 1L);
        configuration.setLong("dfs.datanode.max.locked.memory", Shell.getMemlockLimit((Long)Long.MAX_VALUE).longValue());
        return configuration;
    }

    @Before
    public void setup() {
        LazyPersistTestCase.initCacheManipulator();
    }

    private List<LocatedBlock> createFile(String fileNamePrefix, long fileLen, boolean isLazyPersist) throws IOException {
        DistributedFileSystem fs = this.cluster.getFileSystem();
        Path filePath = new Path("/" + fileNamePrefix + ".dat");
        DFSTestUtil.createFile((FileSystem)fs, filePath, isLazyPersist, 1024, fileLen, 100L, (short)1, this.r.nextLong(), false);
        return this.client.getLocatedBlocks(filePath.toString(), 0L, fileLen).getLocatedBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long truncateBlockFile() throws IOException {
        try (AutoCloseDataSetLock lock = this.fds.acquireDatasetLockManager().writeLock(DataNodeLockManager.LockLevel.BLOCK_POOl, new String[]{this.bpid});){
            for (ReplicaInfo b : FsDatasetTestUtil.getReplicas(this.fds, this.bpid)) {
                long l;
                File f = new File(b.getBlockURI());
                File mf = new File(b.getMetadataURI());
                if (!f.exists() || f.length() == 0L || !mf.exists()) continue;
                FileOutputStream s = null;
                FileChannel channel = null;
                try {
                    s = new FileOutputStream(f);
                    channel = s.getChannel();
                    channel.truncate(0L);
                    LOG.info("Truncated block file " + f.getAbsolutePath());
                    l = b.getBlockId();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{channel, s});
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                        return 0L;
                    }
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{channel, s});
                return l;
            }
        }
    }

    private long deleteBlockFile() {
        try (AutoCloseDataSetLock lock = this.fds.acquireDatasetLockManager().writeLock(DataNodeLockManager.LockLevel.BLOCK_POOl, new String[]{this.bpid});){
            for (ReplicaInfo b : FsDatasetTestUtil.getReplicas(this.fds, this.bpid)) {
                File f = new File(b.getBlockURI());
                File mf = new File(b.getMetadataURI());
                if (!f.exists() || !mf.exists() || !f.delete()) continue;
                LOG.info("Deleting block file " + f.getAbsolutePath());
                long l = b.getBlockId();
                return l;
            }
        }
        return 0L;
    }

    private long deleteMetaFile() {
        try (AutoCloseDataSetLock lock = this.fds.acquireDatasetLockManager().writeLock(DataNodeLockManager.LockLevel.BLOCK_POOl, new String[]{this.bpid});){
            for (ReplicaInfo b : FsDatasetTestUtil.getReplicas(this.fds, this.bpid)) {
                if (!b.metadataExists() || !b.deleteMetadata()) continue;
                LOG.info("Deleting metadata " + b.getMetadataURI());
                long l = b.getBlockId();
                return l;
            }
        }
        return 0L;
    }

    private void duplicateBlock(long blockId) throws IOException {
        try (AutoCloseDataSetLock lock = this.fds.acquireDatasetLockManager().writeLock(DataNodeLockManager.LockLevel.BLOCK_POOl, new String[]{this.bpid});){
            ReplicaInfo b = FsDatasetTestUtil.fetchReplicaInfo(this.fds, this.bpid, blockId);
            try (FsDatasetSpi.FsVolumeReferences volumes = this.fds.getFsVolumeReferences();){
                for (FsVolumeSpi v : volumes) {
                    if (v.getStorageID().equals(b.getVolume().getStorageID())) continue;
                    File sourceBlock = new File(b.getBlockURI());
                    File sourceMeta = new File(b.getMetadataURI());
                    URI sourceRoot = b.getVolume().getStorageLocation().getUri();
                    URI destRoot = v.getStorageLocation().getUri();
                    String relativeBlockPath = sourceRoot.relativize(sourceBlock.toURI()).getPath();
                    String relativeMetaPath = sourceRoot.relativize(sourceMeta.toURI()).getPath();
                    File destBlock = new File(new File(destRoot).toString(), relativeBlockPath);
                    File destMeta = new File(new File(destRoot).toString(), relativeMetaPath);
                    destBlock.getParentFile().mkdirs();
                    FileUtils.copyFile((File)sourceBlock, (File)destBlock);
                    FileUtils.copyFile((File)sourceMeta, (File)destMeta);
                    if (!destBlock.exists() || !destMeta.exists()) continue;
                    LOG.info("Copied " + sourceBlock + " ==> " + destBlock);
                    LOG.info("Copied " + sourceMeta + " ==> " + destMeta);
                }
            }
        }
    }

    private long getFreeBlockId() {
        long id = this.rand.nextLong();
        while (FsDatasetTestUtil.fetchReplicaInfo(this.fds, this.bpid, id = this.rand.nextLong()) != null) {
        }
        return id;
    }

    private String getBlockFile(long id) {
        return "blk_" + id;
    }

    private String getMetaFile(long id) {
        return "blk_" + id + "_" + 9999 + ".meta";
    }

    private long createBlockFile(long id) throws IOException {
        try (FsDatasetSpi.FsVolumeReferences volumes = this.fds.getFsVolumeReferences();){
            int numVolumes = volumes.size();
            int index = this.rand.nextInt(numVolumes - 1);
            File finalizedDir = ((FsVolumeImpl)volumes.get(index)).getFinalizedDir(this.bpid);
            File file = new File(finalizedDir, this.getBlockFile(id));
            if (file.createNewFile()) {
                LOG.info("Created block file " + file.getName());
            }
        }
        return id;
    }

    private long createMetaFile() throws IOException {
        long id = this.getFreeBlockId();
        try (FsDatasetSpi.FsVolumeReferences refs = this.fds.getFsVolumeReferences();){
            int numVolumes = refs.size();
            int index = this.rand.nextInt(numVolumes - 1);
            File finalizedDir = ((FsVolumeImpl)refs.get(index)).getFinalizedDir(this.bpid);
            File file = new File(finalizedDir, this.getMetaFile(id));
            if (file.createNewFile()) {
                LOG.info("Created metafile " + file.getName());
            }
        }
        return id;
    }

    private long createBlockMetaFile(long id) throws IOException {
        try (FsDatasetSpi.FsVolumeReferences refs = this.fds.getFsVolumeReferences();){
            int numVolumes = refs.size();
            int index = this.rand.nextInt(numVolumes - 1);
            File finalizedDir = ((FsVolumeImpl)refs.get(index)).getFinalizedDir(this.bpid);
            File file = new File(finalizedDir, this.getBlockFile(id));
            if (file.createNewFile()) {
                LOG.info("Created block file " + file.getName());
                String name1 = file.getAbsolutePath() + ".l";
                String name2 = file.getAbsolutePath() + ".n";
                file = new File(name1);
                if (file.createNewFile()) {
                    LOG.info("Created extraneous file " + name1);
                }
                if ((file = new File(name2)).createNewFile()) {
                    LOG.info("Created extraneous file " + name2);
                }
                if ((file = new File(finalizedDir, this.getMetaFile(id))).createNewFile()) {
                    LOG.info("Created metafile " + file.getName());
                }
            }
        }
        return id;
    }

    private void scan(long totalBlocks, int diffsize, long missingMetaFile, long missingBlockFile, long missingMemoryBlocks, long mismatchBlocks) throws IOException, InterruptedException, TimeoutException {
        this.scan(totalBlocks, diffsize, missingMetaFile, missingBlockFile, missingMemoryBlocks, mismatchBlocks, 0L);
    }

    private void scan(long totalBlocks, int diffsize, long missingMetaFile, long missingBlockFile, long missingMemoryBlocks, long mismatchBlocks, long duplicateBlocks) throws IOException, InterruptedException, TimeoutException {
        this.scanner.reconcile();
        GenericTestUtils.waitFor(() -> {
            try {
                this.verifyStats(totalBlocks, diffsize, missingMetaFile, missingBlockFile, missingMemoryBlocks, mismatchBlocks, duplicateBlocks);
            }
            catch (AssertionError ex) {
                LOG.warn("Assertion Error", (Throwable)((Object)ex));
                return false;
            }
            return true;
        }, (long)100L, (long)2000L);
    }

    private void verifyStats(long totalBlocks, int diffsize, long missingMetaFile, long missingBlockFile, long missingMemoryBlocks, long mismatchBlocks, long duplicateBlocks) {
        List diff = this.scanner.diffs.getScanInfo(this.bpid);
        Assert.assertEquals((long)diffsize, (long)diff.size());
        DirectoryScanner.Stats stats = (DirectoryScanner.Stats)this.scanner.stats.get(this.bpid);
        Assert.assertNotNull((Object)stats);
        Assert.assertEquals((long)totalBlocks, (long)stats.totalBlocks);
        Assert.assertEquals((long)missingMetaFile, (long)stats.missingMetaFile);
        Assert.assertEquals((long)missingBlockFile, (long)stats.missingBlockFile);
        Assert.assertEquals((long)missingMemoryBlocks, (long)stats.missingMemoryBlocks);
        Assert.assertEquals((long)mismatchBlocks, (long)stats.mismatchBlocks);
        Assert.assertEquals((long)duplicateBlocks, (long)stats.duplicateBlocks);
    }

    @Test(timeout=300000L)
    public void testRetainBlockOnPersistentStorage() throws Exception {
        Configuration conf = this.getConfiguration();
        this.cluster = new MiniDFSCluster.Builder(conf).storageTypes(new StorageType[]{StorageType.RAM_DISK, StorageType.DEFAULT}).numDataNodes(1).build();
        try {
            this.cluster.waitActive();
            this.bpid = this.cluster.getNamesystem().getBlockPoolId();
            this.fds = DataNodeTestUtils.getFSDataset(this.cluster.getDataNodes().get(0));
            this.client = this.cluster.getFileSystem().getClient();
            this.scanner = new DirectoryScanner(this.fds, conf);
            this.scanner.setRetainDiffs(true);
            FsDatasetTestUtil.stopLazyWriter(this.cluster.getDataNodes().get(0));
            List<LocatedBlock> blocks = this.createFile(GenericTestUtils.getMethodName(), 100L, false);
            this.scan(1L, 0, 0L, 0L, 0L, 0L);
            this.duplicateBlock(blocks.get(0).getBlock().getBlockId());
            this.scan(2L, 1, 0L, 0L, 0L, 0L, 1L);
            this.verifyStorageType(blocks.get(0).getBlock().getBlockId(), false);
            this.scan(1L, 0, 0L, 0L, 0L, 0L);
        }
        finally {
            if (this.scanner != null) {
                this.scanner.shutdown();
                this.scanner = null;
            }
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testScanDirectoryStructureWarn() throws Exception {
        ByteArrayOutputStream loggerStream = new ByteArrayOutputStream();
        org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
        GenericTestUtils.setRootLogLevel((Level)Level.INFO);
        WriterAppender writerAppender = new WriterAppender((Layout)new SimpleLayout(), (OutputStream)loggerStream);
        rootLogger.addAppender((Appender)writerAppender);
        Configuration conf = this.getConfiguration();
        this.cluster = new MiniDFSCluster.Builder(conf).storageTypes(new StorageType[]{StorageType.RAM_DISK, StorageType.DEFAULT}).numDataNodes(1).build();
        try {
            this.cluster.waitActive();
            this.bpid = this.cluster.getNamesystem().getBlockPoolId();
            this.fds = DataNodeTestUtils.getFSDataset(this.cluster.getDataNodes().get(0));
            this.client = this.cluster.getFileSystem().getClient();
            this.scanner = new DirectoryScanner(this.fds, conf);
            this.scanner.setRetainDiffs(true);
            FsDatasetTestUtil.stopLazyWriter(this.cluster.getDataNodes().get(0));
            this.createFile(GenericTestUtils.getMethodName(), 100L, true);
            this.scan(1L, 0, 0L, 0L, 0L, 0L);
            this.deleteBlockFile();
            this.scan(1L, 1, 0L, 1L, 0L, 0L, 0L);
            String logContent = new String(loggerStream.toByteArray());
            String missingBlockWarn = "Deleted a metadata file for the deleted block";
            String dirStructureWarnLog = " found in invalid directory.  Expected directory: ";
            Assert.assertFalse((String)"directory check print meaningless warning message", (boolean)logContent.contains(dirStructureWarnLog));
            Assert.assertTrue((String)"missing block warn log not appear", (boolean)logContent.contains(missingBlockWarn));
            LOG.info("check pass");
        }
        finally {
            if (this.scanner != null) {
                this.scanner.shutdown();
                this.scanner = null;
            }
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test(timeout=300000L)
    public void testDeleteBlockOnTransientStorage() throws Exception {
        Configuration conf = this.getConfiguration();
        this.cluster = new MiniDFSCluster.Builder(conf).storageTypes(new StorageType[]{StorageType.RAM_DISK, StorageType.DEFAULT}).numDataNodes(1).build();
        try {
            this.cluster.waitActive();
            this.bpid = this.cluster.getNamesystem().getBlockPoolId();
            this.fds = DataNodeTestUtils.getFSDataset(this.cluster.getDataNodes().get(0));
            this.client = this.cluster.getFileSystem().getClient();
            this.scanner = new DirectoryScanner(this.fds, conf);
            this.scanner.setRetainDiffs(true);
            FsDatasetTestUtil.stopLazyWriter(this.cluster.getDataNodes().get(0));
            List<LocatedBlock> blocks = this.createFile(GenericTestUtils.getMethodName(), 100L, true);
            this.scan(1L, 0, 0L, 0L, 0L, 0L);
            this.duplicateBlock(blocks.get(0).getBlock().getBlockId());
            this.scan(2L, 1, 0L, 0L, 0L, 0L, 1L);
            this.verifyStorageType(blocks.get(0).getBlock().getBlockId(), false);
            this.scan(1L, 0, 0L, 0L, 0L, 0L);
        }
        finally {
            if (this.scanner != null) {
                this.scanner.shutdown();
                this.scanner = null;
            }
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testRegularBlock() throws Exception {
        Configuration conf = this.getConfiguration();
        this.cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            this.cluster.waitActive();
            this.bpid = this.cluster.getNamesystem().getBlockPoolId();
            this.fds = DataNodeTestUtils.getFSDataset(this.cluster.getDataNodes().get(0));
            this.client = this.cluster.getFileSystem().getClient();
            conf.setInt("dfs.datanode.directoryscan.threads", 1);
            GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs((Logger)NameNode.stateChangeLog);
            this.createFile(GenericTestUtils.getMethodName(), 500L, false);
            ArrayList<ReplicaInfo> infos = new ArrayList<ReplicaInfo>(FsDatasetTestUtil.getReplicas(this.fds, this.bpid));
            ReplicaInfo lastReplica = (ReplicaInfo)infos.get(infos.size() - 1);
            ReplicaInfo penultimateReplica = (ReplicaInfo)infos.get(infos.size() - 2);
            String blockParent = new File(lastReplica.getBlockURI().getPath()).getParent();
            File lastBlockFile = new File(blockParent, this.getBlockFile(lastReplica.getBlockId()));
            File penultimateBlockFile = new File(blockParent, this.getBlockFile(penultimateReplica.getBlockId()));
            FileUtil.symLink((String)lastBlockFile.toString(), (String)penultimateBlockFile.toString());
            ExtendedBlock block = new ExtendedBlock(this.bpid, penultimateReplica.getBlockId());
            this.scanner = new DirectoryScanner(this.fds, conf);
            this.scanner.setRetainDiffs(true);
            this.scanner.reconcile();
            DirectoryScanner.Stats stats = (DirectoryScanner.Stats)this.scanner.stats.get(this.bpid);
            Assert.assertNotNull((Object)stats);
            Assert.assertEquals((long)1L, (long)stats.mismatchBlocks);
            String msg = "*DIR* reportBadBlocks for block: " + this.bpid + ":" + this.getBlockFile(block.getBlockId());
            Assert.assertTrue((boolean)logCapturer.getOutput().contains(msg));
        }
        finally {
            if (this.scanner != null) {
                this.scanner.shutdown();
                this.scanner = null;
            }
            this.cluster.shutdown();
        }
    }

    @Test(timeout=600000L)
    public void testDirectoryScanner() throws Exception {
        for (int parallelism = 1; parallelism < 3; ++parallelism) {
            this.runTest(parallelism);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(int parallelism) throws Exception {
        Configuration conf = this.getConfiguration();
        this.cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            int i;
            this.cluster.waitActive();
            this.bpid = this.cluster.getNamesystem().getBlockPoolId();
            this.fds = DataNodeTestUtils.getFSDataset(this.cluster.getDataNodes().get(0));
            this.client = this.cluster.getFileSystem().getClient();
            conf.setInt("dfs.datanode.directoryscan.threads", parallelism);
            this.scanner = new DirectoryScanner(this.fds, conf);
            this.scanner.setRetainDiffs(true);
            this.createFile(GenericTestUtils.getMethodName(), 10000L, false);
            long totalBlocks = 100L;
            this.scan(100L, 0, 0L, 0L, 0L, 0L);
            long blockId = this.deleteMetaFile();
            this.scan(totalBlocks, 1, 1L, 0L, 0L, 1L);
            this.verifyGenStamp(blockId, 0L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            blockId = this.deleteBlockFile();
            this.scan(totalBlocks, 1, 0L, 1L, 0L, 0L);
            this.verifyDeletion(blockId);
            this.scan(--totalBlocks, 0, 0L, 0L, 0L, 0L);
            blockId = this.createBlockFile(blockId);
            this.scan(++totalBlocks, 1, 1L, 0L, 1L, 0L);
            this.verifyAddition(blockId, 0L, 0L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            blockId = this.createMetaFile();
            this.scan(totalBlocks + 1L, 1, 0L, 1L, 1L, 0L);
            File metafile = new File(this.getMetaFile(blockId));
            Assert.assertTrue((!metafile.exists() ? 1 : 0) != 0);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            blockId = this.deleteBlockFile();
            this.scan(totalBlocks, 1, 0L, 1L, 0L, 0L);
            --totalBlocks;
            this.verifyDeletion(blockId);
            blockId = this.createBlockMetaFile(blockId);
            this.scan(++totalBlocks, 1, 0L, 0L, 1L, 0L);
            this.verifyAddition(blockId, 9999L, 0L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            for (int i2 = 0; i2 < 10; ++i2) {
                blockId = this.deleteMetaFile();
            }
            this.scan(totalBlocks, 10, 10L, 0L, 0L, 10L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            ArrayList<Long> ids = new ArrayList<Long>();
            for (i = 0; i < 10; ++i) {
                ids.add(this.deleteBlockFile());
            }
            this.scan(totalBlocks, 10, 0L, 10L, 0L, 0L);
            this.scan(totalBlocks -= 10L, 0, 0L, 0L, 0L, 0L);
            for (i = 0; i < 10; ++i) {
                blockId = this.createBlockFile((Long)ids.get(i));
            }
            this.scan(totalBlocks += 10L, 10, 10L, 0L, 10L, 0L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            for (i = 0; i < 10; ++i) {
                blockId = this.createMetaFile();
            }
            this.scan(totalBlocks + 10L, 10, 0L, 10L, 10L, 0L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            ids.clear();
            for (i = 0; i < 10; ++i) {
                ids.add(this.deleteBlockFile());
            }
            this.scan(totalBlocks, 10, 0L, 10L, 0L, 0L);
            totalBlocks -= 10L;
            for (i = 0; i < 10; ++i) {
                blockId = this.createBlockMetaFile((Long)ids.get(i));
            }
            this.scan(totalBlocks += 10L, 10, 0L, 0L, 10L, 0L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            for (i = 0; i < 10; ++i) {
                this.truncateBlockFile();
            }
            this.scan(totalBlocks, 10, 0L, 0L, 0L, 10L);
            this.scan(totalBlocks, 0, 0L, 0L, 0L, 0L);
            long blockId1 = this.deleteBlockFile();
            long blockId2 = this.deleteBlockFile();
            this.scan(totalBlocks, 2, 0L, 2L, 0L, 0L);
            totalBlocks -= 2L;
            this.verifyDeletion(blockId1);
            this.verifyDeletion(blockId2);
            this.createMetaFile();
            this.createBlockFile(blockId1);
            this.createBlockMetaFile(blockId2);
            this.deleteMetaFile();
            this.deleteBlockFile();
            this.truncateBlockFile();
            this.scan(totalBlocks + 3L, 6, 2L, 2L, 3L, 2L);
            this.scan(totalBlocks + 1L, 0, 0L, 0L, 0L, 0L);
            Assert.assertTrue((String)"Throttle appears to be engaged", (this.scanner.timeWaitingMs.get() < 10L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Report complier threads logged no execution time", (this.scanner.timeRunningMs.get() > 0L ? 1 : 0) != 0);
            this.scanner.shutdown();
            Assert.assertFalse((boolean)this.scanner.getRunStatus());
        }
        finally {
            if (this.scanner != null) {
                this.scanner.shutdown();
                this.scanner = null;
            }
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThrottling() throws Exception {
        Configuration conf = new Configuration(this.getConfiguration());
        int blocks = 20000;
        int maxRetries = 3;
        this.cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            int count;
            int retries;
            int toCreate;
            this.cluster.waitActive();
            this.bpid = this.cluster.getNamesystem().getBlockPoolId();
            this.fds = DataNodeTestUtils.getFSDataset(this.cluster.getDataNodes().get(0));
            this.client = this.cluster.getFileSystem().getClient();
            conf.setInt("dfs.datanode.directoryscan.throttle.limit.ms.per.sec", 100);
            int maxBlocksPerFile = 10000;
            for (int numBlocksToCreate = blocks; numBlocksToCreate > 0; numBlocksToCreate -= toCreate) {
                toCreate = Math.min(10000, numBlocksToCreate);
                this.createFile(GenericTestUtils.getMethodName() + numBlocksToCreate, 100 * toCreate, false);
            }
            float ratio = 0.0f;
            for (retries = maxRetries; retries > 0 && (ratio < 7.0f || ratio > 10.0f); --retries) {
                this.scanner = new DirectoryScanner(this.fds, conf);
                ratio = this.runThrottleTest(blocks);
            }
            LOG.info("RATIO: " + ratio);
            Assert.assertTrue((String)"Throttle is too restrictive", (ratio <= 10.0f ? 1 : 0) != 0);
            Assert.assertTrue((String)("Throttle is too permissive" + ratio), (ratio >= 7.0f ? 1 : 0) != 0);
            conf.setInt("dfs.datanode.directoryscan.throttle.limit.ms.per.sec", 200);
            ratio = 0.0f;
            for (retries = maxRetries; retries > 0 && (ratio < 2.75f || ratio > 4.5f); --retries) {
                this.scanner = new DirectoryScanner(this.fds, conf);
                ratio = this.runThrottleTest(blocks);
            }
            LOG.info("RATIO: " + ratio);
            Assert.assertTrue((String)"Throttle is too restrictive", (ratio <= 4.5f ? 1 : 0) != 0);
            Assert.assertTrue((String)"Throttle is too permissive", (ratio >= 2.75f ? 1 : 0) != 0);
            conf.setInt("dfs.datanode.directoryscan.threads", 3);
            conf.setInt("dfs.datanode.directoryscan.throttle.limit.ms.per.sec", 100);
            ratio = 0.0f;
            for (retries = maxRetries; retries > 0 && (ratio < 7.0f || ratio > 10.0f); --retries) {
                this.scanner = new DirectoryScanner(this.fds, conf);
                ratio = this.runThrottleTest(blocks);
            }
            LOG.info("RATIO: " + ratio);
            Assert.assertTrue((String)"Throttle is too restrictive", (ratio <= 10.0f ? 1 : 0) != 0);
            Assert.assertTrue((String)"Throttle is too permissive", (ratio >= 7.0f ? 1 : 0) != 0);
            this.scanner = new DirectoryScanner(this.fds, this.getConfiguration());
            this.scanner.setRetainDiffs(true);
            this.scan(blocks, 0, 0L, 0L, 0L, 0L);
            this.scanner.shutdown();
            Assert.assertFalse((boolean)this.scanner.getRunStatus());
            Assert.assertTrue((String)"Throttle appears to be engaged", (this.scanner.timeWaitingMs.get() < 10L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Report complier threads logged no execution time", (this.scanner.timeRunningMs.get() > 0L ? 1 : 0) != 0);
            conf.setInt("dfs.datanode.directoryscan.throttle.limit.ms.per.sec", 1);
            ratio = 0.0f;
            ScheduledExecutorService interruptor = Executors.newScheduledThreadPool(maxRetries);
            try {
                for (retries = maxRetries; retries > 0 && ratio < 10.0f; --retries) {
                    this.scanner = new DirectoryScanner(this.fds, conf);
                    this.scanner.setRetainDiffs(true);
                    final AtomicLong nowMs = new AtomicLong();
                    interruptor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            nowMs.set(Time.monotonicNow());
                            TestDirectoryScanner.this.scanner.shutdown();
                        }
                    }, 2L, TimeUnit.SECONDS);
                    this.scanner.reconcile();
                    Assert.assertFalse((boolean)this.scanner.getRunStatus());
                    long finalMs = nowMs.get();
                    if (finalMs > 0L) {
                        LOG.info("Scanner took " + (Time.monotonicNow() - finalMs) + "ms to shutdown");
                        Assert.assertTrue((String)"Scanner took too long to shutdown", (Time.monotonicNow() - finalMs < 1000L ? 1 : 0) != 0);
                    }
                    ratio = (float)this.scanner.timeWaitingMs.get() / (float)this.scanner.timeRunningMs.get();
                }
            }
            finally {
                interruptor.shutdown();
            }
            LOG.info("RATIO: " + ratio);
            Assert.assertTrue((String)"Throttle is too permissive", (ratio > 8.0f ? 1 : 0) != 0);
            Assert.assertTrue((String)"Report complier threads logged no execution time", (this.scanner.timeRunningMs.get() > 0L ? 1 : 0) != 0);
            conf.setInt("dfs.datanode.directoryscan.throttle.limit.ms.per.sec", 0);
            this.scanner = new DirectoryScanner(this.fds, conf);
            this.scanner.setRetainDiffs(true);
            this.scan(blocks, 0, 0L, 0L, 0L, 0L);
            this.scanner.shutdown();
            Assert.assertFalse((boolean)this.scanner.getRunStatus());
            Assert.assertTrue((String)"Throttle appears to be engaged", (this.scanner.timeWaitingMs.get() < 10L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Report complier threads logged no execution time", (this.scanner.timeRunningMs.get() > 0L ? 1 : 0) != 0);
            conf.setInt("dfs.datanode.directoryscan.throttle.limit.ms.per.sec", 1000);
            this.scanner = new DirectoryScanner(this.fds, conf);
            this.scanner.setRetainDiffs(true);
            this.scan(blocks, 0, 0L, 0L, 0L, 0L);
            this.scanner.shutdown();
            Assert.assertFalse((boolean)this.scanner.getRunStatus());
            Assert.assertTrue((String)"Throttle appears to be engaged", (this.scanner.timeWaitingMs.get() < 10L ? 1 : 0) != 0);
            Assert.assertTrue((String)"Report complier threads logged no execution time", (this.scanner.timeRunningMs.get() > 0L ? 1 : 0) != 0);
            conf.setInt("dfs.datanode.directoryscan.threads", 1);
            conf.setInt("dfs.datanode.directoryscan.throttle.limit.ms.per.sec", 10);
            conf.setInt("dfs.datanode.directoryscan.interval", 1);
            this.scanner = new DirectoryScanner(this.fds, conf);
            this.scanner.setRetainDiffs(true);
            this.scanner.start();
            for (count = 50; count > 0 && this.scanner.timeWaitingMs.get() < 500L; --count) {
                Thread.sleep(100L);
            }
            this.scanner.shutdown();
            Assert.assertFalse((boolean)this.scanner.getRunStatus());
            Assert.assertTrue((String)"Throttle does not appear to be engaged", (count > 0 ? 1 : 0) != 0);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    private float runThrottleTest(int blocks) throws IOException, InterruptedException, TimeoutException {
        this.scanner.setRetainDiffs(true);
        this.scan(blocks, 0, 0L, 0L, 0L, 0L);
        this.scanner.shutdown();
        Assert.assertFalse((boolean)this.scanner.getRunStatus());
        return (float)this.scanner.timeWaitingMs.get() / (float)this.scanner.timeRunningMs.get();
    }

    private void verifyAddition(long blockId, long genStamp, long size) {
        ReplicaInfo replicainfo = FsDatasetTestUtil.fetchReplicaInfo(this.fds, this.bpid, blockId);
        Assert.assertNotNull((Object)replicainfo);
        File file = new File(this.getBlockFile(blockId));
        Assert.assertEquals((Object)file.getName(), (Object)FsDatasetTestUtil.getFile(this.fds, this.bpid, blockId).getName());
        Assert.assertEquals((long)genStamp, (long)replicainfo.getGenerationStamp());
        Assert.assertEquals((long)size, (long)replicainfo.getNumBytes());
    }

    private void verifyDeletion(long blockId) {
        Assert.assertNull((Object)FsDatasetTestUtil.fetchReplicaInfo(this.fds, this.bpid, blockId));
    }

    private void verifyGenStamp(long blockId, long genStamp) {
        ReplicaInfo memBlock = FsDatasetTestUtil.fetchReplicaInfo(this.fds, this.bpid, blockId);
        Assert.assertNotNull((Object)memBlock);
        Assert.assertEquals((long)genStamp, (long)memBlock.getGenerationStamp());
    }

    private void verifyStorageType(long blockId, boolean expectTransient) {
        ReplicaInfo memBlock = FsDatasetTestUtil.fetchReplicaInfo(this.fds, this.bpid, blockId);
        Assert.assertNotNull((Object)memBlock);
        MatcherAssert.assertThat((Object)memBlock.getVolume().isTransientStorage(), (Matcher)Is.is((Object)expectTransient));
    }

    void testScanInfoObject(long blockId, File baseDir, String blockFile, String metaFile) throws Exception {
        FsVolumeSpi.ScanInfo scanInfo = new FsVolumeSpi.ScanInfo(blockId, baseDir, blockFile, metaFile, (FsVolumeSpi)TEST_VOLUME);
        Assert.assertEquals((long)blockId, (long)scanInfo.getBlockId());
        if (blockFile != null) {
            Assert.assertEquals((Object)new File(baseDir, blockFile).getAbsolutePath(), (Object)scanInfo.getBlockFile().getAbsolutePath());
        } else {
            Assert.assertNull((Object)scanInfo.getBlockFile());
        }
        if (metaFile != null) {
            Assert.assertEquals((Object)new File(baseDir, metaFile).getAbsolutePath(), (Object)scanInfo.getMetaFile().getAbsolutePath());
        } else {
            Assert.assertNull((Object)scanInfo.getMetaFile());
        }
        Assert.assertEquals((Object)TEST_VOLUME, (Object)scanInfo.getVolume());
    }

    void testScanInfoObject(long blockId) throws Exception {
        FsVolumeSpi.ScanInfo scanInfo = new FsVolumeSpi.ScanInfo(blockId, null, null, null, null);
        Assert.assertEquals((long)blockId, (long)scanInfo.getBlockId());
        Assert.assertNull((Object)scanInfo.getBlockFile());
        Assert.assertNull((Object)scanInfo.getMetaFile());
    }

    @Test(timeout=120000L)
    public void TestScanInfo() throws Exception {
        this.testScanInfoObject(123L, new File(TEST_VOLUME.getFinalizedDir(BPID_1).getAbsolutePath()), "blk_123", "blk_123__1001.meta");
        this.testScanInfoObject(464L, new File(TEST_VOLUME.getFinalizedDir(BPID_1).getAbsolutePath()), "blk_123", null);
        this.testScanInfoObject(523L, new File(TEST_VOLUME.getFinalizedDir(BPID_1).getAbsolutePath()), null, "blk_123__1009.meta");
        this.testScanInfoObject(789L, null, null, null);
        this.testScanInfoObject(456L);
        this.testScanInfoObject(123L, new File(TEST_VOLUME.getFinalizedDir(BPID_2).getAbsolutePath()), "blk_567", "blk_567__1004.meta");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testExceptionHandlingWhileDirectoryScan() throws Exception {
        Configuration conf = this.getConfiguration();
        this.cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            this.cluster.waitActive();
            this.bpid = this.cluster.getNamesystem().getBlockPoolId();
            this.fds = DataNodeTestUtils.getFSDataset(this.cluster.getDataNodes().get(0));
            this.client = this.cluster.getFileSystem().getClient();
            conf.setInt("dfs.datanode.directoryscan.threads", 1);
            this.createFile(GenericTestUtils.getMethodName(), 200L, false);
            ArrayList<FsVolumeImpl> volumes = new ArrayList<FsVolumeImpl>();
            for (FsVolumeImpl volume : this.fds.getFsVolumeReferences()) {
                FsVolumeImpl spy = (FsVolumeImpl)Mockito.spy((Object)volume);
                ((FsVolumeImpl)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Error while getFinalizedDir")}).when((Object)spy)).getFinalizedDir(volume.getBlockPoolList()[0]);
                volumes.add(spy);
            }
            FsDatasetSpi.FsVolumeReferences volReferences = new FsDatasetSpi.FsVolumeReferences(volumes);
            FsDatasetSpi spyFds = (FsDatasetSpi)Mockito.spy(this.fds);
            ((FsDatasetSpi)Mockito.doReturn((Object)volReferences).when((Object)spyFds)).getFsVolumeReferences();
            this.scanner = new DirectoryScanner(spyFds, conf);
            this.scanner.setRetainDiffs(true);
            this.scanner.reconcile();
        }
        finally {
            if (this.scanner != null) {
                this.scanner.shutdown();
                this.scanner = null;
            }
            this.cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectoryScannerInFederatedCluster() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration(this.getConfiguration());
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHAFederatedTopology(2)).numDataNodes(1).build();){
            cluster.waitActive();
            cluster.transitionToActive(1);
            cluster.transitionToActive(3);
            this.fds = DataNodeTestUtils.getFSDataset(cluster.getDataNodes().get(0));
            DistributedFileSystem fs = cluster.getFileSystem(1);
            int bp1Files = 1;
            this.writeFile((FileSystem)fs, bp1Files);
            DistributedFileSystem fs2 = cluster.getFileSystem(3);
            int bp2Files = 2;
            this.writeFile((FileSystem)fs2, bp2Files);
            this.scanner = new DirectoryScanner(this.fds, (Configuration)conf);
            this.scanner.setRetainDiffs(true);
            this.scanner.reconcile();
            GenericTestUtils.waitFor(() -> {
                try {
                    this.bpid = cluster.getNamesystem(1).getBlockPoolId();
                    this.verifyStats(bp1Files, 0, 0L, 0L, 0L, 0L, 0L);
                    this.bpid = cluster.getNamesystem(3).getBlockPoolId();
                    this.verifyStats(bp2Files, 0, 0L, 0L, 0L, 0L, 0L);
                }
                catch (AssertionError ex) {
                    return false;
                }
                return true;
            }, (long)50L, (long)2000L);
        }
        finally {
            if (this.scanner != null) {
                this.scanner.shutdown();
                this.scanner = null;
            }
        }
    }

    @Test(timeout=3000L)
    public void testLocalReplicaParsing() {
        String baseDir = GenericTestUtils.getRandomizedTempPath();
        long blkId = this.getRandomBlockId();
        File blockDir = DatanodeUtil.idToBlockDir((File)new File(baseDir), (long)blkId);
        String subdir1 = new File(blockDir.getParent()).getName();
        LocalReplica.ReplicaDirInfo info = LocalReplica.parseBaseDir((File)new File(baseDir), (long)blkId);
        Assert.assertEquals((Object)baseDir, (Object)info.baseDirPath);
        Assert.assertEquals((Object)false, (Object)info.hasSubidrs);
        String pathWithOneSubdir = baseDir + SEP + subdir1;
        info = LocalReplica.parseBaseDir((File)new File(pathWithOneSubdir), (long)blkId);
        Assert.assertEquals((Object)pathWithOneSubdir, (Object)info.baseDirPath);
        Assert.assertEquals((Object)false, (Object)info.hasSubidrs);
        String badPath = baseDir + SEP + subdir1 + SEP + "subdir-not-exist";
        info = LocalReplica.parseBaseDir((File)new File(badPath), (long)blkId);
        Assert.assertEquals((Object)badPath, (Object)info.baseDirPath);
        Assert.assertEquals((Object)false, (Object)info.hasSubidrs);
        info = LocalReplica.parseBaseDir((File)blockDir, (long)blkId);
        Assert.assertEquals((Object)baseDir, (Object)info.baseDirPath);
        Assert.assertEquals((Object)true, (Object)info.hasSubidrs);
    }

    @Test(timeout=3000L)
    public void testLocalReplicaUpdateWithReplica() throws Exception {
        String baseDir = GenericTestUtils.getRandomizedTempPath();
        long blkId = this.getRandomBlockId();
        File blockDir = DatanodeUtil.idToBlockDir((File)new File(baseDir), (long)blkId);
        String subdir2 = blockDir.getName();
        String subdir1 = new File(blockDir.getParent()).getName();
        String diskSub = subdir2.equals("subdir0") ? "subdir1" : "subdir0";
        File diskBlockDir = new File(baseDir + SEP + subdir1 + SEP + diskSub);
        File realBlkFile = new File(diskBlockDir, "blk_" + blkId);
        File memBlockDir = blockDir;
        LocalReplica localReplica = (LocalReplica)new ReplicaBuilder(HdfsServerConstants.ReplicaState.FINALIZED).setDirectoryToUse(memBlockDir).setBlockId(blkId).build();
        StorageLocation sl = StorageLocation.parse((String)realBlkFile.toString());
        localReplica.updateWithReplica(sl);
        Assert.assertEquals((Object)realBlkFile, (Object)localReplica.getBlockFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testLastDirScannerFinishTimeIsUpdated() throws Exception {
        Configuration conf = this.getConfiguration();
        conf.setLong("dfs.datanode.directoryscan.interval", 3L);
        this.cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            this.cluster.waitActive();
            this.bpid = this.cluster.getNamesystem().getBlockPoolId();
            DataNode dn = this.cluster.getDataNodes().get(0);
            this.fds = DataNodeTestUtils.getFSDataset(this.cluster.getDataNodes().get(0));
            long lastDirScannerFinishTime = this.fds.getLastDirScannerFinishTime();
            dn.getDirectoryScanner().run();
            Assert.assertNotEquals((long)lastDirScannerFinishTime, (long)this.fds.getLastDirScannerFinishTime());
        }
        finally {
            this.cluster.shutdown();
        }
    }

    public long getRandomBlockId() {
        return Math.abs(new Random().nextLong());
    }

    private void writeFile(FileSystem fs, int numFiles) throws IOException {
        String fileName = "/" + GenericTestUtils.getMethodName();
        for (int i = 0; i < numFiles; ++i) {
            Path filePath = new Path(fileName + i);
            DFSTestUtil.createFile(fs, filePath, 1L, (short)1, 0L);
        }
    }

    private static class TestFsVolumeSpi
    implements FsVolumeSpi {
        private TestFsVolumeSpi() {
        }

        public String[] getBlockPoolList() {
            return new String[0];
        }

        public FsVolumeReference obtainReference() throws ClosedChannelException {
            return null;
        }

        public long getAvailable() throws IOException {
            return 0L;
        }

        public File getFinalizedDir(String bpid) throws IOException {
            return new File("/base/current/" + bpid + "/finalized");
        }

        public StorageType getStorageType() {
            return StorageType.DEFAULT;
        }

        public String getStorageID() {
            return "";
        }

        public boolean isTransientStorage() {
            return false;
        }

        public boolean isRAMStorage() {
            return false;
        }

        public void reserveSpaceForReplica(long bytesToReserve) {
        }

        public void releaseReservedSpace(long bytesToRelease) {
        }

        public void releaseLockedMemory(long bytesToRelease) {
        }

        public FsVolumeSpi.BlockIterator newBlockIterator(String bpid, String name) {
            throw new UnsupportedOperationException();
        }

        public FsVolumeSpi.BlockIterator loadBlockIterator(String bpid, String name) throws IOException {
            throw new UnsupportedOperationException();
        }

        public FsDatasetSpi getDataset() {
            throw new UnsupportedOperationException();
        }

        public StorageLocation getStorageLocation() {
            return null;
        }

        public URI getBaseURI() {
            return new File("/base").toURI();
        }

        public DF getUsageStats(Configuration conf) {
            return null;
        }

        public byte[] loadLastPartialChunkChecksum(File blockFile, File metaFile) throws IOException {
            return null;
        }

        public void compileReport(String bpid, Collection<FsVolumeSpi.ScanInfo> report, DirectoryScanner.ReportCompiler reportCompiler) throws InterruptedException, IOException {
        }

        public FileIoProvider getFileIoProvider() {
            return null;
        }

        public DataNodeVolumeMetrics getMetrics() {
            return null;
        }

        public VolumeCheckResult check(FsVolumeSpi.VolumeCheckContext context) throws Exception {
            return VolumeCheckResult.HEALTHY;
        }
    }
}

