/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.logging;

import java.io.Flushable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.BaseMapRUtil;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class MaprfsLogAppender
extends AppenderSkeleton
implements Flushable,
Syncable {
    private static final FsPermission DEFAULT_PERMISSIONS = new FsPermission(420);
    private FSDataOutputStream fsout;
    protected FileSystem maprFS;
    protected URI uri;
    protected String fileName;
    protected String nameHierarchy;
    protected Path fileNamePath;
    protected Appender failoverAppender;
    protected String failoverAppenderName;
    public int BUFFER_SIZE = 8192;
    private static String hostName;
    protected boolean immediateFlush = true;
    protected boolean immediateSync = false;
    protected long syncIntervalSeconds = -1L;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new SyncSchedulerFactory());
    private ScheduledFuture syncFuture;
    public static final String DIR_PREFIX;

    public MaprfsLogAppender(URI uri) {
        try {
            Configuration conf = new Configuration();
            this.maprFS = FileSystem.get((URI)uri, (Configuration)conf);
            this.fsout = this.maprFS.create(new Path(DIR_PREFIX, "defaultLog"), false, this.BUFFER_SIZE);
        }
        catch (IOException e) {
            LogLog.error((String)"Could not get MaprFs System or create an OutputStream for logging. Failing over to local logging", (Throwable)e);
            this.failoverToLocalLogs(e);
        }
    }

    public MaprfsLogAppender() {
    }

    public void setFailoverAppender(String failoverAppenderName) {
        this.failoverAppenderName = failoverAppenderName;
    }

    public void setURI(String uriStr) {
        try {
            this.uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            LogLog.error((String)("URI for maprFs system is not valid: " + uriStr), (Throwable)e);
        }
    }

    public void setImmediateFlush(boolean value) {
        this.immediateFlush = value;
    }

    public boolean getImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateSync(boolean value) {
        this.immediateSync = value;
    }

    public boolean getImmediateSync() {
        return this.immediateSync;
    }

    public void setSyncIntervalSeconds(long value) {
        this.syncIntervalSeconds = value;
    }

    public long getSyncIntervalSeconds() {
        return this.syncIntervalSeconds;
    }

    public void setFile(String fileName) {
        if (fileName != null) {
            int indexOfSlash;
            String[] paths = fileName.split("/");
            if (paths != null && paths.length > 0) {
                this.fileName = paths[paths.length - 1];
            }
            this.nameHierarchy = (indexOfSlash = fileName.lastIndexOf("/")) > 0 ? fileName.substring(0, fileName.lastIndexOf("/")) : "defaultapp";
        } else {
            LogLog.error((String)"Log file name is null. Check log4j configuration \"File\" property.");
        }
    }

    public String getFile() {
        Path finalPath = new Path(DIR_PREFIX, this.nameHierarchy);
        Path fileNamePath = new Path(finalPath, this.fileName);
        return fileNamePath.toString();
    }

    @VisibleForTesting
    protected void setFS(FileSystem fs) {
        this.maprFS = fs;
    }

    public void activateOptions() {
        if (this.fsout != null) {
            this.closeFile();
        }
        if (this.syncFuture != null) {
            this.syncFuture.cancel(false);
            this.syncFuture = null;
        }
        this.closed = false;
        if (this.uri != null && this.fileName != null) {
            try {
                Configuration conf = new Configuration();
                if (this.maprFS == null) {
                    this.maprFS = FileSystem.get((URI)this.uri, (Configuration)conf);
                }
                if (!this.createDirs()) {
                    this.failoverToLocalLogs(null);
                }
                Path finalPath = new Path(DIR_PREFIX, this.nameHierarchy);
                this.fileNamePath = new Path(finalPath, this.fileName);
                if (this.maprFS.exists(this.fileNamePath)) {
                    this.fsout = this.maprFS.append(this.fileNamePath, this.BUFFER_SIZE);
                    this.writeHeader();
                } else {
                    this.createFile(this.fileNamePath);
                }
                LogLog.debug((String)(this + ".activateOptions: fs=" + this.fsout + " if=" + this.immediateFlush + " is=" + this.immediateSync + " syncInterval=" + this.syncIntervalSeconds + " fileNamePath=" + this.fileNamePath));
                if (this.fsout != null && !this.immediateFlush && !this.immediateSync && this.syncIntervalSeconds > 0L) {
                    this.syncFuture = this.scheduler.scheduleAtFixedRate(new SyncTask((Syncable)this.fsout), this.syncIntervalSeconds, this.syncIntervalSeconds, TimeUnit.SECONDS);
                    LogLog.debug((String)("syncTask=" + this.syncFuture + " shutDown=" + this.scheduler.isShutdown()));
                }
            }
            catch (IOException e) {
                LogLog.error((String)"Could not get MaprFs System or create an OutputStream for logging. Failing over to local logging", (Throwable)e);
                this.failoverToLocalLogs(e);
            }
        } else {
            LogLog.error((String)"No URI or File provided. Failing over to local logging");
            if (this.fileName == null) {
                LogLog.error((String)"Log file name is null. Check log4j configuration \"File\" property.");
            }
            this.failoverToLocalLogs(null);
        }
    }

    @Override
    public void flush() {
        if (this.fsout == null) {
            return;
        }
        try {
            this.fsout.flush();
        }
        catch (IOException e) {
            LogLog.error((String)("Could not write to: " + this.fsout.getWrappedStream().toString() + ". Failing over to local logging"), (Throwable)e);
        }
        catch (Throwable t) {
            LogLog.error((String)"Fatal error while trying to write to maprfs.", (Throwable)t);
        }
    }

    @Deprecated
    public void sync() throws IOException {
        this.hsync();
    }

    public void hsync() {
        if (this.fsout == null) {
            return;
        }
        try {
            this.fsout.hsync();
        }
        catch (IOException e) {
            LogLog.error((String)("Could not write to: " + this.fsout.getWrappedStream().toString() + ". Failing over to local logging"), (Throwable)e);
        }
        catch (Throwable t) {
            LogLog.error((String)"Fatal error while trying to write to maprfs.", (Throwable)t);
        }
    }

    public void hflush() {
        if (this.fsout == null) {
            return;
        }
        try {
            this.fsout.hflush();
        }
        catch (IOException e) {
            LogLog.error((String)("Could not write to: " + this.fsout.getWrappedStream().toString() + ". Failing over to local logging"), (Throwable)e);
        }
        catch (Throwable t) {
            LogLog.error((String)"Fatal error while trying to write to maprfs.", (Throwable)t);
        }
    }

    protected void createFile(Path filePath) throws IOException {
        LogLog.debug((String)(new Date(System.currentTimeMillis()) + ": create file: " + filePath));
        this.fsout = this.maprFS.create(filePath, true, this.BUFFER_SIZE);
        this.writeHeader();
        this.maprFS.setPermission(filePath, this.getLogFilePermission());
    }

    protected void append(LoggingEvent event) {
        if (this.fsout == null) {
            return;
        }
        try {
            String[] s;
            this.fsout.write(this.layout.format(event).getBytes());
            if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
                int len = s.length;
                for (int i = 0; i < len; ++i) {
                    this.fsout.write(s[i].getBytes());
                    this.fsout.write(Layout.LINE_SEP.getBytes());
                }
            }
            if (this.immediateSync) {
                this.fsout.hsync();
            } else if (this.immediateFlush) {
                this.fsout.flush();
            }
        }
        catch (IOException e) {
            LogLog.error((String)("Could not write to: " + this.fsout.getWrappedStream().toString() + ". Failing over to local logging"), (Throwable)e);
            this.failoverToLocalLogs(e);
        }
        catch (Throwable t) {
            LogLog.error((String)"Fatal error while trying to write to maprfs. Failing over to local logging", (Throwable)t);
            this.failoverToLocalLogs(t);
        }
    }

    public synchronized void close() {
        try {
            if (this.closed) {
                return;
            }
            this.shutdownScheduler();
            this.closeFile();
        }
        catch (Throwable t) {
            LogLog.error((String)"Fatal error while trying to write to maprfs.", (Throwable)t);
        }
        finally {
            this.closed = true;
        }
    }

    protected void closeFile() {
        if (this.fsout == null) {
            return;
        }
        try {
            this.writeFooter();
            this.fsout.close();
        }
        catch (IOException e) {
            LogLog.error((String)"Error while closing.", (Throwable)e);
        }
        finally {
            this.fsout = null;
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    private boolean createDirs() throws IOException {
        if (!this.maprFS.exists(new Path(DIR_PREFIX))) {
            throw new IOException(DIR_PREFIX + " does not exist");
        }
        if (this.nameHierarchy == null || this.nameHierarchy.isEmpty()) {
            return true;
        }
        Path finalPath = new Path(DIR_PREFIX, this.nameHierarchy);
        if (!this.maprFS.exists(finalPath)) {
            this.maprFS.mkdirs(finalPath);
        }
        return true;
    }

    protected void writeFooter() {
        String f;
        if (this.layout != null && (f = this.layout.getFooter()) != null && this.fsout != null) {
            try {
                this.fsout.write(f.getBytes());
                this.fsout.flush();
            }
            catch (IOException e) {
                LogLog.error((String)("Could not write footer to: " + this.fsout.getWrappedStream().toString()), (Throwable)e);
            }
        }
    }

    protected void writeHeader() {
        String h;
        if (this.layout != null && (h = this.layout.getHeader()) != null && this.fsout != null) {
            try {
                this.fsout.write(h.getBytes());
            }
            catch (IOException e) {
                LogLog.error((String)("Could not write header to: " + this.fsout.getWrappedStream().toString()), (Throwable)e);
            }
            catch (Throwable t) {
                LogLog.error((String)"Fatal error while trying to write to maprfs.", (Throwable)t);
            }
        }
    }

    protected long getFileSize() throws IOException {
        return this.fsout == null ? -1L : (long)this.fsout.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void failoverToLocalLogs(Throwable reason) {
        try {
            this.shutdownScheduler();
            if (this.failoverAppenderName != null) {
                Appender failoverApp = this.getAllLoggersWithThisAppender(Logger.getRootLogger());
                if (failoverApp != null) {
                    Enumeration loggers = Logger.getRootLogger().getLoggerRepository().getCurrentLoggers();
                    while (loggers.hasMoreElements()) {
                        Logger loggerA = (Logger)loggers.nextElement();
                        if (loggerA.getAppender(this.getName()) == null) continue;
                        loggerA.removeAppender((Appender)this);
                        loggerA.addAppender(failoverApp);
                    }
                    Logger rootLogger = Logger.getRootLogger();
                    if (rootLogger.getAppender(this.getName()) != null) {
                        rootLogger.removeAppender((Appender)this);
                        rootLogger.addAppender(failoverApp);
                    }
                } else {
                    LogLog.error((String)"Failover appender not specified", (Throwable)reason);
                }
            }
        }
        finally {
            LogLog.warn((String)(this + ": closed and disabled due to errors."), (Throwable)reason);
            this.close();
        }
    }

    private Appender getAllLoggersWithThisAppender(Logger logger) {
        Appender failoverApp = logger.getAppender(this.failoverAppenderName);
        if (failoverApp != null) {
            return failoverApp;
        }
        Enumeration loggers = logger.getLoggerRepository().getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger loggerA = (Logger)loggers.nextElement();
            failoverApp = loggerA.getAppender(this.failoverAppenderName);
            if (failoverApp == null) continue;
            return failoverApp;
        }
        return null;
    }

    private void shutdownScheduler() {
        this.scheduler.shutdown();
        for (int i = 0; !this.scheduler.isShutdown() && i < 10; ++i) {
            try {
                if (this.scheduler.awaitTermination(30L, TimeUnit.SECONDS)) continue;
                this.scheduler.shutdownNow();
                LogLog.warn((String)(this + ": Could not stop the maprfs syncer after " + i + " attempts. Retrying ..."));
                continue;
            }
            catch (InterruptedException e) {
                LogLog.warn((String)(this + ": Spurious wakeup: rechecking isShutdown."));
            }
        }
    }

    protected FsPermission getLogFilePermission() {
        return DEFAULT_PERMISSIONS;
    }

    static {
        try {
            hostName = BaseMapRUtil.getMapRHostName();
            if (hostName == null) {
                LogLog.error((String)"Error obtaining host name from MapR configuration");
                InetAddress addr = InetAddress.getLocalHost();
                hostName = addr.getCanonicalHostName().toLowerCase();
            }
        }
        catch (UnknownHostException e) {
            LogLog.error((String)"Current Host Info can not be found. Defaulting to \"localhost\"", (Throwable)e);
            hostName = "localhost";
        }
        DIR_PREFIX = "/var/mapr/local/" + hostName + "/logs/";
    }

    private static final class SyncTask
    implements Runnable {
        private static final int MAX_CONSECUTIVE_ERRORS = 3;
        private static final String FATAL_MSG = "Reached maximum errors. Cancellinng.";
        private final Syncable resource;
        private int errorsUntilCancel;

        private SyncTask(Syncable r) {
            this.resource = r;
        }

        @Override
        public void run() {
            try {
                LogLog.debug((String)(this + " is being executed on " + this.resource));
                this.resource.hsync();
                this.errorsUntilCancel = 3;
            }
            catch (IOException e) {
                --this.errorsUntilCancel;
                if (this.errorsUntilCancel == 0) {
                    LogLog.error((String)FATAL_MSG, (Throwable)e);
                    throw new RuntimeException(FATAL_MSG, e);
                }
                LogLog.error((String)"SyncTask failed.", (Throwable)e);
            }
        }
    }

    private static final class SyncSchedulerFactory
    implements ThreadFactory {
        private final ThreadFactory dtf = Executors.defaultThreadFactory();

        private SyncSchedulerFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.dtf.newThread(r);
            t.setName(t.getName() + "-" + SyncSchedulerFactory.class.getName());
            t.setDaemon(true);
            return t;
        }
    }
}

