/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;

public class MapOutputFileInfo {
    public static final int MAPOUTPUT_INFO_BYTES = 16;
    private long mapOutputSize = 0L;
    private long fileBytesWritten = 0L;
    private FSDataOutputStream out = null;

    public MapOutputFileInfo(FSDataOutputStream out, long rawLength, long compressedLength) {
        this.out = out;
        this.mapOutputSize = rawLength;
        this.fileBytesWritten = compressedLength;
    }

    public MapOutputFileInfo(FSDataInputStream in, long fileSize) throws IOException {
        this(in, fileSize, true);
    }

    public MapOutputFileInfo(FSDataInputStream in, long fileSize, boolean checkLen) throws IOException {
        if (!checkLen) {
            this.mapOutputSize = 0L;
            this.fileBytesWritten = 0L;
        } else if (fileSize >= 16L) {
            long pos = in.getPos();
            in.seek(pos + (fileSize - 16L));
            this.mapOutputSize = in.readLong();
            this.fileBytesWritten = in.readLong();
            in.seek(pos);
            if (this.fileBytesWritten + 16L != fileSize) {
                throw new IOException("Data Corruption in map output. [filesize, pos, mapOutputSize, fileBytesWritten] is [" + fileSize + ", " + pos + ", " + this.mapOutputSize + ", " + this.fileBytesWritten + "]");
            }
        } else {
            throw new IOException("Data Corruption in map output. Incorrect fileSize " + fileSize);
        }
    }

    public long getMapOutputSize() {
        return this.mapOutputSize;
    }

    public long getFileBytesWritten() {
        return this.fileBytesWritten;
    }

    public void write() throws IOException {
        if (this.out == null) {
            throw new IOException("Failed to write. Output stream not initialized");
        }
        this.out.writeLong(this.mapOutputSize);
        this.out.writeLong(this.fileBytesWritten);
    }
}

