/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebAppUtil;
import org.apache.hadoop.yarn.server.router.RouterServerUtil;
import org.apache.hadoop.yarn.server.router.cleaner.SubClusterCleaner;
import org.apache.hadoop.yarn.server.router.clientrm.RouterClientRMService;
import org.apache.hadoop.yarn.server.router.rmadmin.RouterRMAdminService;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebApp;
import org.apache.hadoop.yarn.server.webproxy.FedAppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServlet;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.util.WebServiceClient;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Router
extends CompositeService {
    private static final Logger LOG = LoggerFactory.getLogger(Router.class);
    private static CompositeService.CompositeServiceShutdownHook routerShutdownHook;
    private Configuration conf;
    private AtomicBoolean isStopping = new AtomicBoolean(false);
    private JvmPauseMonitor pauseMonitor;
    @VisibleForTesting
    protected RouterClientRMService clientRMProxyService;
    @VisibleForTesting
    protected RouterRMAdminService rmAdminProxyService;
    private WebApp webApp;
    @VisibleForTesting
    protected String webAppAddress;
    private static long clusterTimeStamp;
    private FedAppReportFetcher fetcher = null;
    private static final String CMD_FORMAT_STATE_STORE = "-format-state-store";
    private static final String CMD_REMOVE_APPLICATION_FROM_STATE_STORE = "-remove-application-from-state-store";
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final String METRICS_NAME = "Router";
    private static final String UI2_WEBAPP_NAME = "/ui2";
    private ScheduledThreadPoolExecutor scheduledExecutorService;
    private SubClusterCleaner subClusterCleaner;

    public Router() {
        super(Router.class.getName());
    }

    protected void doSecureLogin() throws IOException {
        SecurityUtil.login((Configuration)this.conf, (String)"yarn.router.keytab.file", (String)"yarn.router.kerberos.principal", (String)this.getHostName(this.conf));
    }

    protected void serviceInit(Configuration config) throws Exception {
        this.conf = config;
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.clientRMProxyService = this.createClientRMProxyService();
        this.addService((Service)this.clientRMProxyService);
        this.rmAdminProxyService = this.createRMAdminProxyService();
        this.addService((Service)this.rmAdminProxyService);
        this.webAppAddress = WebAppUtils.getWebAppBindURL((Configuration)this.conf, (String)"yarn.router.bind-host", (String)WebAppUtils.getRouterWebAppURLWithoutScheme((Configuration)this.conf));
        DefaultMetricsSystem.initialize((String)METRICS_NAME);
        JvmMetrics jm = JvmMetrics.initSingleton((String)METRICS_NAME, null);
        this.pauseMonitor = new JvmPauseMonitor();
        this.addService((Service)this.pauseMonitor);
        jm.setPauseMonitor(this.pauseMonitor);
        this.subClusterCleaner = new SubClusterCleaner(this.conf);
        int scheduledExecutorThreads = this.conf.getInt("yarn.router.scheduled.executor.threads", 1);
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(scheduledExecutorThreads);
        WebServiceClient.initialize((Configuration)config);
        super.serviceInit(this.conf);
    }

    protected void serviceStart() throws Exception {
        try {
            this.doSecureLogin();
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed Router login", (Throwable)e);
        }
        boolean isDeregisterSubClusterEnabled = this.conf.getBoolean("yarn.router.deregister.subcluster.enabled", true);
        if (isDeregisterSubClusterEnabled) {
            long scCleanerIntervalMs = this.conf.getTimeDuration("yarn.router.subcluster.cleaner.interval.time", YarnConfiguration.DEFAULT_ROUTER_SUBCLUSTER_CLEANER_INTERVAL_TIME, TimeUnit.MILLISECONDS);
            this.scheduledExecutorService.scheduleAtFixedRate(this.subClusterCleaner, 0L, scCleanerIntervalMs, TimeUnit.MILLISECONDS);
            LOG.info("Scheduled SubClusterCleaner With Interval: {}.", (Object)DurationFormatUtils.formatDurationISO((long)scCleanerIntervalMs));
        }
        this.startWepApp();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.webApp != null) {
            this.webApp.stop();
        }
        if (this.isStopping.getAndSet(true)) {
            return;
        }
        super.serviceStop();
        DefaultMetricsSystem.shutdown();
        WebServiceClient.destroy();
    }

    protected void shutDown() {
        new Thread(() -> ((Router)this).stop()).start();
    }

    protected RouterClientRMService createClientRMProxyService() {
        return new RouterClientRMService();
    }

    protected RouterRMAdminService createRMAdminProxyService() {
        return new RouterRMAdminService();
    }

    @InterfaceAudience.Private
    public WebApp getWebapp() {
        return this.webApp;
    }

    @VisibleForTesting
    public void startWepApp() {
        boolean enableCors = this.conf.getBoolean("yarn.router.webapp.cross-origin.enabled", false);
        if (enableCors) {
            this.conf.setBoolean("hadoop.http.cross-origin.enabled", true);
        }
        LOG.info("Instantiating RouterWebApp at {}.", (Object)this.webAppAddress);
        RMWebAppUtil.setupSecurityAndFilters((Configuration)this.conf, null);
        WebApps.Builder builder = WebApps.$for((String)"cluster", null, null, (String)"ws").with(this.conf).at(this.webAppAddress);
        if (RouterServerUtil.isRouterWebProxyEnable(this.conf)) {
            this.fetcher = new FedAppReportFetcher(this.conf);
            builder.withServlet("proxy", "/proxy/*", WebAppProxyServlet.class);
            builder.withAttribute("AppUrlFetcher", (Object)this.fetcher);
            String proxyHostAndPort = Router.getProxyHostAndPort(this.conf);
            String[] proxyParts = proxyHostAndPort.split(":");
            builder.withAttribute("proxyHost", (Object)proxyParts[0]);
        }
        this.webApp = builder.start((WebApp)new RouterWebApp(this), this.getUIWebAppContext());
    }

    private WebAppContext getUIWebAppContext() {
        WebAppContext uiWebAppContext = null;
        boolean isWebUI2Enabled = this.conf.getBoolean("yarn.webapp.ui2.enable", true);
        if (isWebUI2Enabled) {
            String onDiskPath = this.conf.get("yarn.webapp.ui2.war-file-path");
            uiWebAppContext = new WebAppContext();
            uiWebAppContext.setContextPath(UI2_WEBAPP_NAME);
            if (null == onDiskPath) {
                String war = "hadoop-yarn-ui-" + VersionInfo.getVersion() + ".war";
                URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(war);
                onDiskPath = null == url ? this.getWebAppsPath("ui2") : url.getFile();
            }
            if (onDiskPath == null || onDiskPath.isEmpty()) {
                LOG.error("No war file or webapps found for yarn federation!");
            } else if (onDiskPath.endsWith(".war")) {
                uiWebAppContext.setWar(onDiskPath);
                LOG.info("Using war file at: {}.", (Object)onDiskPath);
            } else {
                uiWebAppContext.setResourceBase(onDiskPath);
                LOG.info("Using webapps at: {}.", (Object)onDiskPath);
            }
        }
        return uiWebAppContext;
    }

    private String getWebAppsPath(String appName) {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("webapps/" + appName);
        if (url == null) {
            return "";
        }
        return url.toString();
    }

    public static String getProxyHostAndPort(Configuration conf) {
        String addr = conf.get("yarn.web-proxy.address");
        if (addr == null || addr.isEmpty()) {
            InetSocketAddress address = conf.getSocketAddr("yarn.router.webapp.address", "0.0.0.0:8089", 8089);
            addr = WebAppUtils.getResolvedAddress((InetSocketAddress)address);
        }
        return addr;
    }

    public static void main(String[] argv) {
        YarnConfiguration conf = new YarnConfiguration();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(Router.class, (String[])argv, (Logger)LOG);
        Router router = new Router();
        try {
            GenericOptionsParser hParser = new GenericOptionsParser((Configuration)conf, argv);
            argv = hParser.getRemainingArgs();
            if (argv.length > 1) {
                Router.executeRouterCommand((Configuration)conf, argv);
            } else {
                if (null != routerShutdownHook) {
                    ShutdownHookManager.get().removeShutdownHook((Runnable)routerShutdownHook);
                }
                routerShutdownHook = new CompositeService.CompositeServiceShutdownHook((CompositeService)router);
                ShutdownHookManager.get().addShutdownHook((Runnable)routerShutdownHook, 30);
                router.init((Configuration)conf);
                router.start();
            }
        }
        catch (Throwable t) {
            LOG.error("Error starting Router", t);
            System.exit(-1);
        }
    }

    @VisibleForTesting
    public RouterClientRMService getClientRMProxyService() {
        return this.clientRMProxyService;
    }

    @VisibleForTesting
    public RouterRMAdminService getRmAdminProxyService() {
        return this.rmAdminProxyService;
    }

    private String getHostName(Configuration config) throws UnknownHostException {
        String name = config.get("yarn.router.kerberos.principal.hostname");
        if (name == null) {
            name = InetAddress.getLocalHost().getHostName();
        }
        return name;
    }

    public static long getClusterTimeStamp() {
        return clusterTimeStamp;
    }

    @VisibleForTesting
    public FedAppReportFetcher getFetcher() {
        return this.fetcher;
    }

    @VisibleForTesting
    public static void removeApplication(Configuration conf, String applicationId) throws Exception {
        FederationStateStoreFacade facade = FederationStateStoreFacade.getInstance((Configuration)conf);
        ApplicationId removeAppId = ApplicationId.fromString((String)applicationId);
        LOG.info("Deleting application {} from state store.", (Object)removeAppId);
        facade.deleteApplicationHomeSubCluster(removeAppId);
        LOG.info("Application is deleted from state store");
    }

    private static void handFormatStateStore(Configuration conf) {
        try {
            System.out.println("Deleting Federation state store.");
            FederationStateStoreFacade facade = FederationStateStoreFacade.getInstance((Configuration)conf);
            System.out.println("Federation state store has been cleaned.");
            facade.deleteStore();
        }
        catch (Exception e) {
            System.err.println("Delete Federation state store error, exception = " + e);
        }
    }

    private static void handRemoveApplicationFromStateStore(Configuration conf, String applicationId) {
        try {
            Router.removeApplication(conf, applicationId);
            System.out.println("Application " + applicationId + " is deleted from state store");
        }
        catch (Exception e) {
            System.err.println("Application " + applicationId + " error, exception = " + e);
        }
    }

    private static void executeRouterCommand(Configuration conf, String[] args) {
        Options opts = new Options();
        Option formatStateStoreOpt = new Option("format-state-store", false, " Formats the FederationStateStore. This will clear the FederationStateStore and is useful if past applications are no longer needed. This should be run only when the Router is not running.");
        Option removeApplicationFromStateStoreOpt = new Option("remove-application-from-state-store", false, " Remove the application from FederationStateStore.  This should be run only when the Router is not running. ");
        opts.addOption(formatStateStoreOpt);
        opts.addOption(removeApplicationFromStateStoreOpt);
        try {
            String cmd = args[0];
            CommandLine cliParser = new DefaultParser().parse(opts, args);
            if (CMD_FORMAT_STATE_STORE.equals(cmd)) {
                Router.handFormatStateStore(conf);
            } else if (CMD_REMOVE_APPLICATION_FROM_STATE_STORE.equals(cmd)) {
                if (cliParser.hasOption(removeApplicationFromStateStoreOpt)) {
                    String applicationId = cliParser.getOptionValue(removeApplicationFromStateStoreOpt);
                    Router.handRemoveApplicationFromStateStore(conf, applicationId);
                } else {
                    System.err.println("remove-application-from-state-store requires application arg.");
                }
            } else {
                System.out.println("No related commands found.");
                Router.printUsage(System.err);
            }
        }
        catch (MissingArgumentException ex) {
            System.out.println("Missing argument for options.");
            Router.printUsage(System.err);
        }
        catch (ParseException e) {
            System.out.println("Parsing of a command-line error.");
            Router.printUsage(System.err);
        }
    }

    private static void printUsage(PrintStream out) {
        out.println("Usage: yarn router [-format-state-store] | [-remove-application-from-state-store <appId>]");
    }

    static {
        clusterTimeStamp = System.currentTimeMillis();
    }
}

