/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.jsonschema2pojo.rules;

import org.apache.hadoop.shaded.com.sun.codemodel.JCodeModel;
import org.apache.hadoop.shaded.com.sun.codemodel.JPrimitiveType;
import org.apache.hadoop.shaded.com.sun.codemodel.JType;
import org.apache.hadoop.shaded.org.jsonschema2pojo.exception.GenerationException;

public final class PrimitiveTypes {
    private PrimitiveTypes() {
    }

    public static boolean isPrimitive(String name, JCodeModel owner) {
        try {
            return JType.parse(owner, name) != owner.VOID;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static JPrimitiveType primitiveType(String name, JCodeModel owner) {
        try {
            return (JPrimitiveType)owner.parseType(name);
        }
        catch (ClassNotFoundException e) {
            throw new GenerationException("Given name does not refer to a primitive type, this type can't be found: " + name, e);
        }
    }
}

