/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class RSAUtil {
    private static final byte[] RSAPSSParams_256_A;
    private static final byte[] RSAPSSParams_384_A;
    private static final byte[] RSAPSSParams_512_A;
    private static final byte[] RSAPSSParams_256_B;
    private static final byte[] RSAPSSParams_384_B;
    private static final byte[] RSAPSSParams_512_B;

    public static boolean supportsPKCS1(AlgorithmIdentifier algorithmIdentifier) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        return PKCSObjectIdentifiers.rsaEncryption.equals((ASN1Primitive)aSN1ObjectIdentifier) || X509ObjectIdentifiers.id_ea_rsa.equals((ASN1Primitive)aSN1ObjectIdentifier);
    }

    public static boolean supportsPSS_PSS(short s, AlgorithmIdentifier algorithmIdentifier) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        if (!PKCSObjectIdentifiers.id_RSASSA_PSS.equals((ASN1Primitive)aSN1ObjectIdentifier)) {
            return false;
        }
        ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
        if (null == aSN1Encodable || aSN1Encodable instanceof ASN1Null) {
            switch (s) {
                case 9: 
                case 10: 
                case 11: {
                    return true;
                }
            }
            return false;
        }
        try {
            byArray3 = aSN1Encodable.toASN1Primitive().getEncoded("DER");
        }
        catch (Exception exception) {
            return false;
        }
        switch (s) {
            case 9: {
                byArray2 = RSAPSSParams_256_A;
                byArray = RSAPSSParams_256_B;
                break;
            }
            case 10: {
                byArray2 = RSAPSSParams_384_A;
                byArray = RSAPSSParams_384_B;
                break;
            }
            case 11: {
                byArray2 = RSAPSSParams_512_A;
                byArray = RSAPSSParams_512_B;
                break;
            }
            default: {
                return false;
            }
        }
        return Arrays.areEqual((byte[])byArray2, (byte[])byArray3) || Arrays.areEqual((byte[])byArray, (byte[])byArray3);
    }

    public static boolean supportsPSS_RSAE(AlgorithmIdentifier algorithmIdentifier) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        return PKCSObjectIdentifiers.rsaEncryption.equals((ASN1Primitive)aSN1ObjectIdentifier);
    }

    static {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
        AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384);
        AlgorithmIdentifier algorithmIdentifier3 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512);
        AlgorithmIdentifier algorithmIdentifier4 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, (ASN1Encodable)DERNull.INSTANCE);
        AlgorithmIdentifier algorithmIdentifier5 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384, (ASN1Encodable)DERNull.INSTANCE);
        AlgorithmIdentifier algorithmIdentifier6 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512, (ASN1Encodable)DERNull.INSTANCE);
        AlgorithmIdentifier algorithmIdentifier7 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)algorithmIdentifier);
        AlgorithmIdentifier algorithmIdentifier8 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)algorithmIdentifier2);
        AlgorithmIdentifier algorithmIdentifier9 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)algorithmIdentifier3);
        AlgorithmIdentifier algorithmIdentifier10 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)algorithmIdentifier4);
        AlgorithmIdentifier algorithmIdentifier11 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)algorithmIdentifier5);
        AlgorithmIdentifier algorithmIdentifier12 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)algorithmIdentifier6);
        ASN1Integer aSN1Integer = new ASN1Integer((long)TlsCryptoUtils.getHashOutputSize(4));
        ASN1Integer aSN1Integer2 = new ASN1Integer((long)TlsCryptoUtils.getHashOutputSize(5));
        ASN1Integer aSN1Integer3 = new ASN1Integer((long)TlsCryptoUtils.getHashOutputSize(6));
        ASN1Integer aSN1Integer4 = RSASSAPSSparams.DEFAULT_TRAILER_FIELD;
        try {
            RSAPSSParams_256_A = new RSASSAPSSparams(algorithmIdentifier, algorithmIdentifier7, aSN1Integer, aSN1Integer4).getEncoded("DER");
            RSAPSSParams_384_A = new RSASSAPSSparams(algorithmIdentifier2, algorithmIdentifier8, aSN1Integer2, aSN1Integer4).getEncoded("DER");
            RSAPSSParams_512_A = new RSASSAPSSparams(algorithmIdentifier3, algorithmIdentifier9, aSN1Integer3, aSN1Integer4).getEncoded("DER");
            RSAPSSParams_256_B = new RSASSAPSSparams(algorithmIdentifier4, algorithmIdentifier10, aSN1Integer, aSN1Integer4).getEncoded("DER");
            RSAPSSParams_384_B = new RSASSAPSSparams(algorithmIdentifier5, algorithmIdentifier11, aSN1Integer2, aSN1Integer4).getEncoded("DER");
            RSAPSSParams_512_B = new RSASSAPSSparams(algorithmIdentifier6, algorithmIdentifier12, aSN1Integer3, aSN1Integer4).getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }
}

