/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.File;
import java.io.IOException;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.TestHttpServer;
import org.apache.hadoop.http.TestSSLHttpServer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHttpCookieFlag {
    private static final String BASEDIR = GenericTestUtils.getTempPath(TestHttpCookieFlag.class.getSimpleName());
    private static String keystoresDir;
    private static String sslConfDir;
    private static SSLFactory clientSslFactory;
    private static HttpServer2 server;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.filter.initializers", DummyFilterInitializer.class.getName());
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        keystoresDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestSSLHttpServer.class);
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, conf, false);
        Configuration sslConf = KeyStoreTestUtil.getSslConfig();
        clientSslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, sslConf);
        clientSslFactory.init();
        server = new HttpServer2.Builder().setName("test").addEndpoint(new URI("http://localhost")).addEndpoint(new URI("https://localhost")).setConf(conf).keyPassword(sslConf.get("ssl.server.keystore.keypassword")).keyStore(sslConf.get("ssl.server.keystore.location"), sslConf.get("ssl.server.keystore.password"), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), sslConf.get("ssl.server.truststore.password"), sslConf.get("ssl.server.truststore.type", "jks")).excludeCiphers(sslConf.get("ssl.server.exclude.cipher.list")).includeCiphers(sslConf.get("ssl.server.include.cipher.list")).build();
        server.addServlet("echo", "/echo", TestHttpServer.EchoServlet.class);
        server.start();
    }

    @Test
    public void testHttpCookie() throws IOException {
        URL base = new URL("http://" + NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0)));
        HttpURLConnection conn = (HttpURLConnection)new URL(base, "/echo").openConnection();
        String header = conn.getHeaderField("Set-Cookie");
        List<HttpCookie> cookies = HttpCookie.parse(header);
        Assert.assertTrue((!cookies.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)header.contains("; HttpOnly"));
        Assert.assertTrue((boolean)"token".equals(cookies.get(0).getValue()));
    }

    @Test
    public void testHttpsCookie() throws IOException, GeneralSecurityException {
        URL base = new URL("https://" + NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(1)));
        HttpsURLConnection conn = (HttpsURLConnection)new URL(base, "/echo").openConnection();
        conn.setSSLSocketFactory(clientSslFactory.createSSLSocketFactory());
        String header = conn.getHeaderField("Set-Cookie");
        List<HttpCookie> cookies = HttpCookie.parse(header);
        Assert.assertTrue((!cookies.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)header.contains("; HttpOnly"));
        Assert.assertTrue((boolean)cookies.get(0).getSecure());
        Assert.assertTrue((boolean)"token".equals(cookies.get(0).getValue()));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        server.stop();
        FileUtil.fullyDelete((File)new File(BASEDIR));
        KeyStoreTestUtil.cleanupSSLConfig(keystoresDir, sslConfDir);
        clientSslFactory.destroy();
    }

    public static class DummyFilterInitializer
    extends FilterInitializer {
        public void initFilter(FilterContainer container, Configuration conf) {
            container.addFilter("DummyAuth", DummyAuthenticationFilter.class.getName(), null);
        }
    }

    public static class DummyAuthenticationFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletResponse resp = (HttpServletResponse)response;
            boolean isHttps = "https".equals(request.getScheme());
            AuthenticationFilter.createAuthCookie((String)"hadoop.auth", (HttpServletResponse)resp, null, (String)"token", null, null, (long)-1L, (boolean)true, (boolean)isHttps, (long)-1L);
            chain.doFilter(request, (ServletResponse)resp);
        }

        public void destroy() {
        }
    }
}

