/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.executor;

import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class LocalizerStartContext {
    private final Path nmPrivateContainerTokens;
    private final Path extTokenPath;
    private final String extTokenEnvVar;
    private final InetSocketAddress nmAddr;
    private final String user;
    private final String appId;
    private final String locId;
    private final LocalDirsHandlerService dirsHandler;

    private LocalizerStartContext(Builder builder) {
        this.nmPrivateContainerTokens = builder.nmPrivateContainerTokens;
        this.extTokenPath = builder.extTokenPath;
        this.extTokenEnvVar = builder.extTokenEnvVar;
        this.nmAddr = builder.nmAddr;
        this.user = builder.user;
        this.appId = builder.appId;
        this.locId = builder.locId;
        this.dirsHandler = builder.dirsHandler;
    }

    public Path getNmPrivateContainerTokens() {
        return this.nmPrivateContainerTokens;
    }

    public Path getExtTokenPath() {
        return this.extTokenPath;
    }

    public String getExtTokenEnvVar() {
        return this.extTokenEnvVar;
    }

    public InetSocketAddress getNmAddr() {
        return this.nmAddr;
    }

    public String getUser() {
        return this.user;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getLocId() {
        return this.locId;
    }

    public LocalDirsHandlerService getDirsHandler() {
        return this.dirsHandler;
    }

    public static final class Builder {
        private Path nmPrivateContainerTokens;
        private InetSocketAddress nmAddr;
        private Path extTokenPath;
        private String extTokenEnvVar;
        private String user;
        private String appId;
        private String locId;
        private LocalDirsHandlerService dirsHandler;

        public Builder setNmPrivateContainerTokens(Path nmPrivateContainerTokens) {
            this.nmPrivateContainerTokens = nmPrivateContainerTokens;
            return this;
        }

        public Builder setExtTokenPath(Path extTokenPath) {
            this.extTokenPath = extTokenPath;
            return this;
        }

        public Builder setExtTokenEnvVar(String extTokenEnvVar) {
            this.extTokenEnvVar = extTokenEnvVar;
            return this;
        }

        public Builder setNmAddr(InetSocketAddress nmAddr) {
            this.nmAddr = nmAddr;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder setLocId(String locId) {
            this.locId = locId;
            return this;
        }

        public Builder setDirsHandler(LocalDirsHandlerService dirsHandler) {
            this.dirsHandler = dirsHandler;
            return this;
        }

        public LocalizerStartContext build() {
            return new LocalizerStartContext(this);
        }
    }
}

