/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.maprfs.AbstractMapRFileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.UsersACLsManager;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationDFSException;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerContext;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class LogAggregationFileController {
    private static final Logger LOG = LoggerFactory.getLogger(LogAggregationFileController.class);
    protected static final FsPermission TLDIR_PERMISSIONS = FsPermission.createImmutable((short)1023);
    protected static final FsPermission APP_DIR_PERMISSIONS = FsPermission.createImmutable((short)504);
    protected static final FsPermission APP_LOG_FILE_UMASK = FsPermission.createImmutable((short)95);
    protected Configuration conf;
    protected Path remoteRootLogDir;
    protected String remoteRootLogDirSuffix;
    protected String remoteOlderRootLogDirSuffix;
    protected int retentionSize;
    protected String fileControllerName;
    protected boolean fsSupportsChmod = true;
    protected UsersACLsManager usersAclsManager;
    protected int maxRetry;
    protected long retryTimeout;

    public void initialize(Configuration conf, String controllerName) {
        this.conf = conf;
        int configuredRetentionSize = conf.getInt("yarn.nodemanager.log-aggregation.num-log-files-per-app", 30);
        this.retentionSize = configuredRetentionSize <= 0 ? 30 : configuredRetentionSize;
        this.maxRetry = conf.getInt("yarn.nodemanager.log-aggregation.retry-directory-count", 3);
        this.retryTimeout = conf.getLong("yarn.nodemanager.log-aggregation.retry-directory-timeout", 2000L);
        this.fileControllerName = controllerName;
        this.usersAclsManager = new UsersACLsManager(conf);
        this.extractRemoteRootLogDir();
        this.extractRemoteRootLogDirSuffix();
        this.extractRemoteOlderRootLogDirSuffix();
        this.initInternal(conf);
    }

    protected abstract void initInternal(Configuration var1);

    public Path getRemoteRootLogDir() {
        return this.remoteRootLogDir;
    }

    public String getRemoteRootLogDirSuffix() {
        return this.remoteRootLogDirSuffix;
    }

    public String getRemoteOlderRootLogDirSuffix() {
        return this.remoteOlderRootLogDirSuffix;
    }

    public abstract void initializeWriter(LogAggregationFileControllerContext var1) throws IOException;

    public abstract void closeWriter() throws LogAggregationDFSException;

    public abstract void write(AggregatedLogFormat.LogKey var1, AggregatedLogFormat.LogValue var2) throws IOException;

    public abstract void postWrite(LogAggregationFileControllerContext var1) throws Exception;

    protected void closePrintStream(OutputStream out) {
        if (out != System.out) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{out});
        }
    }

    public abstract boolean readAggregatedLogs(ContainerLogsRequest var1, OutputStream var2) throws IOException;

    public abstract List<ContainerLogMeta> readAggregatedLogsMeta(ContainerLogsRequest var1) throws IOException;

    public abstract void renderAggregatedLogsBlock(HtmlBlock.Block var1, View.ViewContext var2);

    public abstract String getApplicationOwner(Path var1, ApplicationId var2) throws IOException;

    public abstract Map<ApplicationAccessType, String> getApplicationAcls(Path var1, ApplicationId var2) throws IOException;

    protected void extractRemoteRootLogDirSuffix() {
        String suffix = String.format("yarn.log-aggregation.%s.remote-app-log-dir-suffix", this.fileControllerName);
        this.remoteRootLogDirSuffix = this.conf.get(suffix);
        if (this.remoteRootLogDirSuffix == null || this.remoteRootLogDirSuffix.isEmpty()) {
            this.remoteRootLogDirSuffix = this.conf.get("yarn.nodemanager.remote-app-log-dir-suffix", "logs") + "-" + this.fileControllerName.toLowerCase();
        }
    }

    protected void extractRemoteOlderRootLogDirSuffix() {
        String suffix = String.format("yarn.log-aggregation.%s.remote-app-log-dir-suffix", this.fileControllerName);
        this.remoteOlderRootLogDirSuffix = this.conf.get(suffix);
        if (this.remoteOlderRootLogDirSuffix == null || this.remoteOlderRootLogDirSuffix.isEmpty()) {
            this.remoteOlderRootLogDirSuffix = this.conf.get("yarn.nodemanager.remote-app-log-dir-suffix", "logs");
        }
    }

    protected void extractRemoteRootLogDir() {
        String remoteDirStr = String.format("yarn.log-aggregation.%s.remote-app-log-dir", this.fileControllerName);
        String remoteDir = this.conf.get(remoteDirStr);
        if (remoteDir == null || remoteDir.isEmpty()) {
            remoteDir = this.conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs");
        }
        this.remoteRootLogDir = new Path(remoteDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verifyAndCreateRemoteLogDir() {
        FileSystem remoteFS = null;
        try {
            remoteFS = this.getFileSystem(this.conf);
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Unable to get Remote FileSystem instance", (Throwable)e);
        }
        boolean remoteExists = true;
        Path remoteRootLogDir = this.getRemoteRootLogDir();
        try {
            FsPermission perms = remoteFS.getFileStatus(remoteRootLogDir).getPermission();
            if (!perms.equals((Object)TLDIR_PERMISSIONS)) {
                LOG.warn("Remote Root Log Dir [" + remoteRootLogDir + "] already exist, but with incorrect permissions. Expected: [" + TLDIR_PERMISSIONS + "], Found: [" + perms + "]. The cluster may have problems with multiple users.");
            }
        }
        catch (FileNotFoundException e) {
            remoteExists = false;
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to check permissions for dir [" + remoteRootLogDir + "]", (Throwable)e);
        }
        Path qualified = remoteRootLogDir.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
        if (!remoteExists) {
            LOG.warn("Remote Root Log Dir [" + remoteRootLogDir + "] does not exist. Attempting to create it.");
            try {
                remoteFS.mkdirs(qualified, new FsPermission(TLDIR_PERMISSIONS));
                try {
                    remoteFS.setPermission(qualified, new FsPermission(TLDIR_PERMISSIONS));
                }
                catch (UnsupportedOperationException use) {
                    LOG.info("Unable to set permissions for configured filesystem {} since it does not support this", (Object)remoteFS.getScheme());
                    this.fsSupportsChmod = false;
                }
                UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
                String primaryGroupName = this.conf.get("yarn.nodemanager.remote-app-log-dir.groupname");
                if (primaryGroupName == null || primaryGroupName.isEmpty()) {
                    try {
                        primaryGroupName = loginUser.getPrimaryGroupName();
                    }
                    catch (IOException e) {
                        LOG.warn("No primary group found. The remote root log directory will be created with the HDFS superuser being its group owner. JobHistoryServer may be unable to read the directory.");
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("The group of remote root log directory has been determined by the configuration and set to " + primaryGroupName);
                }
                if (primaryGroupName == null) return;
                try {
                    remoteFS.setOwner(qualified, loginUser.getShortUserName(), primaryGroupName);
                    return;
                }
                catch (UnsupportedOperationException use) {
                    LOG.info("File System does not support setting user/group" + remoteFS.getScheme(), (Throwable)use);
                }
                return;
            }
            catch (IOException e) {
                throw new YarnRuntimeException("Failed to create remoteLogDir [" + remoteRootLogDir + "]", (Throwable)e);
            }
        }
        Path permissionCheckFile = new Path(qualified, String.format("%s.permission_check", RandomStringUtils.randomAlphanumeric((int)8)));
        try {
            remoteFS.createNewFile(permissionCheckFile);
            remoteFS.setPermission(permissionCheckFile, new FsPermission(TLDIR_PERMISSIONS));
            return;
        }
        catch (UnsupportedOperationException use) {
            LOG.info("Unable to set permissions for configured filesystem {} since it does not support this", (Object)remoteFS.getScheme());
            this.fsSupportsChmod = false;
            return;
        }
        catch (IOException e) {
            LOG.warn("Failed to check if FileSystem suppports permissions on remoteLogDir [" + remoteRootLogDir + "]", (Throwable)e);
            return;
        }
        finally {
            try {
                remoteFS.delete(permissionCheckFile, false);
            }
            catch (IOException use) {}
        }
    }

    public void createAppDir(final String user, final ApplicationId appId, UserGroupInformation userUgi) {
        final Path remoteRootLogDir = this.getRemoteRootLogDir();
        final String remoteRootLogDirSuffix = this.getRemoteRootLogDirSuffix();
        try {
            userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int retry = 0;
                    while (retry < LogAggregationFileController.this.maxRetry) {
                        try {
                            FileSystem remoteFS = LogAggregationFileController.this.getFileSystem(LogAggregationFileController.this.conf);
                            Path appDir = LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, appId, user, remoteRootLogDirSuffix);
                            Path curDir = appDir.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
                            Path rootLogDir = remoteRootLogDir.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
                            LinkedList<Path> pathsToCreate = new LinkedList<Path>();
                            while (!curDir.equals((Object)rootLogDir) && !LogAggregationFileController.this.checkExists(remoteFS, curDir, APP_DIR_PERMISSIONS)) {
                                pathsToCreate.addFirst(curDir);
                                curDir = curDir.getParent();
                            }
                            for (Path path : pathsToCreate) {
                                LogAggregationFileController.this.createDir(remoteFS, path, APP_DIR_PERMISSIONS);
                            }
                            break;
                        }
                        catch (IOException e) {
                            if (++retry >= LogAggregationFileController.this.maxRetry) {
                                LOG.error("Failed to setup application log directory for " + appId, (Throwable)e);
                                throw e;
                            }
                            LOG.warn("Can't create directories for aggregation logs. Sleep " + LogAggregationFileController.this.retryTimeout + "ms and try again. Number of try: " + retry);
                            Thread.sleep(LogAggregationFileController.this.retryTimeout);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                throw new YarnRuntimeException((Throwable)((RemoteException)e).unwrapRemoteException(new Class[]{SecretManager.InvalidToken.class}));
            }
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    @VisibleForTesting
    protected FileSystem getFileSystem(Configuration conf) throws IOException {
        return this.getRemoteRootLogDir().getFileSystem(conf);
    }

    protected void createDir(FileSystem fs, Path path, FsPermission fsPerm) throws IOException {
        if (this.fsSupportsChmod) {
            FsPermission umask;
            FsPermission dirPerm = new FsPermission(fsPerm);
            fs.mkdirs(path, dirPerm);
            if (this.usersAclsManager.isUsersACLEnable()) {
                AbstractMapRFileSystem mfs = (AbstractMapRFileSystem)fs;
                String ace = this.usersAclsManager.buildACEStrForUser(UserGroupInformation.getCurrentUser().getShortUserName());
                if (!ace.isEmpty()) {
                    mfs.setAces(path, ace, false, 0, 1, false);
                }
            }
            if (!dirPerm.equals((Object)dirPerm.applyUMask(umask = FsPermission.getUMask((Configuration)fs.getConf())))) {
                fs.setPermission(path, new FsPermission(fsPerm));
            }
        } else {
            fs.mkdirs(path);
        }
    }

    protected boolean checkExists(FileSystem fs, Path path, FsPermission fsPerm) throws IOException {
        boolean exists = true;
        try {
            FileStatus appDirStatus = fs.getFileStatus(path);
            if (this.fsSupportsChmod && !APP_DIR_PERMISSIONS.equals((Object)appDirStatus.getPermission())) {
                fs.setPermission(path, APP_DIR_PERMISSIONS);
            }
        }
        catch (FileNotFoundException fnfe) {
            exists = false;
        }
        return exists;
    }

    public Path getRemoteNodeLogFileForApp(ApplicationId appId, String user, NodeId nodeId) {
        return LogAggregationUtils.getRemoteNodeLogFileForApp(this.getRemoteRootLogDir(), appId, user, nodeId, this.getRemoteRootLogDirSuffix());
    }

    public Path getRemoteAppLogDir(ApplicationId appId, String appOwner) throws IOException {
        return LogAggregationUtils.getRemoteAppLogDir(this.conf, appId, appOwner, this.remoteRootLogDir, this.remoteRootLogDirSuffix);
    }

    public Path getOlderRemoteAppLogDir(ApplicationId appId, String appOwner) throws IOException {
        return LogAggregationUtils.getOlderRemoteAppLogDir(this.conf, appId, appOwner, this.remoteRootLogDir, this.remoteOlderRootLogDirSuffix);
    }

    protected void cleanOldLogs(Path remoteNodeLogFileForApp, NodeId nodeId, UserGroupInformation userUgi) {
        try {
            final FileSystem remoteFS = remoteNodeLogFileForApp.getFileSystem(this.conf);
            Path appDir = remoteNodeLogFileForApp.getParent().makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
            Set<Object> status = new HashSet<FileStatus>(Arrays.asList(remoteFS.listStatus(appDir)));
            status = status.stream().filter(next -> next.getPath().getName().contains(LogAggregationUtils.getNodeString(nodeId)) && !next.getPath().getName().endsWith(".tmp")).collect(Collectors.toSet());
            if (status.size() >= this.retentionSize) {
                ArrayList<Object> statusList = new ArrayList<Object>(status);
                Collections.sort(statusList, new Comparator<FileStatus>(){

                    @Override
                    public int compare(FileStatus s1, FileStatus s2) {
                        return s1.getModificationTime() < s2.getModificationTime() ? -1 : (s1.getModificationTime() > s2.getModificationTime() ? 1 : 0);
                    }
                });
                for (int i = 0; i <= statusList.size() - this.retentionSize; ++i) {
                    final FileStatus remove = (FileStatus)statusList.get(i);
                    try {
                        userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                remoteFS.delete(remove.getPath(), false);
                                return null;
                            }
                        });
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error("Failed to delete " + remove.getPath(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to clean old logs", (Throwable)e);
        }
    }

    protected String aggregatedLogSuffix(String fileName) {
        StringBuilder sb = new StringBuilder();
        String endOfFile = "End of LogType:" + fileName;
        sb.append("\n" + endOfFile + "\n").append(StringUtils.repeat((String)"*", (int)(endOfFile.length() + 50)) + "\n\n");
        return sb.toString();
    }

    public boolean isFsSupportsChmod() {
        return this.fsSupportsChmod;
    }

    protected boolean belongsToAppAttempt(ApplicationAttemptId appAttemptId, String containerIdStr) {
        ContainerId containerId = null;
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
        }
        catch (IllegalArgumentException exc) {
            LOG.warn("Could not parse container id from aggregated log.", (Throwable)exc);
        }
        if (containerId != null && containerId.getApplicationAttemptId() != null) {
            return containerId.getApplicationAttemptId().equals((Object)appAttemptId);
        }
        return false;
    }

    public String getFileControllerName() {
        return this.fileControllerName;
    }
}

