/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.PublicKey;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsDSSVerifier;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JcaTlsDSAVerifier
extends JcaTlsDSSVerifier {
    public JcaTlsDSAVerifier(JcaTlsCrypto crypto, PublicKey publicKey) {
        super(crypto, publicKey, (short)2, "NoneWithDSA");
    }

    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) throws IOException {
        SignatureAndHashAlgorithm algorithm = digitallySigned.getAlgorithm();
        if (null != algorithm && this.algorithmType == algorithm.getSignature() && HashAlgorithm.getOutputSize(algorithm.getHash()) != 20) {
            return this.crypto.createStreamVerifier(digitallySigned, this.publicKey);
        }
        return null;
    }
}

