/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ColumnPaginationFilter
extends FilterBase {
    private int limit = 0;
    private int offset = -1;
    private byte[] columnOffset = null;
    private int count = 0;

    public ColumnPaginationFilter(int limit, int offset) {
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (String)"limit must be positive %s", (int)limit);
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"offset must be positive %s", (int)offset);
        this.limit = limit;
        this.offset = offset;
    }

    public ColumnPaginationFilter(int limit, byte[] columnOffset) {
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (String)"limit must be positive %s", (int)limit);
        Preconditions.checkArgument((columnOffset != null ? 1 : 0) != 0, (String)"columnOffset must be non-null %s", (Object)columnOffset);
        this.limit = limit;
        this.columnOffset = columnOffset;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getColumnOffset() {
        return this.columnOffset;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) {
        if (this.columnOffset != null) {
            if (this.count >= this.limit) {
                return Filter.ReturnCode.NEXT_ROW;
            }
            byte[] buffer = v.getQualifierArray();
            if (buffer == null) {
                return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }
            int cmp = 0;
            if (this.count == 0) {
                cmp = Bytes.compareTo((byte[])buffer, (int)v.getQualifierOffset(), (int)v.getQualifierLength(), (byte[])this.columnOffset, (int)0, (int)this.columnOffset.length);
            }
            if (cmp < 0) {
                return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }
            ++this.count;
            return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
        }
        if (this.count >= this.offset + this.limit) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        Filter.ReturnCode code = this.count < this.offset ? Filter.ReturnCode.NEXT_COL : Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
        ++this.count;
        return code;
    }

    @Override
    public Cell transformCell(Cell v) {
        return v;
    }

    @Override
    public Cell getNextCellHint(Cell kv) {
        return KeyValueUtil.createFirstOnRow((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])kv.getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength(), (byte[])this.columnOffset, (int)0, (int)this.columnOffset.length);
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 but got: %s", (int)filterArguments.size());
        int limit = ParseFilter.convertByteArrayToInt(filterArguments.get(0));
        int offset = ParseFilter.convertByteArrayToInt(filterArguments.get(1));
        return new ColumnPaginationFilter(limit, offset);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.ColumnPaginationFilter.Builder builder = FilterProtos.ColumnPaginationFilter.newBuilder();
        builder.setLimit(this.limit);
        if (this.offset >= 0) {
            builder.setOffset(this.offset);
        }
        if (this.columnOffset != null) {
            builder.setColumnOffset(ByteStringer.wrap((byte[])this.columnOffset));
        }
        return builder.build().toByteArray();
    }

    public static ColumnPaginationFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.ColumnPaginationFilter proto;
        try {
            proto = FilterProtos.ColumnPaginationFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        if (proto.hasColumnOffset()) {
            return new ColumnPaginationFilter(proto.getLimit(), proto.getColumnOffset().toByteArray());
        }
        return new ColumnPaginationFilter(proto.getLimit(), proto.getOffset());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnPaginationFilter)) {
            return false;
        }
        ColumnPaginationFilter other = (ColumnPaginationFilter)o;
        if (this.columnOffset != null) {
            return this.getLimit() == other.getLimit() && Bytes.equals((byte[])this.getColumnOffset(), (byte[])other.getColumnOffset());
        }
        return this.getLimit() == other.getLimit() && this.getOffset() == other.getOffset();
    }

    @Override
    public String toString() {
        if (this.columnOffset != null) {
            return this.getClass().getSimpleName() + "(" + this.limit + ", " + Bytes.toStringBinary((byte[])this.columnOffset) + ")";
        }
        return String.format("%s (%d, %d)", this.getClass().getSimpleName(), this.limit, this.offset);
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return this.columnOffset == null ? Objects.hash(this.limit, this.offset) : Objects.hash(this.limit, Bytes.hashCode((byte[])this.columnOffset));
    }
}

