/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.mapr.AbstractMapRClusterConnection;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.client.mapr.GenericHFactory;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ConnectionFactory {
    private static final Log LOG = LogFactory.getLog(ConnectionFactory.class);
    public static final String DEFAULT_DB = "mapr.hbase.default.db";
    public static final String MAPR_ENGINE = "mapr";
    public static final String MAPR_ENGINE2 = "maprdb";
    public static final String HBASE_ENGINE = "hbase";
    private static final GenericHFactory<AbstractMapRClusterConnection> maprConnFactory_ = new GenericHFactory();

    protected ConnectionFactory() {
    }

    public static Connection createConnection() throws IOException {
        return ConnectionFactory.createConnection(HBaseConfiguration.create(), null, null);
    }

    public static Connection createConnection(Configuration conf) throws IOException {
        return ConnectionFactory.createConnection(conf, null, null);
    }

    public static Connection createConnection(Configuration conf, ExecutorService pool) throws IOException {
        return ConnectionFactory.createConnection(conf, pool, null);
    }

    public static Connection createConnection(Configuration conf, User user) throws IOException {
        return ConnectionFactory.createConnection(conf, null, user);
    }

    public static Connection createConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        if (user == null) {
            UserProvider provider = UserProvider.instantiate((Configuration)conf);
            user = provider.getCurrent();
        }
        return ConnectionFactory.createConnection(conf, false, pool, user);
    }

    static Connection createConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
        boolean connAtCtor = conf.getBoolean("hbase.admin.connect.at.construction", false);
        BaseTableMappingRules tableMappingRule = null;
        if (BaseTableMappingRules.isInHBaseService()) {
            tableMappingRule = BaseTableMappingRules.INSTANCE;
        } else {
            tableMappingRule = TableMappingRulesFactory.create(conf);
            String defaultDb = conf.get(DEFAULT_DB, "unsetDB");
            if (ConnectionFactory.isMapRDBOnlyCluster(conf)) {
                tableMappingRule.setClusterType(BaseTableMappingRules.ClusterType.MAPR_ONLY);
            } else if (defaultDb.equalsIgnoreCase(HBASE_ENGINE)) {
                tableMappingRule.setClusterType(BaseTableMappingRules.ClusterType.HBASE_ONLY);
            } else if (!tableMappingRule.isMapRClientInstalled()) {
                LOG.info((Object)("mapr.hbase.default.db " + defaultDb + " is neither MapRDB or HBase, set HBASE_ONLY mode since mapr client is not installed."));
                tableMappingRule.setClusterType(BaseTableMappingRules.ClusterType.HBASE_ONLY);
                connAtCtor = true;
            } else {
                LOG.info((Object)("mapr.hbase.default.db " + defaultDb + " is neither MapRDB or HBase, set HBASE_MAPR mode since mapr client is installed."));
                tableMappingRule.setClusterType(BaseTableMappingRules.ClusterType.HBASE_MAPR);
            }
            LOG.info((Object)("ConnectionFactory receives mapr.hbase.default.db(" + defaultDb + "), set clusterType(" + tableMappingRule.getClusterType() + "), user(" + user.getName() + "), hbase_admin_connect_at_construction(" + connAtCtor + ")"));
        }
        if (tableMappingRule.getClusterType() == BaseTableMappingRules.ClusterType.MAPR_ONLY) {
            LOG.debug((Object)"ConnectionFactory creates a maprdb connection!");
            conf.set("db.engine.default", MAPR_ENGINE);
            return maprConnFactory_.getImplementorInstance(conf.get("maprclusterconnection.impl.mapr", "com.mapr.fs.hbase.MapRClusterConnectionImpl"), new Object[]{conf, managed, user, tableMappingRule}, Configuration.class, Boolean.TYPE, User.class, BaseTableMappingRules.class);
        }
        LOG.debug((Object)"ConnectionFactory creates a hbase connection!");
        conf.setBoolean("hbase.admin.connect.at.construction", connAtCtor);
        conf.set("db.engine.default", HBASE_ENGINE);
        String className = conf.get("hbase.client.connection.impl", ConnectionManager.HConnectionImplementation.class.getName());
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(Configuration.class, Boolean.TYPE, ExecutorService.class, User.class);
            constructor.setAccessible(true);
            return (Connection)constructor.newInstance(conf, managed, pool, user);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static boolean isMapRDBOnlyCluster(Configuration conf) {
        String defaultDb = conf.get(DEFAULT_DB);
        return MAPR_ENGINE.equalsIgnoreCase(defaultDb) || MAPR_ENGINE2.equalsIgnoreCase(defaultDb);
    }
}

