/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.context;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import org.ojalgo.ProgrammingError;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.type.context.FormatContext;
import org.ojalgo.type.format.NumberStyle;

public final class NumberContext
extends FormatContext<Number> {
    private static final MathContext DEFAULT_MATH = MathContext.DECIMAL64;
    private static final int DEFAULT_SCALE = Integer.MIN_VALUE;
    private static final NumberStyle DEFAULT_STYLE = NumberStyle.GENERAL;
    private final double myEpsilon;
    private final MathContext myMathContext;
    private final double myRoundingFactor;
    private final int myScale;
    private final double myZeroError;

    public static NumberContext getCurrency(Locale locale) {
        NumberFormat tmpFormat = NumberStyle.CURRENCY.getFormat(locale);
        int tmpPrecision = DEFAULT_MATH.getPrecision();
        int tmpScale = 2;
        RoundingMode tmpRoundingMode = DEFAULT_MATH.getRoundingMode();
        return new NumberContext(tmpFormat, tmpPrecision, 2, tmpRoundingMode);
    }

    public static NumberContext getGeneral(int scale) {
        NumberFormat tmpFormat = NumberStyle.GENERAL.getFormat();
        int tmpPrecision = DEFAULT_MATH.getPrecision();
        int tmpScale = scale;
        RoundingMode tmpRoundingMode = DEFAULT_MATH.getRoundingMode();
        return new NumberContext(tmpFormat, tmpPrecision, tmpScale, tmpRoundingMode);
    }

    public static NumberContext getGeneral(int aPrecision, int scale) {
        NumberFormat tmpFormat = NumberStyle.GENERAL.getFormat();
        int tmpPrecision = aPrecision;
        int tmpScale = scale;
        RoundingMode tmpRoundingMode = DEFAULT_MATH.getRoundingMode();
        return new NumberContext(tmpFormat, tmpPrecision, tmpScale, tmpRoundingMode);
    }

    public static NumberContext getGeneral(int scale, RoundingMode roundingMode) {
        NumberFormat tmpFormat = NumberStyle.GENERAL.getFormat();
        int tmpPrecision = DEFAULT_MATH.getPrecision();
        int tmpScale = scale;
        RoundingMode tmpRoundingMode = roundingMode;
        return new NumberContext(tmpFormat, tmpPrecision, tmpScale, tmpRoundingMode);
    }

    public static NumberContext getGeneral(MathContext context) {
        NumberFormat tmpFormat = NumberStyle.GENERAL.getFormat();
        int tmpPrecision = context.getPrecision();
        int tmpScale = tmpPrecision / 2;
        RoundingMode tmpRoundingMode = context.getRoundingMode();
        return new NumberContext(tmpFormat, tmpPrecision, tmpScale, tmpRoundingMode);
    }

    public static NumberContext getInteger(Locale locale) {
        NumberFormat tmpFormat = NumberStyle.INTEGER.getFormat(locale);
        boolean tmpPrecision = false;
        boolean tmpScale = false;
        RoundingMode tmpRoundingMode = DEFAULT_MATH.getRoundingMode();
        return new NumberContext(tmpFormat, 0, 0, tmpRoundingMode);
    }

    public static NumberContext getMath(int precisionAndScale) {
        return NumberContext.getMath(precisionAndScale, DEFAULT_MATH.getRoundingMode());
    }

    public static NumberContext getMath(int precisionAndScale, RoundingMode roundingMode) {
        NumberFormat tmpFormat = NumberStyle.GENERAL.getFormat();
        int tmpPrecision = precisionAndScale;
        int tmpScale = precisionAndScale;
        RoundingMode tmpRoundingMode = roundingMode;
        return new NumberContext(tmpFormat, tmpPrecision, tmpScale, tmpRoundingMode);
    }

    public static NumberContext getMath(MathContext context) {
        NumberFormat tmpFormat = NumberStyle.GENERAL.getFormat();
        int tmpPrecision = context.getPrecision();
        int tmpScale = Integer.MIN_VALUE;
        RoundingMode tmpRoundingMode = context.getRoundingMode();
        return new NumberContext(tmpFormat, tmpPrecision, Integer.MIN_VALUE, tmpRoundingMode);
    }

    public static NumberContext getPercent(int scale, Locale locale) {
        NumberFormat tmpFormat = NumberStyle.PERCENT.getFormat(Locale.getDefault());
        int tmpPrecision = MathContext.DECIMAL32.getPrecision();
        int tmpScale = scale;
        RoundingMode tmpRoundingMode = MathContext.DECIMAL32.getRoundingMode();
        return new NumberContext(tmpFormat, tmpPrecision, tmpScale, tmpRoundingMode);
    }

    public static NumberContext getPercent(Locale locale) {
        return NumberContext.getPercent(4, locale);
    }

    public static Format toFormat(NumberStyle style, Locale locale) {
        return style != null ? style.getFormat(locale) : DEFAULT_STYLE.getFormat(locale);
    }

    private static boolean isZero(double value, double tolerance) {
        return PrimitiveFunction.ABS.invoke(value) <= tolerance;
    }

    public NumberContext() {
        this(DEFAULT_STYLE.getFormat(), DEFAULT_MATH.getPrecision(), Integer.MIN_VALUE, DEFAULT_MATH.getRoundingMode());
    }

    public NumberContext(Format format, int precision, int scale, RoundingMode mode) {
        super(format);
        this.myMathContext = new MathContext(precision, mode);
        this.myEpsilon = precision > 0 ? PrimitiveFunction.MAX.invoke(PrimitiveMath.MACHINE_EPSILON, PrimitiveFunction.POW.invoke(PrimitiveMath.TEN, 1 - precision)) : PrimitiveMath.MACHINE_EPSILON;
        this.myScale = scale;
        if (scale > Integer.MIN_VALUE) {
            this.myZeroError = PrimitiveFunction.MAX.invoke(Double.MIN_NORMAL, PrimitiveMath.HALF * PrimitiveFunction.POW.invoke(PrimitiveMath.TEN, -scale));
            this.myRoundingFactor = PrimitiveFunction.POWER.invoke(PrimitiveMath.TEN, scale);
        } else {
            this.myZeroError = Double.MIN_NORMAL;
            this.myRoundingFactor = PrimitiveMath.ONE;
        }
    }

    public NumberContext(int precision, int scale) {
        this(DEFAULT_STYLE.getFormat(), precision, scale, DEFAULT_MATH.getRoundingMode());
    }

    public NumberContext(int precision, int scale, RoundingMode mode) {
        this(DEFAULT_STYLE.getFormat(), precision, scale, mode);
    }

    public NumberContext(int scale, RoundingMode mode) {
        this(DEFAULT_STYLE.getFormat(), DEFAULT_MATH.getPrecision(), scale, mode);
    }

    public NumberContext(RoundingMode mode) {
        this(DEFAULT_STYLE.getFormat(), DEFAULT_MATH.getPrecision(), Integer.MIN_VALUE, mode);
    }

    private NumberContext(Format format) {
        this(format, DEFAULT_MATH.getPrecision(), Integer.MIN_VALUE, DEFAULT_MATH.getRoundingMode());
        ProgrammingError.throwForIllegalInvocation();
    }

    @Override
    public BigDecimal enforce(BigDecimal number) {
        BigDecimal tmpDecimal = number;
        if (this.myMathContext.getPrecision() > 0) {
            tmpDecimal = tmpDecimal.plus(this.getMathContext());
        }
        return this.scale(tmpDecimal);
    }

    @Override
    public double enforce(double number) {
        return PrimitiveFunction.RINT.invoke(this.myRoundingFactor * number) / this.myRoundingFactor;
    }

    @Override
    public Number enforce(Number object) {
        if (object instanceof BigDecimal) {
            return this.enforce((BigDecimal)object);
        }
        if (object instanceof Enforceable) {
            return ((Enforceable)((Object)object)).enforce(this);
        }
        return this.enforce(object.doubleValue());
    }

    public double epsilon() {
        return this.myEpsilon;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof NumberContext)) {
            return false;
        }
        NumberContext other = (NumberContext)obj;
        if (this.myMathContext == null ? other.myMathContext != null : !this.myMathContext.equals(other.myMathContext)) {
            return false;
        }
        return this.myScale == other.myScale;
    }

    public <N extends Number> UnaryFunction<N> getFunction(FunctionSet<N> functions) {
        return functions.enforce(this);
    }

    public MathContext getMathContext() {
        return this.myMathContext;
    }

    public int getPrecision() {
        return this.myMathContext.getPrecision();
    }

    public RoundingMode getRoundingMode() {
        return this.myMathContext.getRoundingMode();
    }

    public int getScale() {
        return this.myScale;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myMathContext == null ? 0 : this.myMathContext.hashCode());
        result = 31 * result + this.myScale;
        return result;
    }

    public boolean isDifferent(double expected, double actual) {
        return !this.isSmall(expected, actual - expected);
    }

    public boolean isSmall(double comparedTo, double value) {
        double tmpComparedTo = PrimitiveFunction.ABS.invoke(comparedTo);
        if (NumberContext.isZero(tmpComparedTo, this.myZeroError)) {
            return NumberContext.isZero(value, this.myZeroError);
        }
        return NumberContext.isZero(value / tmpComparedTo, this.myEpsilon);
    }

    public boolean isZero(double value) {
        return NumberContext.isZero(value, this.myZeroError);
    }

    public NumberContext newFormat(NumberStyle style, Locale locale) {
        return new NumberContext(style.getFormat(locale));
    }

    public NumberContext newMathContext(MathContext context) {
        return new NumberContext(this.getFormat(), context.getPrecision(), this.getScale(), context.getRoundingMode());
    }

    public NumberContext newPrecision(int precision) {
        return new NumberContext(this.getFormat(), precision, this.getScale(), this.getRoundingMode());
    }

    public NumberContext newRoundingMode(RoundingMode mode) {
        return new NumberContext(this.getFormat(), this.getPrecision(), this.getScale(), mode);
    }

    public NumberContext newScale(int scale) {
        return new NumberContext(this.getFormat(), this.getPrecision(), scale, this.getRoundingMode());
    }

    public BigDecimal toBigDecimal(double number) {
        BigDecimal tmpDecimal = this.myMathContext.getPrecision() > 0 ? new BigDecimal(number, this.myMathContext) : new BigDecimal(number);
        return this.scale(tmpDecimal);
    }

    public String toLocalizedPattern() {
        String retVal = null;
        if (this.getFormat() instanceof DecimalFormat) {
            retVal = ((DecimalFormat)this.getFormat()).toLocalizedPattern();
        } else if (this.getFormat() instanceof FormatPattern) {
            retVal = ((FormatPattern)((Object)this.getFormat())).toLocalizedPattern();
        }
        return retVal;
    }

    public String toPattern() {
        String retVal = null;
        if (this.getFormat() instanceof DecimalFormat) {
            retVal = ((DecimalFormat)this.getFormat()).toPattern();
        } else if (this.getFormat() instanceof FormatPattern) {
            retVal = ((FormatPattern)((Object)this.getFormat())).toPattern();
        }
        return retVal;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.myMathContext.getPrecision() + ":" + this.myScale + " " + this.myMathContext.getRoundingMode().toString();
    }

    private BigDecimal scale(BigDecimal number) {
        BigDecimal retVal = number;
        if (this.myScale > Integer.MIN_VALUE) {
            retVal = retVal.setScale(this.myScale, this.myMathContext.getRoundingMode());
        }
        if (retVal.signum() == 0) {
            return BigMath.ZERO;
        }
        return retVal;
    }

    @Override
    protected void configureFormat(Format format, Object object) {
        if (format instanceof DecimalFormat) {
            DecimalFormat tmpDF = (DecimalFormat)format;
            int tmpModScale = this.myScale - (int)PrimitiveFunction.LOG10.invoke(tmpDF.getMultiplier());
            tmpDF.setMaximumFractionDigits(tmpModScale);
            tmpDF.setMinimumFractionDigits(tmpModScale);
            if (object instanceof BigDecimal) {
                ((DecimalFormat)this.getFormat()).setParseBigDecimal(true);
            } else {
                ((DecimalFormat)this.getFormat()).setParseBigDecimal(false);
            }
        }
    }

    @Override
    protected String handleFormatException(Format format, Object object) {
        return "";
    }

    @Override
    protected Number handleParseException(Format format, String string) {
        return BigMath.ZERO;
    }

    public static interface FormatPattern {
        public String toLocalizedPattern();

        public String toPattern();
    }

    public static interface Enforceable<N extends Number> {
        public N enforce(NumberContext var1);
    }
}

