/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.security.http;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.security.http.RMAuthenticationFilter;

@InterfaceStability.Unstable
public class RMAuthenticationFilterInitializer
extends FilterInitializer {
    String configPrefix = "hadoop.http.authentication.";

    protected Map<String, String> createFilterConfig(Configuration conf) {
        Map filterConfig = AuthenticationFilterInitializer.getFilterConfigMap((Configuration)conf, (String)this.configPrefix);
        for (Map.Entry entry : conf.getPropsWithPrefix("hadoop.proxyuser").entrySet()) {
            filterConfig.put("proxyuser" + (String)entry.getKey(), (String)entry.getValue());
        }
        filterConfig.put("delegation-token.token-kind", RMDelegationTokenIdentifier.KIND_NAME.toString());
        return filterConfig;
    }

    public void initFilter(FilterContainer container, Configuration conf) {
        Map<String, String> filterConfig = this.createFilterConfig(conf);
        container.addFilter("RMAuthenticationFilter", RMAuthenticationFilter.class.getName(), filterConfig);
    }
}

