/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.thirdparty.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.util.RMVolumeShardingUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.conf.YarnDefaultProperties;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreUtils;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.Epoch;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMDelegationTokenIdentifierData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.AMRMTokenSecretManagerStatePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.EpochPBImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileSystemRMStateStore
extends RMStateStore {
    public static final Logger LOG = LoggerFactory.getLogger(FileSystemRMStateStore.class);
    protected static final String ROOT_DIR_NAME = "FSRMStateRoot";
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance(1, 3);
    protected static final String AMRMTOKEN_SECRET_MANAGER_NODE = "AMRMTokenSecretManagerNode";
    private static final String UNREADABLE_BY_SUPERUSER_XATTRIB = "security.hdfs.unreadable.by.superuser";
    protected FileSystem fs;
    @VisibleForTesting
    protected Configuration fsConf;
    private Path rootDirPath;
    @InterfaceAudience.Private
    @VisibleForTesting
    Path rmDTSecretManagerRoot;
    private Path rmAppRoot;
    private int volumeCount;
    private boolean useVolumeSharding;
    private Map<Integer, Path> rmAppRootToVolumeMap;
    private String rmDir;
    private Path dtSequenceNumberPath = null;
    private int fsNumRetries;
    private long fsRetryInterval;
    private boolean intermediateEncryptionEnabled = false;
    @VisibleForTesting
    Path fsWorkingPath;
    Path amrmTokenSecretManagerRoot;
    private Path reservationRoot;
    private Path proxyCARoot;

    @Override
    public synchronized void initInternal(Configuration conf) throws Exception {
        this.fsWorkingPath = new Path(conf.get("yarn.resourcemanager.fs.state-store.uri"));
        this.rootDirPath = new Path(this.fsWorkingPath, ROOT_DIR_NAME);
        this.rmDTSecretManagerRoot = new Path(this.rootDirPath, "RMDTSecretManagerRoot");
        this.rmAppRoot = new Path(this.rootDirPath, "RMAppRoot");
        this.rmDir = conf.get("yarn.resourcemanager.dir", YarnDefaultProperties.DEFAULT_RM_DIR);
        this.useVolumeSharding = conf.getBoolean("yarn.resourcemanager.dir.volume-sharding.enabled", false) && this.fsWorkingPath.toUri().getRawPath().startsWith(new Path(this.rmDir).toUri().getRawPath());
        this.volumeCount = conf.getInt("yarn.resourcemanager.dir.volume-count", 4);
        this.rmAppRootToVolumeMap = new HashMap<Integer, Path>();
        if (this.useVolumeSharding) {
            for (int volumeName = 0; volumeName < this.volumeCount; ++volumeName) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.rmDir).append("/").append(volumeName).append(this.rmAppRoot.toString().substring(this.rmDir.length()));
                this.rmAppRootToVolumeMap.put(volumeName, new Path(sb.toString()));
            }
            LOG.debug("Volume sharding is used for rmDir " + this.rmDir + " ; volumes count = " + this.volumeCount + " ; volumes: " + this.rmAppRootToVolumeMap);
        }
        this.amrmTokenSecretManagerRoot = new Path(this.rootDirPath, "AMRMTokenSecretManagerRoot");
        this.reservationRoot = new Path(this.rootDirPath, "ReservationSystemRoot");
        this.proxyCARoot = new Path(this.rootDirPath, "ProxyCARoot");
        this.fsNumRetries = conf.getInt("yarn.resourcemanager.fs.state-store.num-retries", 0);
        this.fsRetryInterval = conf.getLong("yarn.resourcemanager.fs.state-store.retry-interval-ms", 1000L);
        this.intermediateEncryptionEnabled = conf.getBoolean("yarn.intermediate-data-encryption.enable", false);
    }

    @Override
    protected synchronized void startInternal() throws Exception {
        this.fsConf = new Configuration(this.getConfig());
        String scheme = this.fsWorkingPath.toUri().getScheme();
        if (scheme == null) {
            scheme = FileSystem.getDefaultUri((Configuration)this.fsConf).getScheme();
        }
        if (scheme != null) {
            String disableCacheName = String.format("fs.%s.impl.disable.cache", scheme);
            this.fsConf.setBoolean(disableCacheName, true);
        }
        this.fs = this.fsWorkingPath.getFileSystem(this.fsConf);
        this.mkdirsWithRetries(this.rmDTSecretManagerRoot);
        this.mkdirsWithRetries(this.rmAppRoot);
        this.mkdirsWithRetries(this.amrmTokenSecretManagerRoot);
        this.mkdirsWithRetries(this.reservationRoot);
        this.mkdirsWithRetries(this.proxyCARoot);
        if (this.useVolumeSharding) {
            for (Path rmAppRootWithVolume : this.rmAppRootToVolumeMap.values()) {
                this.mkdirsWithRetries(rmAppRootWithVolume);
            }
        }
    }

    @Override
    protected synchronized void closeInternal() throws Exception {
        this.closeWithRetries();
    }

    @Override
    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    protected synchronized Version loadVersion() throws Exception {
        Path versionNodePath = this.getNodePath(this.rootDirPath, "RMVersionNode");
        FileStatus status = this.getFileStatusWithRetries(versionNodePath);
        if (status != null) {
            byte[] data = this.readFileWithRetries(versionNodePath, status.getLen());
            VersionPBImpl version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom(data));
            return version;
        }
        return null;
    }

    @Override
    protected synchronized void storeVersion() throws Exception {
        Path versionNodePath = this.getNodePath(this.rootDirPath, "RMVersionNode");
        byte[] data = ((VersionPBImpl)CURRENT_VERSION_INFO).getProto().toByteArray();
        if (this.existsWithRetries(versionNodePath)) {
            this.updateFile(versionNodePath, data, false);
        } else {
            this.writeFileWithRetries(versionNodePath, data, false);
        }
    }

    @Override
    public synchronized long getAndIncrementEpoch() throws Exception {
        Path epochNodePath = this.getNodePath(this.rootDirPath, "EpochNode");
        long currentEpoch = this.baseEpoch;
        FileStatus status = this.getFileStatusWithRetries(epochNodePath);
        if (status != null) {
            byte[] data = this.readFileWithRetries(epochNodePath, status.getLen());
            EpochPBImpl epoch = new EpochPBImpl(YarnServerResourceManagerRecoveryProtos.EpochProto.parseFrom(data));
            currentEpoch = ((Epoch)epoch).getEpoch();
            byte[] storeData = Epoch.newInstance(this.nextEpoch(currentEpoch)).getProto().toByteArray();
            this.updateFile(epochNodePath, storeData, false);
        } else {
            byte[] storeData = Epoch.newInstance(this.nextEpoch(currentEpoch)).getProto().toByteArray();
            this.writeFileWithRetries(epochNodePath, storeData, false);
        }
        return currentEpoch;
    }

    @Override
    public synchronized RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState rmState = new RMStateStore.RMState();
        this.loadRMDTSecretManagerState(rmState);
        RMVolumeShardingUtil.rebalanceVolumes((String)this.rmAppRoot.toString(), (int)this.volumeCount, (boolean)this.useVolumeSharding, (String)this.rmDir, (FileSystem)this.fs);
        this.loadRMAppState(rmState);
        this.loadAMRMTokenSecretManagerState(rmState);
        this.loadReservationSystemState(rmState);
        this.loadProxyCAManagerState(rmState);
        return rmState;
    }

    private void loadReservationSystemState(RMStateStore.RMState rmState) throws Exception {
        try {
            ReservationStateFileProcessor fileProcessor = new ReservationStateFileProcessor(rmState);
            Path rootDirectory = this.reservationRoot;
            this.processDirectoriesOfFiles(fileProcessor, rootDirectory, false);
        }
        catch (Exception e) {
            LOG.error("Failed to load state.", (Throwable)e);
            throw e;
        }
    }

    private void loadAMRMTokenSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        this.checkAndResumeUpdateOperation(this.amrmTokenSecretManagerRoot);
        Path amrmTokenSecretManagerStateDataDir = new Path(this.amrmTokenSecretManagerRoot, AMRMTOKEN_SECRET_MANAGER_NODE);
        FileStatus status = this.getFileStatusWithRetries(amrmTokenSecretManagerStateDataDir);
        if (status == null) {
            return;
        }
        assert (status.isFile());
        byte[] data = this.readFileWithRetries(amrmTokenSecretManagerStateDataDir, status.getLen());
        AMRMTokenSecretManagerStatePBImpl stateData = new AMRMTokenSecretManagerStatePBImpl(YarnServerResourceManagerRecoveryProtos.AMRMTokenSecretManagerStateProto.parseFrom(data));
        rmState.amrmTokenSecretManagerState = AMRMTokenSecretManagerState.newInstance(stateData.getCurrentMasterKey(), stateData.getNextMasterKey());
    }

    private void loadRMAppState(RMStateStore.RMState rmState) throws Exception {
        try {
            ArrayList<ApplicationAttemptStateData> attempts = new ArrayList<ApplicationAttemptStateData>();
            RMAppStateFileProcessor rmAppStateFileProcessor = new RMAppStateFileProcessor(rmState, attempts);
            Path rootDirectory = this.rmAppRoot;
            this.processDirectoriesOfFiles(rmAppStateFileProcessor, rootDirectory, true);
            for (ApplicationAttemptStateData attemptState : attempts) {
                ApplicationId appId = attemptState.getAttemptId().getApplicationId();
                ApplicationStateData appState = rmState.appState.get(appId);
                assert (appState != null);
                if (appState == null) {
                    LOG.warn("Removing " + appId + " directory as info there is incomplete and can cause RM restart failure after failover.");
                    int rmVolumeName = Math.abs(appId.toString().hashCode() % this.volumeCount);
                    Path appDirPath = this.useVolumeSharding ? this.getAppDir(this.rmAppRootToVolumeMap.get(rmVolumeName), appId) : this.getAppDir(this.rmAppRoot, appId);
                    this.checkAndRemovePathWithRetries(appDirPath);
                    rmState.appState.remove(appId);
                    continue;
                }
                appState.attempts.put(attemptState.getAttemptId(), attemptState);
            }
            LOG.info("Done loading applications from FS state store");
        }
        catch (Exception e) {
            LOG.error("Failed to load state.", (Throwable)e);
            throw e;
        }
    }

    private void processDirectoriesOfFiles(RMStateFileProcessor rmAppStateFileProcessor, Path rootDirectory, boolean isRMApp) throws Exception {
        ArrayList<FileStatus> appStateList = new ArrayList<FileStatus>();
        if (this.useVolumeSharding && isRMApp) {
            for (Path rmAppRootWithVolume : this.rmAppRootToVolumeMap.values()) {
                appStateList.addAll(Arrays.asList(this.listStatusWithRetries(rmAppRootWithVolume)));
            }
        } else {
            appStateList.addAll(Arrays.asList(this.listStatusWithRetries(rootDirectory)));
        }
        for (FileStatus dir : appStateList) {
            this.checkAndResumeUpdateOperation(dir.getPath());
            String dirName = dir.getPath().getName();
            for (FileStatus fileNodeStatus : this.listStatusWithRetries(dir.getPath())) {
                assert (fileNodeStatus.isFile());
                String fileName = fileNodeStatus.getPath().getName();
                if (this.checkAndRemovePartialRecordWithRetries(fileNodeStatus.getPath())) continue;
                byte[] fileData = this.readFileWithRetries(fileNodeStatus.getPath(), fileNodeStatus.getLen());
                this.setUnreadableBySuperuserXattrib(fileNodeStatus.getPath());
                rmAppStateFileProcessor.processChildNode(dirName, fileName, fileData);
            }
        }
    }

    private boolean checkAndRemovePartialRecord(Path record) throws IOException {
        if (record.getName().endsWith(".tmp")) {
            LOG.error("incomplete rm state store entry found :" + record);
            this.fs.delete(record, false);
            return true;
        }
        return false;
    }

    private void checkAndResumeUpdateOperation(Path path) throws Exception {
        FileStatus[] newChildNodes;
        for (FileStatus newChildNodeStatus : newChildNodes = this.listStatusWithRetries(path, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().endsWith(".new");
            }
        })) {
            assert (newChildNodeStatus.isFile());
            String newChildNodeName = newChildNodeStatus.getPath().getName();
            String childNodeName = newChildNodeName.substring(0, newChildNodeName.length() - ".new".length());
            Path childNodePath = new Path(newChildNodeStatus.getPath().getParent(), childNodeName);
            this.replaceFile(newChildNodeStatus.getPath(), childNodePath);
        }
    }

    private void loadRMDTSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        FileStatus[] childNodes;
        this.checkAndResumeUpdateOperation(this.rmDTSecretManagerRoot);
        for (FileStatus childNodeStatus : childNodes = this.listStatusWithRetries(this.rmDTSecretManagerRoot)) {
            assert (childNodeStatus.isFile());
            String childNodeName = childNodeStatus.getPath().getName();
            if (this.checkAndRemovePartialRecordWithRetries(childNodeStatus.getPath())) continue;
            if (childNodeName.startsWith("RMDTSequenceNumber_")) {
                rmState.rmSecretManagerState.dtSequenceNumber = Integer.parseInt(childNodeName.split("_")[1]);
                continue;
            }
            Path childNodePath = this.getNodePath(this.rmDTSecretManagerRoot, childNodeName);
            byte[] childData = this.readFileWithRetries(childNodePath, childNodeStatus.getLen());
            ByteArrayInputStream is = new ByteArrayInputStream(childData);
            try (DataInputStream fsIn = new DataInputStream(is);){
                if (childNodeName.startsWith("DelegationKey_")) {
                    DelegationKey key = new DelegationKey();
                    key.readFields((DataInput)fsIn);
                    rmState.rmSecretManagerState.masterKeyState.add(key);
                    LOG.debug("Loaded delegation key: keyId={}, expirationDate={}", (Object)key.getKeyId(), (Object)key.getExpiryDate());
                    continue;
                }
                if (childNodeName.startsWith("RMDelegationToken_")) {
                    RMDelegationTokenIdentifierData identifierData = RMStateStoreUtils.readRMDelegationTokenIdentifierData(fsIn);
                    RMDelegationTokenIdentifier identifier = identifierData.getTokenIdentifier();
                    long renewDate = identifierData.getRenewDate();
                    rmState.rmSecretManagerState.delegationTokenState.put(identifier, renewDate);
                    LOG.debug("Loaded RMDelegationTokenIdentifier: {} renewDate={}", (Object)identifier, (Object)renewDate);
                    continue;
                }
                LOG.warn("Unknown file for recovering RMDelegationTokenSecretManager");
            }
        }
    }

    private void loadProxyCAManagerState(RMStateStore.RMState rmState) throws Exception {
        this.checkAndResumeUpdateOperation(this.proxyCARoot);
        Path caCertPath = this.getNodePath(this.proxyCARoot, "caCert");
        Path caPrivateKeyPath = this.getNodePath(this.proxyCARoot, "caPrivateKey");
        if (!this.existsWithRetries(caCertPath) || !this.existsWithRetries(caPrivateKeyPath)) {
            LOG.warn("Couldn't find Proxy CA data");
            return;
        }
        FileStatus caCertFileStatus = this.getFileStatus(caCertPath);
        byte[] caCertData = this.readFileWithRetries(caCertPath, caCertFileStatus.getLen());
        FileStatus caPrivateKeyFileStatus = this.getFileStatus(caPrivateKeyPath);
        byte[] caPrivateKeyData = this.readFileWithRetries(caPrivateKeyPath, caPrivateKeyFileStatus.getLen());
        rmState.getProxyCAState().setCaCert(caCertData);
        rmState.getProxyCAState().setCaPrivateKey(caPrivateKeyData);
    }

    @Override
    public synchronized void storeApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        int rmVolumeName = Math.abs(appId.toString().hashCode() % this.volumeCount);
        Path appDirPath = this.useVolumeSharding ? this.getAppDir(this.rmAppRootToVolumeMap.get(rmVolumeName), appId) : this.getAppDir(this.rmAppRoot, appId);
        this.mkdirsWithRetries(appDirPath);
        Path nodeCreatePath = this.getNodePath(appDirPath, appId.toString());
        LOG.info("Storing info for app: " + appId + " at: " + nodeCreatePath);
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        try {
            this.writeFileWithRetries(nodeCreatePath, appStateData, true);
        }
        catch (Exception e) {
            LOG.info("Error storing info for app: " + appId, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        int rmVolumeName = Math.abs(appId.toString().hashCode() % this.volumeCount);
        Path appDirPath = this.useVolumeSharding ? this.getAppDir(this.rmAppRootToVolumeMap.get(rmVolumeName), appId) : this.getAppDir(this.rmAppRoot, appId);
        Path nodeCreatePath = this.getNodePath(appDirPath, appId.toString());
        LOG.info("Updating info for app: " + appId + " at: " + nodeCreatePath);
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        try {
            this.updateFile(nodeCreatePath, appStateData, true);
        }
        catch (Exception e) {
            LOG.info("Error updating info for app: " + appId, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void storeApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        ApplicationId appId = appAttemptId.getApplicationId();
        int rmVolumeName = Math.abs(appId.toString().hashCode() % this.volumeCount);
        Path appDirPath = this.useVolumeSharding ? this.getAppDir(this.rmAppRootToVolumeMap.get(rmVolumeName), appId) : this.getAppDir(this.rmAppRoot, appId);
        Path nodeCreatePath = this.getNodePath(appDirPath, appAttemptId.toString());
        LOG.info("Storing info for attempt: " + appAttemptId + " at: " + nodeCreatePath);
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        try {
            this.writeFileWithRetries(nodeCreatePath, attemptStateData, true);
        }
        catch (Exception e) {
            LOG.info("Error storing info for attempt: " + appAttemptId, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        ApplicationId appId = appAttemptId.getApplicationId();
        int rmVolumeName = Math.abs(appId.toString().hashCode() % this.volumeCount);
        Path appDirPath = this.useVolumeSharding ? this.getAppDir(this.rmAppRootToVolumeMap.get(rmVolumeName), appId) : this.getAppDir(this.rmAppRoot, appId);
        Path nodeCreatePath = this.getNodePath(appDirPath, appAttemptId.toString());
        LOG.info("Updating info for attempt: " + appAttemptId + " at: " + nodeCreatePath);
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        try {
            this.updateFile(nodeCreatePath, attemptStateData, true);
        }
        catch (Exception e) {
            LOG.info("Error updating info for attempt: " + appAttemptId, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void removeApplicationAttemptInternal(ApplicationAttemptId appAttemptId) throws Exception {
        ApplicationId appId = appAttemptId.getApplicationId();
        int rmVolumeName = Math.abs(appId.toString().hashCode() % this.volumeCount);
        Path appDirPath = this.useVolumeSharding ? this.getAppDir(this.rmAppRootToVolumeMap.get(rmVolumeName), appId) : this.getAppDir(this.rmAppRoot, appId);
        Path nodeRemovePath = this.getNodePath(appDirPath, appAttemptId.toString());
        LOG.info("Removing info for attempt: " + appAttemptId + " at: " + nodeRemovePath);
        this.deleteFileWithRetries(nodeRemovePath);
    }

    @Override
    public synchronized void removeApplicationStateInternal(ApplicationStateData appState) throws Exception {
        ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
        int rmVolumeName = Math.abs(appId.toString().hashCode() % this.volumeCount);
        Path nodeRemovePath = this.useVolumeSharding ? this.getAppDir(this.rmAppRootToVolumeMap.get(rmVolumeName), appId) : this.getAppDir(this.rmAppRoot, appId);
        LOG.info("Removing info for app: " + appId + " at: " + nodeRemovePath);
        this.deleteFileWithRetries(nodeRemovePath);
    }

    @Override
    public synchronized void storeRMDelegationTokenState(RMDelegationTokenIdentifier identifier, Long renewDate) throws Exception {
        this.storeOrUpdateRMDelegationTokenState(identifier, renewDate, false);
    }

    @Override
    public synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier identifier) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "RMDelegationToken_" + identifier.getSequenceNumber());
        LOG.info("Removing RMDelegationToken_" + identifier.getSequenceNumber());
        this.deleteFileWithRetries(nodeCreatePath);
    }

    @Override
    protected synchronized void updateRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) throws Exception {
        this.storeOrUpdateRMDelegationTokenState(rmDTIdentifier, renewDate, true);
    }

    private void storeOrUpdateRMDelegationTokenState(RMDelegationTokenIdentifier identifier, Long renewDate, boolean isUpdate) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "RMDelegationToken_" + identifier.getSequenceNumber());
        RMDelegationTokenIdentifierData identifierData = new RMDelegationTokenIdentifierData((YARNDelegationTokenIdentifier)identifier, renewDate);
        if (isUpdate) {
            LOG.info("Updating RMDelegationToken_" + identifier.getSequenceNumber());
            this.updateFile(nodeCreatePath, identifierData.toByteArray(), true);
        } else {
            LOG.info("Storing RMDelegationToken_" + identifier.getSequenceNumber());
            this.writeFileWithRetries(nodeCreatePath, identifierData.toByteArray(), true);
            Path latestSequenceNumberPath = this.getNodePath(this.rmDTSecretManagerRoot, "RMDTSequenceNumber_" + identifier.getSequenceNumber());
            LOG.info("Storing RMDTSequenceNumber_" + identifier.getSequenceNumber());
            if (this.dtSequenceNumberPath == null) {
                if (!this.createFileWithRetries(latestSequenceNumberPath)) {
                    throw new Exception("Failed to create " + latestSequenceNumberPath);
                }
            } else if (!this.renameFileWithRetries(this.dtSequenceNumberPath, latestSequenceNumberPath)) {
                throw new Exception("Failed to rename " + this.dtSequenceNumberPath);
            }
            this.dtSequenceNumberPath = latestSequenceNumberPath;
        }
    }

    @Override
    public synchronized void storeRMDTMasterKeyState(DelegationKey masterKey) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "DelegationKey_" + masterKey.getKeyId());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (DataOutputStream fsOut = new DataOutputStream(os);){
            LOG.info("Storing RMDelegationKey_" + masterKey.getKeyId());
            masterKey.write((DataOutput)fsOut);
            this.writeFileWithRetries(nodeCreatePath, os.toByteArray(), true);
        }
    }

    @Override
    public synchronized void removeRMDTMasterKeyState(DelegationKey masterKey) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "DelegationKey_" + masterKey.getKeyId());
        LOG.info("Removing RMDelegationKey_" + masterKey.getKeyId());
        this.deleteFileWithRetries(nodeCreatePath);
    }

    @Override
    public synchronized void deleteStore() throws Exception {
        if (this.existsWithRetries(this.rootDirPath)) {
            this.deleteFileWithRetries(this.rootDirPath);
        }
    }

    @Override
    public synchronized void removeApplication(ApplicationId removeAppId) throws Exception {
        Path nodeRemovePath;
        int rmVolumeName = Math.abs(removeAppId.toString().hashCode() % this.volumeCount);
        Path path = nodeRemovePath = this.useVolumeSharding ? this.getAppDir(this.rmAppRootToVolumeMap.get(rmVolumeName), removeAppId) : this.getAppDir(this.rmAppRoot, removeAppId);
        if (this.existsWithRetries(nodeRemovePath)) {
            this.deleteFileWithRetries(nodeRemovePath);
        }
    }

    @Override
    protected synchronized void storeProxyCACertState(X509Certificate caCert, PrivateKey caPrivateKey) throws Exception {
        byte[] caCertData = caCert.getEncoded();
        byte[] caPrivateKeyData = caPrivateKey.getEncoded();
        Path caCertPath = this.getNodePath(this.proxyCARoot, "caCert");
        Path caPrivateKeyPath = this.getNodePath(this.proxyCARoot, "caPrivateKey");
        if (this.existsWithRetries(caCertPath)) {
            this.updateFile(caCertPath, caCertData, true);
        } else {
            this.writeFileWithRetries(caCertPath, caCertData, true);
        }
        if (this.existsWithRetries(caPrivateKeyPath)) {
            this.updateFile(caPrivateKeyPath, caPrivateKeyData, true);
        } else {
            this.writeFileWithRetries(caPrivateKeyPath, caPrivateKeyData, true);
        }
    }

    private Path getAppDir(Path root, ApplicationId appId) {
        return this.getNodePath(root, appId.toString());
    }

    @VisibleForTesting
    protected Path getAppDir(ApplicationId appId) {
        return this.getAppDir(this.rmAppRoot, appId);
    }

    @VisibleForTesting
    protected Path getAppAttemptDir(ApplicationAttemptId appAttId) {
        return this.getNodePath(this.getAppDir(appAttId.getApplicationId()), appAttId.toString());
    }

    private void checkAndRemovePathWithRetries(Path deletePath) throws Exception {
        if (!this.existsWithRetries(deletePath) || !this.deleteFileWithRetries(deletePath)) {
            LOG.info("File doesn't exist. Skip deleting the file " + deletePath);
        }
    }

    private boolean checkAndRemovePartialRecordWithRetries(final Path record) throws Exception {
        return (Boolean)new FSAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return FileSystemRMStateStore.this.checkAndRemovePartialRecord(record);
            }
        }.runWithRetries();
    }

    private void mkdirsWithRetries(final Path appDirPath) throws Exception {
        new FSAction<Void>(){

            @Override
            public Void run() throws Exception {
                FileSystemRMStateStore.this.fs.mkdirs(appDirPath);
                return null;
            }
        }.runWithRetries();
    }

    private void writeFileWithRetries(final Path outputPath, final byte[] data, final boolean makeUnreadableByAdmin) throws Exception {
        new FSAction<Void>(){

            @Override
            public Void run() throws Exception {
                FileSystemRMStateStore.this.writeFile(outputPath, data, makeUnreadableByAdmin);
                return null;
            }
        }.runWithRetries();
    }

    private boolean deleteFileWithRetries(final Path deletePath) throws Exception {
        return (Boolean)new FSAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return FileSystemRMStateStore.this.deleteFile(deletePath);
            }
        }.runWithRetries();
    }

    private boolean renameFileWithRetries(final Path src, final Path dst) throws Exception {
        return (Boolean)new FSAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return FileSystemRMStateStore.this.renameFile(src, dst);
            }
        }.runWithRetries();
    }

    private boolean createFileWithRetries(final Path newFile) throws Exception {
        return (Boolean)new FSAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return FileSystemRMStateStore.this.createFile(newFile);
            }
        }.runWithRetries();
    }

    private FileStatus getFileStatusWithRetries(final Path path) throws Exception {
        return (FileStatus)new FSAction<FileStatus>(){

            @Override
            public FileStatus run() throws Exception {
                return FileSystemRMStateStore.this.getFileStatus(path);
            }
        }.runWithRetries();
    }

    private boolean existsWithRetries(final Path path) throws Exception {
        return (Boolean)new FSAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                return FileSystemRMStateStore.this.fs.exists(path);
            }
        }.runWithRetries();
    }

    private byte[] readFileWithRetries(final Path inputPath, final long len) throws Exception {
        return (byte[])new FSAction<byte[]>(){

            @Override
            public byte[] run() throws Exception {
                return FileSystemRMStateStore.this.readFile(inputPath, len);
            }
        }.runWithRetries();
    }

    private FileStatus[] listStatusWithRetries(final Path path) throws Exception {
        return (FileStatus[])new FSAction<FileStatus[]>(){

            @Override
            public FileStatus[] run() throws Exception {
                return FileSystemRMStateStore.this.fs.listStatus(path);
            }
        }.runWithRetries();
    }

    private FileStatus[] listStatusWithRetries(final Path path, final PathFilter filter) throws Exception {
        return (FileStatus[])new FSAction<FileStatus[]>(){

            @Override
            public FileStatus[] run() throws Exception {
                return FileSystemRMStateStore.this.fs.listStatus(path, filter);
            }
        }.runWithRetries();
    }

    private void closeWithRetries() throws Exception {
        new FSAction<Void>(){

            @Override
            public Void run() throws Exception {
                IOUtils.closeStream((Closeable)FileSystemRMStateStore.this.fs);
                return null;
            }
        }.runWithRetries();
    }

    private Boolean deleteFile(Path deletePath) throws Exception {
        return this.fs.delete(deletePath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(Path inputPath, long len) throws Exception {
        byte[] byArray;
        FSDataInputStream fsIn = null;
        try {
            fsIn = this.fs.open(inputPath);
            byte[] data = new byte[(int)len];
            fsIn.readFully(data);
            byArray = data;
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsIn});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsIn});
        return byArray;
    }

    private FileStatus getFileStatus(Path path) throws Exception {
        try {
            return this.fs.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(Path outputPath, byte[] data, boolean makeUnreadableByAdmin) throws Exception {
        Path tempPath = new Path(outputPath.getParent(), outputPath.getName() + ".tmp");
        FSDataOutputStream fsOut = null;
        try {
            fsOut = this.fs.create(tempPath, true);
            if (makeUnreadableByAdmin) {
                this.setUnreadableBySuperuserXattrib(tempPath);
            }
            fsOut.write(data);
            fsOut.close();
            fsOut = null;
            this.fs.rename(tempPath, outputPath);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsOut});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsOut});
    }

    protected void updateFile(Path outputPath, byte[] data, boolean makeUnreadableByAdmin) throws Exception {
        Path newPath = new Path(outputPath.getParent(), outputPath.getName() + ".new");
        this.writeFileWithRetries(newPath, data, makeUnreadableByAdmin);
        this.replaceFile(newPath, outputPath);
    }

    protected void replaceFile(Path srcPath, Path dstPath) throws Exception {
        if (this.existsWithRetries(dstPath)) {
            this.deleteFileWithRetries(dstPath);
        } else {
            LOG.info("File doesn't exist. Skip deleting the file " + dstPath);
        }
        this.renameFileWithRetries(srcPath, dstPath);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    boolean renameFile(Path src, Path dst) throws Exception {
        return this.fs.rename(src, dst);
    }

    private boolean createFile(Path newFile) throws Exception {
        return this.fs.createNewFile(newFile);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    Path getNodePath(Path root, String nodeName) {
        return new Path(root, nodeName);
    }

    @Override
    public synchronized void storeOrUpdateAMRMTokenSecretManagerState(AMRMTokenSecretManagerState amrmTokenSecretManagerState, boolean isUpdate) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.amrmTokenSecretManagerRoot, AMRMTOKEN_SECRET_MANAGER_NODE);
        AMRMTokenSecretManagerState data = AMRMTokenSecretManagerState.newInstance(amrmTokenSecretManagerState);
        byte[] stateData = data.getProto().toByteArray();
        if (isUpdate) {
            this.updateFile(nodeCreatePath, stateData, true);
        } else {
            this.writeFileWithRetries(nodeCreatePath, stateData, true);
        }
    }

    @Override
    protected void storeReservationState(YarnProtos.ReservationAllocationStateProto reservationAllocation, String planName, String reservationIdName) throws Exception {
        Path planCreatePath = this.getNodePath(this.reservationRoot, planName);
        this.mkdirsWithRetries(planCreatePath);
        Path reservationPath = this.getNodePath(planCreatePath, reservationIdName);
        LOG.info("Storing state for reservation " + reservationIdName + " from plan " + planName + " at path " + reservationPath);
        byte[] reservationData = reservationAllocation.toByteArray();
        this.writeFileWithRetries(reservationPath, reservationData, true);
    }

    @Override
    protected void removeReservationState(String planName, String reservationIdName) throws Exception {
        Path planCreatePath = this.getNodePath(this.reservationRoot, planName);
        Path reservationPath = this.getNodePath(planCreatePath, reservationIdName);
        LOG.info("Removing state for reservation " + reservationIdName + " from plan " + planName + " at path " + reservationPath);
        this.deleteFileWithRetries(reservationPath);
    }

    @VisibleForTesting
    public int getNumRetries() {
        return this.fsNumRetries;
    }

    @VisibleForTesting
    public long getRetryInterval() {
        return this.fsRetryInterval;
    }

    private void setUnreadableBySuperuserXattrib(Path p) throws IOException {
        if (this.fs.getScheme().toLowerCase().contains("hdfs") && this.intermediateEncryptionEnabled && !this.fs.getXAttrs(p).containsKey(UNREADABLE_BY_SUPERUSER_XATTRIB)) {
            this.fs.setXAttr(p, UNREADABLE_BY_SUPERUSER_XATTRIB, null, EnumSet.of(XAttrSetFlag.CREATE));
        }
    }

    private static interface RMStateFileProcessor {
        public void processChildNode(String var1, String var2, byte[] var3) throws IOException;
    }

    private static class RMAppStateFileProcessor
    implements RMStateFileProcessor {
        private RMStateStore.RMState rmState;
        private List<ApplicationAttemptStateData> attempts;

        public RMAppStateFileProcessor(RMStateStore.RMState rmState, List<ApplicationAttemptStateData> attempts) {
            this.rmState = rmState;
            this.attempts = attempts;
        }

        @Override
        public void processChildNode(String appDirName, String childNodeName, byte[] childData) throws InvalidProtocolBufferException {
            if (childNodeName.startsWith("application")) {
                LOG.debug("Loading application from node: {}", (Object)childNodeName);
                ApplicationStateDataPBImpl appState = new ApplicationStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationStateDataProto.parseFrom(childData));
                ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
                this.rmState.appState.put(appId, appState);
            } else if (childNodeName.startsWith("appattempt")) {
                LOG.debug("Loading application attempt from node: {}", (Object)childNodeName);
                ApplicationAttemptStateDataPBImpl attemptState = new ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto.parseFrom(childData));
                this.attempts.add(attemptState);
            } else {
                LOG.info("Unknown child node with name: " + childNodeName);
            }
        }
    }

    private static class ReservationStateFileProcessor
    implements RMStateFileProcessor {
        private RMStateStore.RMState rmState;

        public ReservationStateFileProcessor(RMStateStore.RMState state) {
            this.rmState = state;
        }

        @Override
        public void processChildNode(String planName, String childNodeName, byte[] childData) throws IOException {
            YarnProtos.ReservationAllocationStateProto allocationState = YarnProtos.ReservationAllocationStateProto.parseFrom((byte[])childData);
            if (!this.rmState.getReservationState().containsKey(planName)) {
                this.rmState.getReservationState().put(planName, new HashMap());
            }
            ReservationId reservationId = ReservationId.parseReservationId((String)childNodeName);
            this.rmState.getReservationState().get(planName).put(reservationId, allocationState);
        }
    }

    private abstract class FSAction<T> {
        private FSAction() {
        }

        abstract T run() throws Exception;

        T runWithRetries() throws Exception {
            int retry = 0;
            while (true) {
                try {
                    return this.run();
                }
                catch (IOException e) {
                    LOG.info("Exception while executing an FS operation.", (Throwable)e);
                    if (++retry > FileSystemRMStateStore.this.fsNumRetries) {
                        LOG.info("Maxed out FS retries. Giving up!");
                        throw e;
                    }
                    LOG.info("Retrying operation on FS. Retry no. " + retry);
                    Thread.sleep(FileSystemRMStateStore.this.fsRetryInterval);
                    continue;
                }
                break;
            }
        }
    }
}

